/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.persistence;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ini.trakem2.display.Patch;
import ini.trakem2.imaging.FastIntegralImage;
import ini.trakem2.imaging.P;
import ini.trakem2.persistence.ImageBytes;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.CachingThread;
import mpicbg.trakem2.util.Downsampler;

public final class DownsamplerMipMaps {
    private static final ImageBytes asBytes(ByteProcessor bp) {
        return new ImageBytes(new byte[][]{(byte[])bp.getPixels()}, bp.getWidth(), bp.getHeight());
    }

    private static final ImageBytes asBytes(ShortProcessor sp) {
        return DownsamplerMipMaps.asBytes((ByteProcessor)sp.convertToByte(true));
    }

    private static final ImageBytes asBytes(FloatProcessor fp) {
        return DownsamplerMipMaps.asBytes((ByteProcessor)fp.convertToByte(true));
    }

    private static final ImageBytes asBytes(ColorProcessor cp) {
        return new ImageBytes(P.asRGBBytes((int[])cp.getPixels()), cp.getWidth(), cp.getHeight());
    }

    private static final ImageBytes asBytes(ByteProcessor bp, ByteProcessor mask) {
        return new ImageBytes(new byte[][]{(byte[])bp.getPixels(), (byte[])mask.getPixels()}, bp.getWidth(), bp.getHeight());
    }

    private static final ImageBytes asBytes(ShortProcessor sp, ByteProcessor mask) {
        return DownsamplerMipMaps.asBytes((ByteProcessor)sp.convertToByte(true), mask);
    }

    private static final ImageBytes asBytes(FloatProcessor fp, ByteProcessor mask) {
        return DownsamplerMipMaps.asBytes((ByteProcessor)fp.convertToByte(true), mask);
    }

    private static final ImageBytes asBytes(ColorProcessor cp, ByteProcessor mask) {
        return new ImageBytes(P.asRGBABytes((int[])cp.getPixels(), (byte[])mask.getPixels(), null), cp.getWidth(), cp.getHeight());
    }

    public static final ImageBytes[] create(Patch patch, int type, ImageProcessor ip, ByteProcessor alpha, ByteProcessor outside, int first_level) throws Exception {
        ByteProcessor ipi;
        byte[] bip;
        Object[] im;
        if (0 == first_level) {
            return DownsamplerMipMaps.create(patch, type, Loader.getHighestMipMapLevel(patch) + 1, ip, alpha, outside);
        }
        if (1 == first_level) {
            ImageBytes[] p = DownsamplerMipMaps.create(patch, type, Loader.getHighestMipMapLevel(patch) + 1, ip, alpha, outside);
            CachingThread.storeForReuse(p[0].c);
            p[0] = null;
            return p;
        }
        ImageBytes[] p = new ImageBytes[Loader.getHighestMipMapLevel(patch) + 1];
        int w = ip.getWidth();
        int h = ip.getHeight();
        int scale_inv = (int)Math.pow(2.0, first_level);
        int tw = w / scale_inv;
        int th = h / scale_inv;
        ByteProcessor bpa = alpha;
        ByteProcessor bpo = outside;
        int type2 = 0;
        if (0 == type) {
            im = FastIntegralImage.longIntegralImage((byte[])ip.getPixels(), w, h);
            bip = FastIntegralImage.scaleAreaAverage(im, w + 1, h + 1, tw, th);
            ipi = new ByteProcessor(tw, th, bip, ip.getColorModel());
        } else if (1 == type) {
            im = FastIntegralImage.longIntegralImage((short[])ip.getPixels(), w, h);
            bip = FastIntegralImage.scaleAreaAverage(im, w + 1, h + 1, tw, th);
            ipi = new ByteProcessor(tw, th, bip, null);
        } else if (2 == type) {
            im = FastIntegralImage.doubleIntegralImage((float[])ip.getPixels(), w, h);
            bip = FastIntegralImage.scaleAreaAverage((double[])im, w + 1, h + 1, tw, th);
            ipi = new ByteProcessor(tw, th, bip, null);
        } else if (4 == type || 3 == type) {
            int[] argb = 3 == type ? (int[])ip.convertToRGB().getPixels() : (int[])ip.getPixels();
            byte[] r = new byte[w * h];
            byte[] g = new byte[r.length];
            byte[] b = new byte[r.length];
            int s = 0;
            for (int i = 0; i < r.length; ++i) {
                s = argb[i];
                r[i] = (byte)((s & 0xFF0000) >> 16);
                g[i] = (byte)((s & 0xFF00) >> 8);
                b[i] = (byte)(s & 0xFF);
            }
            byte[] rs = FastIntegralImage.scaleAreaAverage(FastIntegralImage.longIntegralImage(r, w, h), w + 1, h + 1, tw, th);
            byte[] gs = FastIntegralImage.scaleAreaAverage(FastIntegralImage.longIntegralImage(g, w, h), w + 1, h + 1, tw, th);
            byte[] bs = FastIntegralImage.scaleAreaAverage(FastIntegralImage.longIntegralImage(b, w, h), w + 1, h + 1, tw, th);
            int[] argbs = new int[tw * th];
            for (int i = 0; i < rs.length; ++i) {
                argbs[i] = 0xFF000000 & (rs[i] & 0xFF) << 16 & (gs[i] & 0xFF) << 8 & (bs[i] & 0xFF);
            }
            ipi = new ColorProcessor(tw, th, argbs);
            type2 = 4;
        } else {
            throw new Exception("Unhandable ImagePlus type: " + type);
        }
        if (null != alpha) {
            long[] ima = FastIntegralImage.longIntegralImage((byte[])alpha.getPixels(), w, h);
            byte[] balpha = FastIntegralImage.scaleAreaAverage(ima, w + 1, h + 1, tw, th);
            bpa = new ByteProcessor(tw, th, balpha, alpha.getColorModel());
        }
        if (null != outside) {
            long[] imo = FastIntegralImage.longIntegralImage((byte[])outside.getPixels(), w, h);
            byte[] boutside = FastIntegralImage.scaleAreaAverage(imo, w + 1, h + 1, tw, th);
            bpo = new ByteProcessor(tw, th, boutside, alpha.getColorModel());
        }
        ImageBytes[] ib = DownsamplerMipMaps.create(patch, type2, Loader.getHighestMipMapLevel(patch) + 1 - first_level, (ImageProcessor)ipi, bpa, bpo);
        System.arraycopy(ib, 0, p, first_level, ib.length);
        return p;
    }

    public static final ImageBytes[] create(Patch patch, int type, ImageProcessor ip, ByteProcessor alpha, ByteProcessor outside) {
        return DownsamplerMipMaps.create(patch, type, Loader.getHighestMipMapLevel(patch) + 1, ip, alpha, outside);
    }

    public static final ImageBytes[] create(Patch patch, int type, int n_levels, ImageProcessor ip, ByteProcessor alpha, ByteProcessor outside) {
        ImageBytes[] p = new ImageBytes[n_levels];
        if (null == alpha && null == outside) {
            int i = 1;
            switch (type) {
                case 0: {
                    ByteProcessor bp = (ByteProcessor)ip;
                    p[0] = DownsamplerMipMaps.asBytes(bp);
                    while (i < p.length) {
                        bp = Downsampler.downsampleByteProcessor((ByteProcessor)bp);
                        p[i++] = DownsamplerMipMaps.asBytes(bp);
                    }
                    break;
                }
                case 1: {
                    ShortProcessor sp = (ShortProcessor)ip;
                    p[0] = DownsamplerMipMaps.asBytes(sp);
                    while (i < p.length) {
                        Downsampler.Pair rs = Downsampler.downsampleShort((ShortProcessor)sp);
                        sp = (ShortProcessor)rs.a;
                        p[i++] = new ImageBytes(new byte[][]{(byte[])rs.b}, sp.getWidth(), sp.getHeight());
                    }
                    break;
                }
                case 2: {
                    FloatProcessor fp = (FloatProcessor)ip;
                    p[0] = DownsamplerMipMaps.asBytes(fp);
                    while (i < p.length) {
                        Downsampler.Pair rf = Downsampler.downsampleFloat((FloatProcessor)fp);
                        fp = (FloatProcessor)rf.a;
                        p[i++] = new ImageBytes(new byte[][]{(byte[])rf.b}, fp.getWidth(), fp.getHeight());
                    }
                    break;
                }
                case 4: {
                    ColorProcessor cp = (ColorProcessor)ip;
                    p[0] = DownsamplerMipMaps.asBytes(cp);
                    while (i < p.length) {
                        Downsampler.Pair rc = Downsampler.downsampleColor((ColorProcessor)cp);
                        cp = (ColorProcessor)rc.a;
                        p[i++] = new ImageBytes((byte[][])rc.b, cp.getWidth(), cp.getHeight());
                    }
                    break;
                }
            }
        } else {
            ByteProcessor[] masks = new ByteProcessor[p.length];
            if (null != alpha && null != outside) {
                int i;
                byte[] b1 = (byte[])alpha.getPixels();
                byte[] b2 = (byte[])outside.getPixels();
                for (i = 0; i < b1.length; ++i) {
                    b1[i] = b2[i] != -1 ? (byte)0 : b1[i];
                }
                masks[0] = alpha;
                ByteProcessor a = alpha;
                ByteProcessor o = outside;
                for (i = 1; i < p.length; ++i) {
                    Downsampler.Pair pair = Downsampler.downsampleAlphaAndOutside((ByteProcessor)a, (ByteProcessor)o);
                    a = (ByteProcessor)pair.a;
                    o = (ByteProcessor)pair.b;
                    masks[i] = a;
                }
            } else if (null == alpha) {
                masks[0] = outside;
                for (int i = 1; i < p.length; ++i) {
                    masks[i] = Downsampler.downsampleOutside((ByteProcessor)masks[i - 1]);
                }
            } else {
                masks[0] = alpha;
                for (int i = 1; i < p.length; ++i) {
                    masks[i] = Downsampler.downsampleByteProcessor((ByteProcessor)masks[i - 1]);
                }
            }
            switch (type) {
                case 0: {
                    int i;
                    ByteProcessor bp = (ByteProcessor)ip;
                    p[0] = DownsamplerMipMaps.asBytes(bp, masks[0]);
                    for (i = 1; i < p.length; ++i) {
                        bp = Downsampler.downsampleByteProcessor((ByteProcessor)bp);
                        p[i] = DownsamplerMipMaps.asBytes(bp, masks[i]);
                    }
                    break;
                }
                case 1: {
                    int i;
                    ShortProcessor sp = (ShortProcessor)ip;
                    p[0] = DownsamplerMipMaps.asBytes(sp, masks[0]);
                    while (i < p.length) {
                        Downsampler.Pair rs = Downsampler.downsampleShort((ShortProcessor)sp);
                        sp = (ShortProcessor)rs.a;
                        p[i] = new ImageBytes(new byte[][]{(byte[])rs.b, (byte[])masks[i].getPixels()}, sp.getWidth(), sp.getHeight());
                        ++i;
                    }
                    break;
                }
                case 2: {
                    int i;
                    FloatProcessor fp = (FloatProcessor)ip;
                    p[0] = DownsamplerMipMaps.asBytes(fp, masks[0]);
                    while (i < p.length) {
                        Downsampler.Pair rs = Downsampler.downsampleFloat((FloatProcessor)fp);
                        fp = (FloatProcessor)rs.a;
                        p[i] = new ImageBytes(new byte[][]{(byte[])rs.b, (byte[])masks[i].getPixels()}, fp.getWidth(), fp.getHeight());
                        ++i;
                    }
                    break;
                }
                case 4: {
                    int i;
                    ColorProcessor cp = (ColorProcessor)ip;
                    p[0] = DownsamplerMipMaps.asBytes(cp, masks[0]);
                    while (i < p.length) {
                        Downsampler.Pair rs = Downsampler.downsampleColor((ColorProcessor)cp);
                        cp = (ColorProcessor)rs.a;
                        byte[][] rgb = (byte[][])rs.b;
                        p[i] = new ImageBytes(new byte[][]{rgb[0], rgb[1], rgb[2], (byte[])masks[i].getPixels()}, cp.getWidth(), cp.getHeight());
                        ++i;
                    }
                    break;
                }
            }
        }
        return p;
    }
}

