/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;

public class Kuwahara_Filter
implements PlugInFilter {
    static int size = 5;
    static boolean filterRGB;
    boolean isRGB;

    public int setup(String arg, ImagePlus imp) {
        if (imp == null) {
            return 4096;
        }
        boolean bl = this.isRGB = imp.getBitDepth() == 24;
        if (!this.showDialog()) {
            return 4096;
        }
        return IJ.setupDialog((ImagePlus)imp, (int)87);
    }

    public void run(ImageProcessor ip) {
        if (this.isRGB) {
            if (filterRGB) {
                this.filterRGB(ip);
            } else {
                this.filterIntensity(ip);
            }
        } else {
            this.filter(ip);
        }
    }

    public void filter(ImageProcessor ip) {
        Rectangle roi = ip.getRoi();
        int width = roi.width;
        int height = roi.height;
        int size2 = (size + 1) / 2;
        int offset = (size - 1) / 2;
        int width2 = ip.getWidth() + offset;
        int height2 = ip.getHeight() + offset;
        float[][] mean = new float[width2][height2];
        float[][] variance = new float[width2][height2];
        int x1start = roi.x;
        int y1start = roi.y;
        int v = 0;
        for (int y1 = y1start - offset; y1 < y1start + height; ++y1) {
            if (y1 % 20 == 0) {
                IJ.showProgress((double)(0.7 * (double)(y1 - y1start) / (double)height));
            }
            for (int x1 = x1start - offset; x1 < x1start + width; ++x1) {
                double sum = 0.0;
                double sum2 = 0.0;
                int n = 0;
                for (int x2 = x1; x2 < x1 + size2; ++x2) {
                    for (int y2 = y1; y2 < y1 + size2; ++y2) {
                        v = ip.getPixel(x2, y2);
                        sum += (double)v;
                        sum2 += (double)(v * v);
                        ++n;
                    }
                }
                mean[x1 + offset][y1 + offset] = (float)(sum / (double)n);
                variance[x1 + offset][y1 + offset] = (float)(sum2 - sum * sum / (double)n);
            }
        }
        int xbase2 = 0;
        int ybase2 = 0;
        for (int y1 = y1start; y1 < y1start + height; ++y1) {
            if (y1 % 20 == 0) {
                IJ.showProgress((double)(0.7 + 0.3 * (double)(y1 - y1start) / (double)height));
            }
            for (int x1 = x1start; x1 < x1start + width; ++x1) {
                int xbase = x1;
                int ybase = y1;
                float var = variance[xbase][ybase];
                float min = Float.MAX_VALUE;
                if (var < min) {
                    min = var;
                    xbase2 = xbase;
                    ybase2 = ybase;
                }
                if ((var = variance[xbase = x1 + offset][ybase]) < min) {
                    min = var;
                    xbase2 = xbase;
                    ybase2 = ybase;
                }
                if ((var = variance[xbase][ybase = y1 + offset]) < min) {
                    min = var;
                    xbase2 = xbase;
                    ybase2 = ybase;
                }
                if ((var = variance[xbase = x1][ybase]) < min) {
                    min = var;
                    xbase2 = xbase;
                    ybase2 = ybase;
                }
                ip.putPixel(x1, y1, (int)((double)mean[xbase2][ybase2] + 0.5));
            }
        }
        IJ.showProgress((double)1.0);
    }

    void filterRGB(ImageProcessor ip) {
        ColorProcessor cp = (ColorProcessor)ip;
        int width = cp.getWidth();
        int height = cp.getHeight();
        int size = width * height;
        byte[] R = new byte[size];
        byte[] G = new byte[size];
        byte[] B = new byte[size];
        IJ.showStatus((String)"Kuwahara_Filter: red");
        cp.getRGB(R, G, B);
        ByteProcessor red = new ByteProcessor(width, height, R, null);
        this.filter((ImageProcessor)red);
        IJ.showStatus((String)"Kuwahara_Filter: green");
        ByteProcessor green = new ByteProcessor(width, height, G, null);
        this.filter((ImageProcessor)green);
        IJ.showStatus((String)"Kuwahara_Filter: blue");
        ByteProcessor blue = new ByteProcessor(width, height, B, null);
        this.filter((ImageProcessor)blue);
        cp.setRGB((byte[])red.getPixels(), (byte[])green.getPixels(), (byte[])blue.getPixels());
    }

    void filterIntensity(ImageProcessor ip) {
        ColorProcessor cp = (ColorProcessor)ip;
        int width = cp.getWidth();
        int height = cp.getHeight();
        int size = width * height;
        byte[] H = new byte[size];
        byte[] S = new byte[size];
        byte[] B = new byte[size];
        cp.getHSB(H, S, B);
        ByteProcessor ip2 = new ByteProcessor(width, height, B, null);
        this.filter((ImageProcessor)ip2);
        cp.setHSB(H, S, (byte[])ip2.getPixels());
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("Kuwahara Filter");
        gd.addNumericField("Sampling window width (must be odd):", (double)size, 0, 3, "");
        if (this.isRGB) {
            gd.addCheckbox("Filter all 3 channels (slower)", filterRGB);
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        size = (int)gd.getNextNumber();
        if ((size & 1) != 1) {
            --size;
        }
        if (size < 3) {
            size = 3;
        }
        if (this.isRGB) {
            filterRGB = gd.getNextBoolean();
        }
        return true;
    }
}

