/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddy.regex;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;
import org.jhotdraw.samples.teddy.regex.MatchType;

public class Matcher {
    private Document document;
    private String findString;
    private int startIndex;
    private char[] matchLowerCase;
    private char[] matchUpperCase;
    private MatchType matchType;

    public Matcher(Document document, String findString) {
        this(document, findString, true, MatchType.CONTAINS);
    }

    public Matcher(Document document, String findString, boolean matchCase, MatchType matchType) {
        this.document = document;
        this.findString = findString;
        this.startIndex = 0;
        if (matchCase) {
            this.matchUpperCase = findString.toCharArray();
            this.matchLowerCase = this.matchUpperCase;
        } else {
            this.matchUpperCase = findString.toUpperCase().toCharArray();
            this.matchLowerCase = findString.toLowerCase().toCharArray();
        }
        this.matchType = matchType;
    }

    public String getFindString() {
        return this.findString;
    }

    public boolean isMatchCase() {
        return this.matchLowerCase == this.matchUpperCase;
    }

    public MatchType getMatchType() {
        return this.matchType;
    }

    public void setStartIndex(int newValue) {
        this.startIndex = newValue;
    }

    public int findNext(int startIndex) {
        this.startIndex = startIndex;
        return this.findNext();
    }

    public int findNext() {
        if (this.findString.length() == 0 || this.document.getLength() - this.findString.length() < this.startIndex) {
            return -1;
        }
        try {
            int nextMatch = 0;
            Segment text = new Segment();
            text.setPartialReturn(true);
            int offset = this.startIndex;
            int nleft = this.document.getLength() - this.startIndex;
            while (nleft > 0) {
                this.document.getText(offset, nleft, text);
                char next = text.first();
                text.first();
                while (next != '\uffff') {
                    char current = text.current();
                    if (current == this.matchUpperCase[nextMatch] || current == this.matchLowerCase[nextMatch]) {
                        if (++nextMatch == this.matchLowerCase.length) {
                            int foundIndex = text.getIndex() - text.getBeginIndex() + offset - this.matchLowerCase.length + 1;
                            if (this.matchType == MatchType.CONTAINS) {
                                return foundIndex;
                            }
                            if (this.matchType == MatchType.STARTS_WITH ? !this.isWordChar(foundIndex - 1) : this.matchType == MatchType.FULL_WORD && !this.isWordChar(foundIndex - 1) && !this.isWordChar(foundIndex + this.matchLowerCase.length)) {
                                return foundIndex;
                            }
                            nextMatch = 0;
                        }
                    } else {
                        nextMatch = 0;
                    }
                    next = text.next();
                }
                nleft -= text.count;
                offset += text.count;
            }
            return -1;
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public int findPrevious(int startIndex) {
        this.startIndex = startIndex;
        return this.findPrevious();
    }

    public int findPrevious() {
        if (this.findString.length() == 0 || this.startIndex < this.findString.length() - 1) {
            return -1;
        }
        try {
            int nextMatch = this.matchLowerCase.length - 1;
            Segment text = new Segment();
            text.setPartialReturn(false);
            this.document.getText(0, this.startIndex + 1, text);
            char previous = text.last();
            text.last();
            while (previous != '\uffff') {
                char current = text.current();
                if (current == this.matchUpperCase[nextMatch] || current == this.matchLowerCase[nextMatch]) {
                    if (--nextMatch == -1) {
                        int foundIndex = text.getIndex() - text.getBeginIndex();
                        if (this.matchType == MatchType.CONTAINS) {
                            return foundIndex;
                        }
                        if (this.matchType == MatchType.STARTS_WITH ? !this.isWordChar(foundIndex - 1) : this.matchType == MatchType.FULL_WORD && !this.isWordChar(foundIndex - 1) && !this.isWordChar(foundIndex + this.matchLowerCase.length)) {
                            return foundIndex;
                        }
                        nextMatch = this.matchLowerCase.length - 1;
                    }
                } else {
                    nextMatch = this.matchLowerCase.length - 1;
                }
                previous = text.previous();
            }
            return -1;
        }
        catch (BadLocationException e) {
            throw new IndexOutOfBoundsException();
        }
    }

    public void reset() {
        this.startIndex = 0;
    }

    private boolean isWordChar(int index) {
        try {
            char ch = this.document.getText(index, 1).charAt(0);
            return Character.isLetterOrDigit(ch);
        }
        catch (BadLocationException e) {
            return false;
        }
    }
}

