/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration;

import java.util.ArrayList;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.io.LOCI;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.spim.fusion.FusionControl;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.registration.ViewDataBeads;
import mpicbg.spim.registration.bead.BeadRegistration;
import mpicbg.spim.registration.bead.BeadSegmentation;
import mpicbg.spim.registration.bead.error.GlobalErrorStatistics;
import mpicbg.spim.registration.bead.error.GlobalErrorStatisticsImpl;

public class ViewStructure {
    public static final int DEBUG_ALL = 0;
    public static final int DEBUG_MAIN = 1;
    public static final int DEBUG_ERRORONLY = 2;
    public static int firstID = 0;
    protected final ArrayList<ViewDataBeads> views;
    protected final int timePoint;
    protected final int numChannels;
    protected final String identification;
    protected int debugLevel;
    protected final SPIMConfiguration conf;
    protected GlobalErrorStatistics errorStatistics;
    protected BeadSegmentation beadSegment;
    protected BeadRegistration beadRegister;
    protected FusionControl fusionControl;

    public ViewStructure(ArrayList<ViewDataBeads> views, SPIMConfiguration conf, String id, int timePoint, int numChannels) {
        this(views, conf, id, timePoint, numChannels, 1);
    }

    public ViewStructure(ArrayList<ViewDataBeads> views, SPIMConfiguration conf, String id, int timePoint, int numChannels, int debugLevel) {
        this.views = views;
        this.identification = id;
        this.conf = conf;
        this.timePoint = timePoint;
        this.numChannels = numChannels;
        this.setDebugLevel(debugLevel);
        this.errorStatistics = new GlobalErrorStatisticsImpl();
        this.beadSegment = new BeadSegmentation(this);
        for (ViewDataBeads view : views) {
            view.setViewStructure(this);
        }
        for (ViewDataBeads view : views) {
            view.initErrorStatistics();
        }
        this.beadSegment = new BeadSegmentation(this);
        this.beadRegister = new BeadRegistration(this);
        this.fusionControl = new FusionControl();
    }

    public BeadSegmentation getBeadSegmentation() {
        return this.beadSegment;
    }

    public BeadRegistration getBeadRegistration() {
        return this.beadRegister;
    }

    public FusionControl getFusionControl() {
        return this.fusionControl;
    }

    public int getNumViews() {
        return this.getViews().size();
    }

    public int getNumChannels() {
        return this.numChannels;
    }

    public int getChannelNum(int channelIndex) {
        for (ViewDataBeads view : this.getViews()) {
            if (view.getChannelIndex() != channelIndex) continue;
            return view.getChannel();
        }
        return -1;
    }

    public GlobalErrorStatistics getGlobalErrorStatistics() {
        return this.errorStatistics;
    }

    public void setGlobalErrorStatistics(GlobalErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int debugLevel) {
        this.debugLevel = debugLevel;
    }

    public int getTimePoint() {
        return this.timePoint;
    }

    public SPIMConfiguration getSPIMConfiguration() {
        return this.conf;
    }

    public String toString() {
        return this.identification;
    }

    public String getID() {
        return this.identification;
    }

    public ArrayList<ViewDataBeads> getViews() {
        return this.views;
    }

    public ViewDataBeads getViewFromID(int viewID) {
        if (viewID < this.views.size() && this.views.get(viewID).getID() == viewID) {
            return this.views.get(viewID);
        }
        for (ViewDataBeads view : this.views) {
            if (view.getID() != viewID) continue;
            return view;
        }
        return null;
    }

    public int getNumDimensions() {
        return this.views.get(0).getImageSize().length;
    }

    public boolean loadSegmentations() {
        for (ViewDataBeads view : this.getViews()) {
            boolean readSeg;
            if (!view.getUseForRegistration() || (readSeg = IOFunctions.readSegmentation(view, this.conf.registrationFiledirectory, this.conf))) continue;
            if (this.debugLevel <= 2) {
                IOFunctions.printErr("Cannot read segmentation for " + view);
            }
            return false;
        }
        return true;
    }

    public boolean loadRegistrations() {
        boolean success = true;
        for (ViewDataBeads view : this.getViews()) {
            boolean readReg = view.loadRegistration();
            if (readReg) continue;
            if (this.getDebugLevel() <= 2) {
                IOFunctions.printErr("Cannot read registration for view " + view + " in " + this);
            }
            success = false;
        }
        return success;
    }

    public boolean loadDimensions() {
        boolean success = true;
        for (ViewDataBeads view : this.getViews()) {
            boolean readDim = view.loadDimensions();
            if (readDim) continue;
            if (this.getDebugLevel() <= 2) {
                IOFunctions.printErr("Cannot read dimensions for view " + view + " in " + this);
            }
            success = false;
        }
        return success;
    }

    public static <M extends AbstractAffineModel3D<M>> ViewStructure initViewStructure(SPIMConfiguration conf, int timePointIndex, M model, String id, int debugLevel) {
        double zStretching;
        ArrayList<ViewDataBeads> views = new ArrayList<ViewDataBeads>();
        if (conf.overrideImageZStretching) {
            zStretching = conf.zStretching;
        } else if (conf.isHuiskenFormat()) {
            IOFunctions.println("Reading z-stretching from xml.");
            zStretching = conf.getZStretchingHuisken();
            IOFunctions.println("z-stretching = " + zStretching);
        } else {
            IOFunctions.println("Opening first image to determine z-stretching.");
            Image image = LOCI.openLOCIFloatType((String)conf.file[timePointIndex][0][0][0].getPath(), (ContainerFactory)conf.inputImageFactory);
            if (image == null) {
                IOFunctions.println("Cannot open fie: '" + conf.file[timePointIndex][0][0][0].getPath() + "'");
                return null;
            }
            zStretching = image.getCalibration(2) / image.getCalibration(0);
            IOFunctions.println("z-stretching = " + zStretching);
            image.close();
        }
        int idNr = firstID;
        int numChannels = conf.file[timePointIndex].length;
        IOFunctions.println("Using model: " + model.getClass().getCanonicalName());
        for (int c = 0; c < conf.file[timePointIndex].length; ++c) {
            for (int a = 0; a < conf.file[timePointIndex][c].length; ++a) {
                for (int i = 0; i < conf.file[timePointIndex][c][a].length; ++i) {
                    ViewDataBeads view = new ViewDataBeads(idNr++, (AbstractAffineModel3D)model.copy(), conf.file[timePointIndex][c][a][i].getPath(), zStretching);
                    int channelRegister = 0;
                    view.setAcqusitionAngle(conf.angles[a]);
                    view.setChannel(conf.channels[c]);
                    view.setChannelIndex(c);
                    view.setTimePoint(conf.timepoints[timePointIndex]);
                    view.setIllumination(conf.illuminations[i]);
                    if (numChannels == 1) {
                        view.setUseForFusion(true);
                        view.setUseForRegistration(true);
                        view.setInitialSigma(conf.initialSigma[channelRegister]);
                        view.setMinPeakValue(conf.minPeakValue[channelRegister]);
                        view.setIntegralRadius1(conf.integralImgRadius1[channelRegister]);
                        view.setIntegralRadius2(conf.integralImgRadius2[channelRegister]);
                        view.setIntegralThreshold(conf.integralImgThreshold[channelRegister]);
                    } else {
                        boolean contains = false;
                        for (int cR : conf.channelsRegister) {
                            if (cR != view.getChannel()) continue;
                            contains = true;
                        }
                        view.setUseForRegistration(contains);
                        if (contains) {
                            view.setInitialSigma(conf.initialSigma[channelRegister]);
                            view.setMinPeakValue(conf.minPeakValue[channelRegister]);
                            view.setIntegralRadius1(conf.integralImgRadius1[channelRegister]);
                            view.setIntegralRadius2(conf.integralImgRadius2[channelRegister]);
                            view.setIntegralThreshold(conf.integralImgThreshold[channelRegister]);
                            ++channelRegister;
                        }
                        contains = false;
                        int[] nArray = conf.channelsFuse;
                        int n = nArray.length;
                        for (int j = 0; j < n; ++j) {
                            int cF = nArray[j];
                            if (cF != view.getChannel()) continue;
                            contains = true;
                        }
                        view.setUseForFusion(contains);
                    }
                    if (conf.channelsMirror != null) {
                        for (int[] mirror : conf.channelsMirror) {
                            if (conf.channels[c] != mirror[0]) continue;
                            if (mirror[1] == 0) {
                                view.setMirrorHorizontally(true);
                            }
                            if (mirror[1] != 1) continue;
                            view.setMirrorVertically(true);
                        }
                    }
                    views.add(view);
                }
            }
        }
        ViewStructure viewStructure = new ViewStructure(views, conf, id, conf.timepoints[timePointIndex], numChannels, debugLevel);
        return viewStructure;
    }
}

