/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import ij.ImageJ;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import spim.fiji.spimdata.imgloaders.NumberUtils;

public class MultipageTiffReader {
    private static final long BIGGEST_INT_BIT = (long)Math.pow(2.0, 31.0);
    public static final int INDEX_MAP_HEADER = 3453623;
    public static final int DISPLAY_SETTINGS_OFFSET_HEADER = 483765892;
    public static final int DISPLAY_SETTINGS_HEADER = 347834724;
    public static final int INDEX_MAP_OFFSET_HEADER = 54773648;
    public static final int SUMMARY_MD_HEADER = 2355492;
    public static final int COMMENTS_OFFSET_HEADER = 99384722;
    public static final int COMMENTS_HEADER = 84720485;
    public static final char BITS_PER_SAMPLE = '\u0102';
    public static final char STRIP_OFFSETS = '\u0111';
    public static final char SAMPLES_PER_PIXEL = '\u0115';
    public static final char STRIP_BYTE_COUNTS = '\u0117';
    public static final char IMAGE_DESCRIPTION = '\u010e';
    public static final char MM_METADATA = '\uc7b3';
    public static String lastDisplayedFile;
    private ByteOrder byteOrder_;
    private List<File> files;
    private List<RandomAccessFile> raFiles;
    private List<FileChannel> fileChannels;
    private HashMap<String, Object> summaryMetadata_;
    private int byteDepth_ = 0;
    private boolean rgb_;
    protected String unit = "um";
    protected double calX = Double.NaN;
    protected double calY = Double.NaN;
    protected double calZ = Double.NaN;
    protected double[] rotAxis = null;
    protected boolean applyAxis = true;
    protected List<String> angleNames = null;
    protected List<String> channelNames = null;
    private HashMap<String, Pair<Long, FileChannel>> indexMap_;

    public MultipageTiffReader(File file) throws IOException {
        this.files = new ArrayList<File>();
        this.raFiles = new ArrayList<RandomAccessFile>();
        this.fileChannels = new ArrayList<FileChannel>();
        int i = 0;
        try {
            this.files.add(file);
            if (file.getAbsolutePath().toLowerCase().endsWith(".ome.tif") || file.getAbsolutePath().toLowerCase().endsWith(".ome.tiff")) {
                String begin = file.getName().substring(0, file.getName().toLowerCase().indexOf(".ome.tif"));
                File dir = file.getParentFile();
                Object[] list = dir.list();
                Arrays.sort(list);
                for (Object fn : list) {
                    if ((((String)fn).equals(file.getName()) || !((String)fn).startsWith(begin) || !((String)fn).toLowerCase().endsWith(".ome.tif")) && !((String)fn).toLowerCase().endsWith(".ome.tiff")) continue;
                    this.files.add(new File(dir, (String)fn));
                }
            }
            if (lastDisplayedFile == null) {
                lastDisplayedFile = "";
            }
            if (!lastDisplayedFile.equals(file.getAbsolutePath())) {
                IOFunctions.printlnSafe("Using the following files for the MicroManager ImgLoader: ");
            }
            for (i = 0; i < this.files.size(); ++i) {
                File f = this.files.get(i);
                if (!lastDisplayedFile.equals(file.getAbsolutePath())) {
                    IOFunctions.printlnSafe(f.getAbsolutePath());
                }
                this.raFiles.add(new RandomAccessFile(f, "rw"));
                this.fileChannels.add(this.raFiles.get(this.raFiles.size() - 1).getChannel());
            }
            lastDisplayedFile = file.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Can't successfully open file: " + this.files.get(i).getName() + ": " + e);
        }
        for (i = this.fileChannels.size() - 1; i >= 0; --i) {
            this.readHeader(this.fileChannels.get(i));
        }
        this.summaryMetadata_ = new HashMap();
        for (i = this.fileChannels.size() - 1; i >= 0; --i) {
            this.readSummaryMD(this.fileChannels.get(i), this.summaryMetadata_);
        }
        if (this.summaryMetadata_ == null) {
            throw new IOException("Could not read metadata");
        }
        this.indexMap_ = new HashMap();
        try {
            for (i = 0; i < this.files.size(); ++i) {
                this.readIndexMap(this.fileChannels.get(i), this.indexMap_);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException("Reading of dataset unsuccessful for file: " + this.files.get(i).getName());
        }
    }

    public String getPixelType() {
        try {
            if (this.summaryMetadata_ != null) {
                return this.summaryMetadata_.get("PixelType").toString();
            }
        }
        catch (Exception e) {
            try {
                int ijType = Integer.parseInt(this.summaryMetadata_.get("IJType").toString());
                if (ijType == 0) {
                    return "GRAY8";
                }
                if (ijType == 1) {
                    return "GRAY16";
                }
                if (ijType == 2) {
                    return "GRAY32";
                }
                if (ijType == 4) {
                    return "RGB32";
                }
                throw new RuntimeException("Can't figure out pixel type");
            }
            catch (Exception e2) {
                throw new RuntimeException("Can't figure out pixel type");
            }
        }
        return "";
    }

    public void setAngleNames(List<String> names) {
        this.angleNames = names;
    }

    public void setChannelNames(List<String> names) {
        this.channelNames = names;
    }

    private void getRGBAndByteDepth(HashMap<String, Object> map) {
        try {
            String pixelType = this.getPixelType();
            this.rgb_ = pixelType.startsWith("RGB");
            this.byteDepth_ = pixelType.equals("RGB32") || pixelType.equals("GRAY8") ? 1 : 2;
        }
        catch (Exception ex) {
            IOFunctions.printlnSafe(ex);
        }
    }

    public HashMap<String, Object> getSummaryMetadata() {
        return this.summaryMetadata_;
    }

    public Pair<Object, HashMap<String, Object>> readImage(String label) {
        if (this.indexMap_.containsKey(label)) {
            FileChannel fileChannel = (FileChannel)this.indexMap_.get(label).getB();
            if (fileChannel == null) {
                IOFunctions.printlnSafe("Attempted to read image on FileChannel that is null");
                return null;
            }
            try {
                long byteOffset = (Long)this.indexMap_.get(label).getA();
                IFDData data = this.readIFD(byteOffset, fileChannel);
                return this.readTaggedImage(data, fileChannel);
            }
            catch (IOException ex) {
                IOFunctions.printlnSafe(ex);
                return null;
            }
        }
        IOFunctions.printlnSafe("Exception: label '" + label + "' not in present in hashmap, cannot read data.");
        return null;
    }

    public Set<String> getIndexKeys() {
        if (this.indexMap_ == null) {
            return null;
        }
        return this.indexMap_.keySet();
    }

    private boolean readSummaryMD(FileChannel fileChannel, HashMap<String, Object> summaryMD_) {
        try {
            ByteBuffer mdInfo = ByteBuffer.allocate(8).order(this.byteOrder_);
            fileChannel.read(mdInfo, 32L);
            int header = mdInfo.getInt(0);
            int length = mdInfo.getInt(4);
            if (header != 2355492) {
                IOFunctions.printlnSafe("Summary Metadata Header Incorrect");
                return false;
            }
            ByteBuffer mdBuffer = ByteBuffer.allocate(length).order(this.byteOrder_);
            fileChannel.read(mdBuffer, 40L);
            HashMap<String, Object> summaryMD = this.parseJSONSimple(this.getString(mdBuffer));
            if (summaryMD == null) {
                IOFunctions.printlnSafe("Couldn't read summary Metadata from file: " + this.getFileForFileChannel(fileChannel).getName());
            }
            if (!summaryMD.containsKey("MVRotationAxis")) {
                summaryMD.put("MVRotationAxis", "0_1_0");
            }
            if (!summaryMD.containsKey("MVRotations")) {
                int numChannels = Integer.parseInt(summaryMD.get("Channels").toString());
                if (numChannels == 2) {
                    summaryMD.put("MVRotations", "0_90");
                } else if (numChannels == 4) {
                    summaryMD.put("MVRotations", "0_90_0_90");
                } else if (numChannels == 6) {
                    summaryMD.put("MVRotations", "0_90_0_90_0_90");
                }
            }
            summaryMD_.putAll(summaryMD);
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            IOFunctions.printlnSafe("Couldn't read summary Metadata from file: " + this.getFileForFileChannel(fileChannel).getName());
            return false;
        }
    }

    private File getFileForFileChannel(FileChannel fileChannel) {
        File file = null;
        for (int i = 0; i < this.fileChannels.size(); ++i) {
            if (this.fileChannels.get(i) != fileChannel) continue;
            file = this.files.get(i);
            break;
        }
        return file;
    }

    protected HashMap<String, Object> parseJSONSimple(String json) {
        String jsonString = json.trim();
        jsonString = jsonString.substring(1, jsonString.length() - 1);
        HashMap<String, Object> map = new HashMap<String, Object>();
        do {
            int valueEnd;
            if (!jsonString.startsWith("\"")) {
                IOFunctions.printlnSafe("Failed to parse json string: " + json);
                return null;
            }
            String key = jsonString.substring(1, jsonString.indexOf(34, 1));
            int valueStart = jsonString.indexOf("\":") + 2;
            if (jsonString.charAt(valueStart) == '[') {
                valueEnd = jsonString.indexOf(93) + 1;
            } else if (valueStart + 1 < jsonString.length() && jsonString.charAt(valueStart + 1) == '{') {
                valueEnd = jsonString.indexOf("}\"") + 2;
            } else if (jsonString.charAt(valueStart) == '\"') {
                valueEnd = jsonString.indexOf(34, ++valueStart);
            } else {
                valueEnd = jsonString.indexOf(44);
                if (valueEnd == -1) {
                    valueEnd = jsonString.length();
                }
            }
            String value = jsonString.substring(valueStart, valueEnd);
            int nextComma = jsonString.indexOf(44, valueEnd);
            jsonString = nextComma == -1 ? "" : jsonString.substring(nextComma + 1, jsonString.length());
            map.put(key, value);
        } while (jsonString.length() > 0);
        return map;
    }

    private ByteBuffer readIntoBuffer(long position, int length, FileChannel fileChannel_) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(length).order(this.byteOrder_);
        fileChannel_.read(buffer, position);
        return buffer;
    }

    private long readOffsetHeaderAndOffset(int offsetHeaderVal, int startOffset, FileChannel fileChannel_) throws IOException {
        ByteBuffer buffer1 = this.readIntoBuffer(startOffset, 8, fileChannel_);
        int offsetHeader = buffer1.getInt(0);
        if (offsetHeader != offsetHeaderVal) {
            throw new IOException("Offset header incorrect, expected: " + offsetHeaderVal + "   found: " + offsetHeader);
        }
        return MultipageTiffReader.unsignInt(buffer1.getInt(4));
    }

    public static String generateLabel(int channel, int slice, int frame, int position) {
        return NumberUtils.intToCoreString(channel) + "_" + NumberUtils.intToCoreString(slice) + "_" + NumberUtils.intToCoreString(frame) + "_" + NumberUtils.intToCoreString(position);
    }

    private void readIndexMap(FileChannel fileChannel, HashMap<String, Pair<Long, FileChannel>> indexMap_) throws IOException {
        long offset = this.readOffsetHeaderAndOffset(54773648, 8, fileChannel);
        ByteBuffer header = this.readIntoBuffer(offset, 8, fileChannel);
        if (header.getInt(0) != 3453623) {
            throw new RuntimeException("Error reading index map header");
        }
        int numMappings = header.getInt(4);
        ByteBuffer mapBuffer = this.readIntoBuffer(offset + 8L, 20 * numMappings, fileChannel);
        for (int i = 0; i < numMappings; ++i) {
            int channel = mapBuffer.getInt(i * 20);
            int slice = mapBuffer.getInt(i * 20 + 4);
            int frame = mapBuffer.getInt(i * 20 + 8);
            int position = mapBuffer.getInt(i * 20 + 12);
            long imageOffset = MultipageTiffReader.unsignInt(mapBuffer.getInt(i * 20 + 16));
            if (imageOffset == 0L) break;
            String label = MultipageTiffReader.generateLabel(channel, slice, frame, position);
            if (indexMap_.containsKey(label)) {
                IOFunctions.printlnSafe("ERROR!!! Label: " + label + " already present.");
            }
            indexMap_.put(label, (Pair<Long, FileChannel>)new ValuePair((Object)imageOffset, (Object)fileChannel));
        }
    }

    private IFDData readIFD(long byteOffset, FileChannel fileChannel) throws IOException {
        ByteBuffer buff = this.readIntoBuffer(byteOffset, 2, fileChannel);
        int numEntries = buff.getChar(0);
        ByteBuffer entries = this.readIntoBuffer(byteOffset + 2L, numEntries * 12 + 4, fileChannel).order(this.byteOrder_);
        IFDData data = new IFDData();
        for (int i = 0; i < numEntries; ++i) {
            IFDEntry entry = this.readDirectoryEntry(i * 12, entries);
            if (entry.tag == '\uc7b3') {
                data.mdOffset = entry.value;
                data.mdLength = entry.count;
                continue;
            }
            if (entry.tag == '\u0111') {
                data.pixelOffset = entry.value;
                continue;
            }
            if (entry.tag != '\u0117') continue;
            data.bytesPerImage = entry.value;
        }
        data.nextIFD = MultipageTiffReader.unsignInt(entries.getInt(numEntries * 12));
        data.nextIFDOffsetLocation = byteOffset + 2L + (long)(numEntries * 12);
        return data;
    }

    private String getString(ByteBuffer buffer) {
        try {
            return new String(buffer.array(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            IOFunctions.printlnSafe(ex);
            return "";
        }
    }

    private Pair<Object, HashMap<String, Object>> readTaggedImage(IFDData data, FileChannel fileChannel) throws IOException {
        ByteBuffer pixelBuffer = ByteBuffer.allocate((int)data.bytesPerImage).order(this.byteOrder_);
        ByteBuffer mdBuffer = ByteBuffer.allocate((int)data.mdLength).order(this.byteOrder_);
        fileChannel.read(pixelBuffer, data.pixelOffset);
        fileChannel.read(mdBuffer, data.mdOffset);
        HashMap<String, Object> md = this.parseJSONSimple(this.getString(mdBuffer));
        if (this.byteDepth_ == 0) {
            this.getRGBAndByteDepth(md);
        }
        if (this.rgb_) {
            IOFunctions.printlnSafe("RGB types not supported.");
            return null;
        }
        if (this.byteDepth_ == 1) {
            return new ValuePair((Object)pixelBuffer.array(), md);
        }
        short[] pix = new short[pixelBuffer.capacity() / 2];
        for (int i = 0; i < pix.length; ++i) {
            pix[i] = pixelBuffer.getShort(i * 2);
        }
        return new ValuePair((Object)pix, md);
    }

    private IFDEntry readDirectoryEntry(int offset, ByteBuffer buffer) throws IOException {
        char tag = buffer.getChar(offset);
        char type = buffer.getChar(offset + 2);
        long count = MultipageTiffReader.unsignInt(buffer.getInt(offset + 4));
        long value = type == '\u0003' && count == 1L ? (long)buffer.getChar(offset + 8) : MultipageTiffReader.unsignInt(buffer.getInt(offset + 8));
        return new IFDEntry(tag, type, count, value);
    }

    private long readHeader(FileChannel fileChannel) throws IOException {
        ByteBuffer tiffHeader = ByteBuffer.allocate(8);
        fileChannel.read(tiffHeader, 0L);
        char zeroOne = tiffHeader.getChar(0);
        if (zeroOne == '\u4949') {
            this.byteOrder_ = ByteOrder.LITTLE_ENDIAN;
        } else if (zeroOne == '\u4d4d') {
            this.byteOrder_ = ByteOrder.BIG_ENDIAN;
        } else {
            throw new IOException("Error reading Tiff header");
        }
        tiffHeader.order(this.byteOrder_);
        short twoThree = tiffHeader.getShort(2);
        if (twoThree != 42) {
            throw new IOException("Tiff identifier code incorrect");
        }
        return MultipageTiffReader.unsignInt(tiffHeader.getInt(4));
    }

    public void close() throws IOException {
        for (FileChannel fileChannel : this.fileChannels) {
            if (fileChannel == null) continue;
            fileChannel.close();
        }
        this.fileChannels.clear();
        for (RandomAccessFile raFile : this.raFiles) {
            if (raFile == null) continue;
            raFile.close();
        }
        this.raFiles.clear();
    }

    public void setApplyAxis(boolean apply) {
        this.applyAxis = apply;
    }

    public boolean applyAxis() {
        return this.applyAxis;
    }

    public void setCalX(double cal) {
        this.calX = cal;
    }

    public void setCalY(double cal) {
        this.calY = cal;
    }

    public void setCalZ(double cal) {
        this.calZ = cal;
    }

    public void setCalUnit(String unit) {
        this.unit = unit;
    }

    public int width() {
        return Integer.parseInt(this.summaryMetadata_.get("Width").toString());
    }

    public int height() {
        return Integer.parseInt(this.summaryMetadata_.get("Height").toString());
    }

    public int depth() {
        return Integer.parseInt(this.summaryMetadata_.get("Slices").toString());
    }

    public double calX() {
        if (Double.isNaN(this.calX)) {
            double x = Double.parseDouble(this.summaryMetadata_.get("PixelSize_um").toString());
            if (x <= 0.0) {
                return 1.0;
            }
            return x;
        }
        return this.calX;
    }

    public double calY() {
        if (Double.isNaN(this.calY)) {
            double y = Double.parseDouble(this.summaryMetadata_.get("PixelSize_um").toString());
            if (y <= 0.0) {
                return 1.0;
            }
            return y;
        }
        return this.calY;
    }

    public double calZ() {
        if (Double.isNaN(this.calZ)) {
            Object o = this.summaryMetadata_.get("z-step_um");
            if (o == null) {
                return 1.0;
            }
            double z = Double.parseDouble(o.toString());
            if (z <= 0.0) {
                return 1.0;
            }
            return z;
        }
        return this.calZ;
    }

    public String calUnit() {
        return this.unit;
    }

    public int numTimepoints() {
        return Integer.parseInt(this.summaryMetadata_.get("Frames").toString());
    }

    public int numPositions() {
        return Integer.parseInt(this.summaryMetadata_.get("Positions").toString());
    }

    public int numChannelsAndAngles() {
        return Integer.parseInt(this.summaryMetadata_.get("Channels").toString());
    }

    public int numChannels() {
        int numAngles;
        int totalNum = this.numChannelsAndAngles();
        if (totalNum % (numAngles = this.numAngles()) != 0) {
            throw new RuntimeException("Channels & Angle number is not symmetric. This is not supported. TotalNumCh=" + totalNum + ", numAngles=" + numAngles);
        }
        return totalNum / this.numAngles();
    }

    public int numAngles() {
        String ac = this.summaryMetadata_.get("MVRotations").toString().trim();
        String[] entries = ac.split("_");
        HashSet<Integer> uniqueAngles = new HashSet<Integer>();
        for (int i = 0; i < entries.length; ++i) {
            uniqueAngles.add(Integer.parseInt(entries[i]));
        }
        return uniqueAngles.size();
    }

    public String rotationAngle(int angleId) {
        if (angleId < 0 || angleId >= this.numAngles()) {
            IOFunctions.printlnSafe("No angle with id " + angleId + ", there are only " + this.numAngles() + " angles.");
            return String.valueOf(angleId);
        }
        if (this.angleNames != null) {
            return this.angleNames.get(angleId);
        }
        try {
            String ac = this.summaryMetadata_.get("MVRotations").toString().trim();
            String[] entries = ac.split("_");
            return entries[angleId];
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("Failed to get rotation angle: " + e);
            return "0";
        }
    }

    public int interleavedId(int channelId, int angleId) {
        return channelId * this.numAngles() + angleId;
    }

    public String channelName(int channelId) {
        if (channelId < 0 || channelId >= this.numChannels()) {
            IOFunctions.printlnSafe("No channel with id " + channelId + ", there are only " + this.numChannels() + " channels.");
            return String.valueOf(channelId);
        }
        if (this.channelNames != null) {
            return this.channelNames.get(channelId);
        }
        try {
            String[] entries;
            String as = this.summaryMetadata_.get("ChNames").toString().trim();
            if (as.startsWith("[") && as.endsWith("]")) {
                as = as.substring(1, as.length() - 1);
            }
            if ((entries = as.split(",")).length != this.numChannelsAndAngles()) {
                IOFunctions.printlnSafe("Number of entries in " + this.summaryMetadata_.get("ChNames").toString().trim() + " does not match numAngles()*numChannels()=" + this.numChannelsAndAngles());
                return String.valueOf(channelId);
            }
            String entry = entries[this.interleavedId(channelId, 0)];
            if (entry.indexOf(45) > 0) {
                return entry.substring(entry.indexOf(45) + 1, entry.length() - 1);
            }
            return entry.substring(1, entry.length() - 1);
        }
        catch (Exception e) {
            IOFunctions.printlnSafe("Failed to parse channel name: " + e);
            return String.valueOf(channelId);
        }
    }

    public String rotationAxisName() {
        double[] r = this.rotationAxis();
        if (r[0] == 1.0 && r[1] == 0.0 && r[2] == 0.0) {
            return "X-Axis";
        }
        if (r[0] == 0.0 && r[1] == 1.0 && r[2] == 0.0) {
            return "Y-Axis";
        }
        if (r[0] == 0.0 && r[0] == 1.0 && r[1] == 0.0) {
            return "Z-Axis";
        }
        return "Rotation Axis Vector: " + Util.printCoordinates((double[])r);
    }

    public int rotationAxisIndex() {
        double[] r = this.rotationAxis();
        if (r[0] == 1.0 && r[1] == 0.0 && r[2] == 0.0) {
            return 0;
        }
        if (r[0] == 0.0 && r[1] == 1.0 && r[2] == 0.0) {
            return 1;
        }
        if (r[0] == 0.0 && r[0] == 1.0 && r[1] == 0.0) {
            return 2;
        }
        return -1;
    }

    public void setRotAxis(double[] axis) {
        this.rotAxis = axis;
    }

    public double[] rotationAxis() {
        if (this.rotAxis == null) {
            String as = this.summaryMetadata_.get("MVRotationAxis").toString();
            String[] v = as.split("_");
            double x = Double.parseDouble(v[0].trim());
            double y = Double.parseDouble(v[1].trim());
            double z = Double.parseDouble(v[2].trim());
            return new double[]{x, y, z};
        }
        return this.rotAxis;
    }

    private static final long unsignInt(int i) {
        long val = Integer.MAX_VALUE & i;
        if (i < 0) {
            val += BIGGEST_INT_BIT;
        }
        return val;
    }

    public static void main(String[] args) throws IOException {
        int i;
        File f = new File("/Users/preibischs/Documents/Microscopy/SPIM/561D", "MMStack_Pos0.ome.tif");
        MultipageTiffReader r = new MultipageTiffReader(f);
        for (String k : r.getSummaryMetadata().keySet()) {
            System.out.println(k + ": " + r.getSummaryMetadata().get(k));
        }
        String pixelType = r.getPixelType();
        if (pixelType.toUpperCase().startsWith("RGB")) {
            IOFunctions.println("RGB not supported.");
            return;
        }
        System.out.println("width: " + r.width());
        System.out.println("height: " + r.height());
        System.out.println("depth: " + r.depth());
        System.out.println("calX: " + r.calX());
        System.out.println("calY: " + r.calY());
        System.out.println("calZ: " + r.calZ());
        System.out.println("numAngles: " + r.numAngles());
        System.out.println("rotation axis: " + Util.printCoordinates((double[])r.rotationAxis()));
        for (i = 0; i < r.numAngles(); ++i) {
            System.out.println("angle " + i + " rotation: " + r.rotationAngle(i));
        }
        System.out.println("numChannels: " + r.numChannels());
        for (i = 0; i < r.numChannels(); ++i) {
            System.out.println("channel " + i + " name: " + r.channelName(i));
        }
        System.out.println("numTimepoints: " + r.numTimepoints());
        System.out.println("numPositions: " + r.numPositions());
        boolean c = false;
        boolean a = true;
        int s = 20;
        boolean t = false;
        boolean p = false;
        String label = MultipageTiffReader.generateLabel(r.interleavedId(0, 1), 20, 0, 0);
        Object o = r.readImage(label).getA();
        System.out.println(label);
        System.out.println(r.indexMap_.get(label));
        new ImageJ();
        if (!(o instanceof byte[]) && o instanceof short[]) {
            System.out.println(((short[])o).length);
            ImageJFunctions.show((RandomAccessibleInterval)ArrayImgs.unsignedShorts((short[])((short[])o), (long[])new long[]{r.width(), r.height()}));
        }
    }

    public class IFDEntry {
        public final char tag;
        public final char type;
        public final long count;
        public final long value;

        public IFDEntry(char tg, char typ, long cnt, long val) {
            this.tag = tg;
            this.type = typ;
            this.count = cnt;
            this.value = val;
        }
    }

    public class IFDData {
        public long pixelOffset;
        public long bytesPerImage;
        public long mdOffset;
        public long mdLength;
        public long nextIFD;
        public long nextIFDOffsetLocation;
    }
}

