/*
 * Decompiled with CFR 0.152.
 */
package spim.process.cuda;

public class CUDADevice
implements Comparable<CUDADevice> {
    final String name;
    final long totalMem;
    final long freeMem;
    final int id;
    final int majorComputeVersion;
    final int minorComputeVersion;

    public CUDADevice(int id, String name, long totalMem, long freeMem, int majorComputeVersion, int minorComputeVersion) {
        this.id = id;
        this.name = name;
        this.totalMem = totalMem;
        this.freeMem = freeMem;
        this.majorComputeVersion = majorComputeVersion;
        this.minorComputeVersion = minorComputeVersion;
    }

    public int getDeviceId() {
        return this.id;
    }

    public String getDeviceName() {
        return this.name;
    }

    public long getTotalDeviceMemory() {
        return this.totalMem;
    }

    public long getFreeDeviceMemory() {
        return this.freeMem;
    }

    public int getMajorComputeVersion() {
        return this.majorComputeVersion;
    }

    public int getMinorComputeVersion() {
        return this.minorComputeVersion;
    }

    public String getComputeVersion() {
        return this.getMajorComputeVersion() + "." + this.getMinorComputeVersion();
    }

    public String toString() {
        return this.getDeviceName() + " (id=" + this.getDeviceId() + ", mem=" + this.getTotalDeviceMemory() / 0x100000L + "MB (" + this.getFreeDeviceMemory() / 0x100000L + "MB free), CUDA capability " + this.getComputeVersion() + ")";
    }

    @Override
    public int compareTo(CUDADevice dev) {
        return this.getDeviceId() - dev.getDeviceId();
    }
}

