/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.display;

import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.ModuleService;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PreprocessorPlugin.class, priority=10000.0)
public class ActiveDisplayPreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter(required=false)
    private DisplayService displayService;
    @Parameter(required=false)
    private ModuleService moduleService;

    @Override
    public void process(Module module) {
        if (this.displayService == null || this.moduleService == null) {
            return;
        }
        ModuleItem<Display> displayInput = this.moduleService.getSingleInput(module, Display.class);
        if (displayInput == null || !displayInput.isAutoFill()) {
            return;
        }
        Class<Display> displayType = displayInput.getType();
        Display activeDisplay = this.displayService.getActiveDisplay(displayType);
        if (activeDisplay == null) {
            return;
        }
        String name = displayInput.getName();
        module.setInput(name, activeDisplay);
        module.resolveInput(name);
    }
}

