/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import org.scijava.util.RealCoords;

public class RealRect {
    public double x;
    public double y;
    public double width;
    public double height;

    public RealRect() {
    }

    public RealRect(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean intersects(RealRect r) {
        double tw = this.width;
        double th = this.height;
        double rw = r.width;
        double rh = r.height;
        if (rw <= 0.0 || rh <= 0.0 || tw <= 0.0 || th <= 0.0) {
            return false;
        }
        double tx = this.x;
        double ty = this.y;
        double rx = r.x;
        double ry = r.y;
        boolean rtn = ((rw += rx) < rx || rw > tx) && ((rh += ry) < ry || rh > ty) && ((tw += tx) < tx || tw > rx) && ((th += ty) < ty || th > ry);
        return rtn;
    }

    public RealRect intersection(RealRect r) {
        double newX = Math.max(this.x, r.x);
        double newY = Math.max(this.y, r.y);
        double newW = Math.min(this.x + this.width, r.x + r.width) - this.x;
        double newH = Math.min(this.y + this.height, r.y + r.height) - this.y;
        if (newW < 0.0) {
            newW = 0.0;
        }
        if (newH < 0.0) {
            newH = 0.0;
        }
        return new RealRect(newX, newY, newW, newH);
    }

    public boolean contains(RealCoords coords) {
        return coords.x >= this.x && coords.x < this.x + this.width && coords.y >= this.y && coords.y < this.y + this.height;
    }

    public RealCoords getTopLeft() {
        return new RealCoords(this.x, this.y);
    }

    public RealCoords getBottomRight() {
        return new RealCoords(this.x + this.width, this.y + this.height);
    }

    public String toString() {
        return "x=" + this.x + ", y=" + this.y + ", w=" + this.width + ", h=" + this.height;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RealRect)) {
            return false;
        }
        RealRect rect = (RealRect)o;
        return this.x == rect.x && this.y == rect.y && this.width == rect.width && this.height == rect.height;
    }

    public int hashCode() {
        int b1 = this.lsb(this.x);
        int b2 = this.lsb(this.y);
        int b3 = this.lsb(this.width);
        int b4 = this.lsb(this.height);
        return b1 | b2 << 8 | b3 << 16 | b4 << 24;
    }

    private int lsb(double d) {
        return (int)Double.doubleToLongBits(d) & 0xFF;
    }
}

