/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks.convert;

import net.imglib2.algorithm.blocks.AbstractDimensionlessBlockProcessor;
import net.imglib2.algorithm.blocks.BlockProcessor;
import net.imglib2.algorithm.blocks.ClampType;
import net.imglib2.algorithm.blocks.convert.ConvertLoop;
import net.imglib2.algorithm.blocks.convert.ConvertLoops;
import net.imglib2.algorithm.blocks.util.UnaryOperatorType;
import net.imglib2.type.NativeType;

class ConvertBlockProcessor<I, O>
extends AbstractDimensionlessBlockProcessor<I, O> {
    private final ConvertLoop<I, O> loop;

    public <S extends NativeType<S>, T extends NativeType<T>> ConvertBlockProcessor(S sourceType, T targetType, ClampType clamp) {
        super(sourceType.getNativeTypeFactory().getPrimitiveType());
        this.loop = ConvertLoops.get(UnaryOperatorType.of(sourceType, targetType), clamp);
    }

    private ConvertBlockProcessor(ConvertBlockProcessor<I, O> convert) {
        super(convert);
        this.loop = convert.loop;
    }

    @Override
    public BlockProcessor<I, O> independentCopy() {
        return new ConvertBlockProcessor<I, O>(this);
    }

    @Override
    public void compute(I src, O dest) {
        this.loop.apply(src, dest, this.sourceLength());
    }
}

