/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.scijava.ui.behaviour.BehaviourMap;
import org.scijava.ui.behaviour.InputTriggerMap;

public final class TriggerBehaviourBindings {
    private final InputTriggerMap theInputTriggerMap = new InputTriggerMap();
    private final BehaviourMap theBehaviourMap = new BehaviourMap();
    private final List<Behaviours> behaviours = new ArrayList<Behaviours>();
    private final List<Triggers> triggers = new ArrayList<Triggers>();

    public void addBehaviourMap(String id, BehaviourMap behaviourMap) {
        TriggerBehaviourBindings.removeId(this.behaviours, id);
        if (behaviourMap != null) {
            this.behaviours.add(new Behaviours(id, behaviourMap));
        }
        this.updateTheBehaviourMap();
    }

    public void removeBehaviourMap(String id) {
        if (TriggerBehaviourBindings.removeId(this.behaviours, id)) {
            this.updateTheBehaviourMap();
        }
    }

    public void addInputTriggerMap(String id, InputTriggerMap inputTriggerMap, String ... idsToBlock) {
        this.addInputTriggerMap(id, inputTriggerMap, Arrays.asList(idsToBlock));
    }

    public void addInputTriggerMap(String id, InputTriggerMap inputTriggerMap, Collection<String> idsToBlock) {
        TriggerBehaviourBindings.removeId(this.triggers, id);
        if (inputTriggerMap != null) {
            this.triggers.add(new Triggers(id, inputTriggerMap, idsToBlock));
        }
        this.updateTheInputTriggerMap();
    }

    public void removeInputTriggerMap(String id) {
        if (TriggerBehaviourBindings.removeId(this.triggers, id)) {
            this.updateTheInputTriggerMap();
        }
    }

    public InputTriggerMap getConcatenatedInputTriggerMap() {
        return this.theInputTriggerMap;
    }

    public BehaviourMap getConcatenatedBehaviourMap() {
        return this.theBehaviourMap;
    }

    private static boolean removeId(List<? extends WithId> list, String id) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getId().equals(id)) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    private void updateTheBehaviourMap() {
        ListIterator<Behaviours> iter = this.behaviours.listIterator(this.behaviours.size());
        BehaviourMap root = this.theBehaviourMap;
        while (iter.hasPrevious()) {
            BehaviourMap map = iter.previous().getBehaviourMap();
            if (map == null) continue;
            map.setParent(null);
            root.setParent(map);
            root = map;
        }
        root.setParent(null);
    }

    private void updateTheInputTriggerMap() {
        ListIterator<Triggers> iter = this.triggers.listIterator(this.triggers.size());
        InputTriggerMap root = this.theInputTriggerMap;
        HashSet<String> blocked = new HashSet<String>();
        while (iter.hasPrevious()) {
            Triggers keys = iter.previous();
            if (blocked.contains(keys.getId())) continue;
            InputTriggerMap map = keys.getInputTriggerMap();
            if (map != null) {
                map.setParent(null);
                root.setParent(map);
                root = map;
            }
            blocked.addAll(keys.getKeysIdsToBlock());
            if (!blocked.contains("all")) continue;
            break;
        }
        root.setParent(null);
    }

    private static class Triggers
    implements WithId {
        private final String id;
        private final InputTriggerMap inputTriggerMap;
        private final HashSet<String> idsToBlock;

        public Triggers(String id, InputTriggerMap inputTriggerMap, Collection<String> idsToBlock) {
            this.id = id;
            this.inputTriggerMap = inputTriggerMap;
            this.idsToBlock = new HashSet<String>(idsToBlock);
        }

        @Override
        public String getId() {
            return this.id;
        }

        public InputTriggerMap getInputTriggerMap() {
            return this.inputTriggerMap;
        }

        public Set<String> getKeysIdsToBlock() {
            return this.idsToBlock;
        }
    }

    private static class Behaviours
    implements WithId {
        private final String id;
        private final BehaviourMap behaviourMap;

        public Behaviours(String id, BehaviourMap behaviourMap) {
            this.id = id;
            this.behaviourMap = behaviourMap;
        }

        @Override
        public String getId() {
            return this.id;
        }

        public BehaviourMap getBehaviourMap() {
            return this.behaviourMap;
        }
    }

    private static interface WithId {
        public String getId();
    }
}

