/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats.regression.leastSquares;

import java.util.Collection;
import java.util.Iterator;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import org.joml.Matrix4d;
import org.joml.Vector3d;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.random.Deterministic;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.LeastSquares.class)
public class Quadric
extends AbstractUnaryFunctionOp<Collection<Vector3d>, Matrix4d>
implements Ops.Stats.LeastSquares,
Contingent {
    public static final int MIN_DATA = 9;

    @Override
    public Matrix4d calculate(Collection<Vector3d> points) {
        double[] vector = Quadric.solveVector(points);
        return this.toQuadricMatrix(vector);
    }

    @Override
    public boolean conforms() {
        return ((Collection)this.in()).size() >= 9;
    }

    private static PrimitiveMatrix createDesignMatrix(Collection<Vector3d> points) {
        BasicMatrix.Builder builder = PrimitiveMatrix.FACTORY.getBuilder(points.size(), 9);
        Iterator<Vector3d> iterator = points.iterator();
        for (int i = 0; i < points.size(); ++i) {
            Vector3d p = iterator.next();
            builder.set((long)i, 0L, p.x * p.x);
            builder.set((long)i, 1L, p.y * p.y);
            builder.set((long)i, 2L, p.z * p.z);
            builder.set((long)i, 3L, 2.0 * p.x * p.y);
            builder.set((long)i, 4L, 2.0 * p.x * p.z);
            builder.set((long)i, 5L, 2.0 * p.y * p.z);
            builder.set((long)i, 6L, 2.0 * p.x);
            builder.set((long)i, 7L, 2.0 * p.y);
            builder.set((long)i, 8L, 2.0 * p.z);
        }
        return (PrimitiveMatrix)builder.build();
    }

    private static double[] solveVector(Collection<Vector3d> points) {
        int n = points.size();
        PrimitiveMatrix d = Quadric.createDesignMatrix(points);
        PrimitiveMatrix dT = (PrimitiveMatrix)d.transpose();
        PrimitiveMatrix dTDInv = (PrimitiveMatrix)((PrimitiveMatrix)dT.multiply((BasicMatrix)d)).invert();
        PrimitiveMatrix o = (PrimitiveMatrix)PrimitiveMatrix.FACTORY.makeFilled((long)n, 1L, (NullaryFunction)new Deterministic(1.0));
        PrimitiveMatrix dTO = (PrimitiveMatrix)dT.multiply((BasicMatrix)o);
        return ((PrimitiveMatrix)dTDInv.multiply((BasicMatrix)dTO)).toRawCopy1D();
    }

    private Matrix4d toQuadricMatrix(double[] solution) {
        double a = solution[0];
        double b = solution[1];
        double c = solution[2];
        double d = solution[3];
        double e = solution[4];
        double f = solution[5];
        double g = solution[6];
        double h = solution[7];
        double i = solution[8];
        return new Matrix4d(a, d, e, g, d, b, f, h, e, f, c, i, g, h, i, -1.0);
    }
}

