/*
 * Decompiled with CFR 0.152.
 */
package fiji.stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class Dynamic_Reslice
implements PlugIn,
MouseMotionListener,
WindowListener {
    private boolean rotate;
    private boolean flip;
    private double inputZSpacing = 1.0;
    private boolean rgb;
    private boolean notFloat;
    private final ImagePlus imp;
    private ImagePlus dest_imp;
    private Updater updater = new Updater();
    private int n;
    private double[] x;
    private double[] y;
    private int xbase;
    private int ybase;
    private double length;
    private double[] segmentLengths;
    private double[] dx;
    private double[] dy;
    private boolean hasStarted = false;

    public Dynamic_Reslice() {
        this.imp = WindowManager.getCurrentImage();
    }

    public Dynamic_Reslice(ImagePlus _imp) {
        this.imp = _imp;
        this.setup();
    }

    public void run(String arg) {
        int roiType;
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        int stackSize = this.imp.getStackSize();
        Roi roi = this.imp.getRoi();
        int n = roiType = roi != null ? roi.getType() : 0;
        if (stackSize < 2 && roi != null && roiType != 0) {
            IJ.error((String)"Dynamic Reslice...", (String)"Stack required");
            return;
        }
        if (roi == null || roiType != 5 && roiType != 6 && roiType != 7) {
            IJ.error((String)"Dynamic Reslice...", (String)"Line selection required");
            return;
        }
        this.setup();
        if (!this.showDialog()) {
            return;
        }
        this.start();
    }

    public void start() {
        if (this.hasStarted || this.imp.getRoi() == null) {
            return;
        }
        this.rgb = this.imp.getType() == 4;
        this.notFloat = !this.rgb && this.imp.getType() != 2;
        this.dest_imp = new ImagePlus("Dynamic Reslice of " + this.imp.getShortTitle(), this.getSlice(this.imp, this.imp.getRoi()));
        this.dealWithCalibration();
        ImageProcessor ip = this.imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        if (!this.rgb) {
            this.dest_imp.getProcessor().setMinAndMax(min, max);
        }
        this.dest_imp.show();
        this.imp.getCanvas().addMouseMotionListener((MouseMotionListener)this);
        this.imp.getWindow().addWindowListener((WindowListener)this);
        this.dest_imp.getWindow().addWindowListener((WindowListener)this);
        this.hasStarted = true;
    }

    public void shutdown() {
        this.updater.quit();
        this.updater = null;
        this.imp.getCanvas().removeMouseMotionListener((MouseMotionListener)this);
        this.imp.getWindow().removeWindowListener((WindowListener)this);
        this.dest_imp.getWindow().removeWindowListener((WindowListener)this);
        IJ.showStatus((String)"Dynamic Reslice shut down.");
    }

    public void update() {
        this.updater.doUpdate();
    }

    protected ImageProcessor getSlice(ImagePlus imp, Roi roi) {
        if (roi == null) {
            return null;
        }
        int roiType = roi.getType();
        ImageStack stack = imp.getStack();
        int stackSize = stack.getSize();
        ImageProcessor ip_out = null;
        boolean ortho = false;
        float[] line = null;
        double x1 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        if (roiType == 5) {
            Line lineRoi = (Line)roi;
            x1 = lineRoi.x1d;
            y1 = lineRoi.y1d;
            x2 = lineRoi.x2d;
            y2 = lineRoi.y2d;
            ortho = x1 == x2 || y1 == y2;
        }
        for (int i = 0; i < stackSize; ++i) {
            ImageProcessor ip = stack.getProcessor(this.flip ? stackSize - i : i + 1);
            line = roiType == 6 || roiType == 7 ? this.getIrregularProfile(ip, roi) : (ortho ? this.getOrthoLine(ip, (int)x1, (int)y1, (int)x2, (int)y2) : this.getLine(ip, x1, y1, x2, y2));
            if (this.rotate) {
                if (i == 0) {
                    ip_out = ip.createProcessor(stackSize, line.length);
                }
                this.putColumn(ip_out, i, 0, line, line.length);
                continue;
            }
            if (i == 0) {
                ip_out = ip.createProcessor(line.length, stackSize);
            }
            this.putRow(ip_out, 0, i, line, line.length);
        }
        Calibration cal = imp.getCalibration();
        double zSpacing = this.inputZSpacing / cal.pixelWidth;
        if (zSpacing != 1.0) {
            ip_out.setInterpolate(true);
            ip_out = this.rotate ? ip_out.resize((int)((double)stackSize * zSpacing), line.length) : ip_out.resize(line.length, (int)((double)stackSize * zSpacing));
        }
        return ip_out;
    }

    protected void reslice() {
        Roi roi = this.imp.getRoi();
        int roiType = roi != null ? roi.getType() : 0;
        Calibration origCal = this.imp.getCalibration();
        double zSpacing = this.inputZSpacing / this.imp.getCalibration().pixelWidth;
        ImageProcessor ip_out = this.getSlice(this.imp, roi);
        this.dest_imp.setProcessor(null, ip_out);
        this.dealWithCalibration();
    }

    protected void dealWithCalibration() {
        Roi roi = this.imp.getRoi();
        int roiType = roi != null ? roi.getType() : 0;
        Calibration origCal = this.imp.getCalibration();
        double zSpacing = this.inputZSpacing / this.imp.getCalibration().pixelWidth;
        boolean horizontal = false;
        boolean vertical = false;
        if (roi != null && roiType == 5) {
            Line l = (Line)roi;
            horizontal = l.y2 - l.y1 == 0;
            vertical = l.x2 - l.x1 == 0;
        }
        this.dest_imp.setCalibration(this.imp.getCalibration());
        Calibration cal = this.dest_imp.getCalibration();
        if (horizontal) {
            cal.pixelWidth = origCal.pixelWidth;
            cal.pixelHeight = origCal.pixelDepth / zSpacing;
        } else if (vertical) {
            cal.pixelWidth = origCal.pixelHeight;
            cal.pixelHeight = origCal.pixelDepth / zSpacing;
        } else if (origCal.pixelHeight == origCal.pixelWidth) {
            cal.pixelWidth = cal.pixelHeight = origCal.pixelDepth / zSpacing;
        } else {
            cal.pixelDepth = 1.0;
            cal.pixelHeight = 1.0;
            cal.pixelWidth = 1.0;
            cal.setUnit("pixel");
        }
        if (this.rotate) {
            double tmp = cal.pixelWidth;
            cal.pixelWidth = cal.pixelHeight;
            cal.pixelHeight = tmp;
        }
    }

    private float[] getIrregularProfile(ImageProcessor ip, Roi roi) {
        this.doIrregularSetup(roi);
        float[] values = new float[(int)this.length];
        double leftOver = 1.0;
        double distance = 0.0;
        for (int i = 0; i < this.n; ++i) {
            double len = this.segmentLengths[i];
            if (len == 0.0) continue;
            double xinc = this.dx[i] / len;
            double yinc = this.dy[i] / len;
            double start = 1.0 - leftOver;
            double rx = (double)this.xbase + this.x[i] + start * xinc;
            double ry = (double)this.ybase + this.y[i] + start * yinc;
            double len2 = len - start;
            int n2 = (int)len2;
            for (int j = 0; j <= n2; ++j) {
                int index = (int)distance + j;
                if (index < values.length) {
                    if (this.notFloat) {
                        values[index] = (float)ip.getInterpolatedPixel(rx, ry);
                    } else if (this.rgb) {
                        int rgbPixel = ((ColorProcessor)ip).getInterpolatedRGBPixel(rx, ry);
                        values[index] = Float.intBitsToFloat(rgbPixel & 0xFFFFFF);
                    } else {
                        values[index] = (float)ip.getInterpolatedValue(rx, ry);
                    }
                }
                rx += xinc;
                ry += yinc;
            }
            distance += len;
            leftOver = len2 - (double)n2;
        }
        return values;
    }

    private float[] getLine(ImageProcessor ip, double x1, double y1, double x2, double y2) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        int n = (int)Math.round(Math.sqrt(dx * dx + dy * dy));
        float[] data = new float[n];
        double xinc = dx / (double)n;
        double yinc = dy / (double)n;
        double rx = x1;
        double ry = y1;
        for (int i = 0; i < n; ++i) {
            if (this.notFloat) {
                data[i] = (float)ip.getInterpolatedPixel(rx, ry);
            } else if (this.rgb) {
                int rgbPixel = ((ColorProcessor)ip).getInterpolatedRGBPixel(rx, ry);
                data[i] = Float.intBitsToFloat(rgbPixel & 0xFFFFFF);
            } else {
                data[i] = (float)ip.getInterpolatedValue(rx, ry);
            }
            rx += xinc;
            ry += yinc;
        }
        return data;
    }

    private float[] getOrthoLine(ImageProcessor ip, int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        int n = Math.max(Math.abs(dx), Math.abs(dy));
        float[] data = new float[n];
        int xinc = dx / n;
        int yinc = dy / n;
        int rx = x1;
        int ry = y1;
        for (int i = 0; i < n; ++i) {
            if (this.notFloat) {
                data[i] = ip.getPixel(rx, ry);
            } else if (this.rgb) {
                int rgbPixel = ((ColorProcessor)ip).getPixel(rx, ry);
                data[i] = Float.intBitsToFloat(rgbPixel & 0xFFFFFF);
            } else {
                data[i] = ip.getPixelValue(rx, ry);
            }
            rx += xinc;
            ry += yinc;
        }
        return data;
    }

    private void doIrregularSetup(Roi roi) {
        int i;
        this.n = ((PolygonRoi)roi).getNCoordinates();
        int[] ix = ((PolygonRoi)roi).getXCoordinates();
        int[] iy = ((PolygonRoi)roi).getYCoordinates();
        this.x = new double[this.n];
        this.y = new double[this.n];
        for (i = 0; i < this.n; ++i) {
            this.x[i] = ix[i];
            this.y[i] = iy[i];
        }
        if (roi.getType() == 7) {
            for (i = 1; i < this.n - 1; ++i) {
                this.x[i] = (this.x[i - 1] + this.x[i] + this.x[i + 1]) / 3.0 + 0.5;
                this.y[i] = (this.y[i - 1] + this.y[i] + this.y[i + 1]) / 3.0 + 0.5;
            }
        }
        Rectangle r = roi.getBounds();
        this.xbase = r.x;
        this.ybase = r.y;
        this.length = 0.0;
        this.segmentLengths = new double[this.n];
        this.dx = new double[this.n];
        this.dy = new double[this.n];
        for (int i2 = 0; i2 < this.n - 1; ++i2) {
            double xdelta = this.x[i2 + 1] - this.x[i2];
            double ydelta = this.y[i2 + 1] - this.y[i2];
            double segmentLength = Math.sqrt(xdelta * xdelta + ydelta * ydelta);
            this.length += segmentLength;
            this.segmentLengths[i2] = segmentLength;
            this.dx[i2] = xdelta;
            this.dy[i2] = ydelta;
        }
    }

    private void putRow(ImageProcessor ip, int x, int y, float[] data, int length) {
        if (this.rgb) {
            for (int i = 0; i < length; ++i) {
                ip.putPixel(x++, y, Float.floatToIntBits(data[i]));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                ip.putPixelValue(x++, y, (double)data[i]);
            }
        }
    }

    private void putColumn(ImageProcessor ip, int x, int y, float[] data, int length) {
        if (this.rgb) {
            for (int i = 0; i < length; ++i) {
                ip.putPixel(x, y++, Float.floatToIntBits(data[i]));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                ip.putPixelValue(x, y++, (double)data[i]);
            }
        }
    }

    private boolean showDialog() {
        GenericDialog gd = new GenericDialog("Dynamic Reslice");
        gd.addCheckbox("Flip Vertically", this.flip);
        gd.addCheckbox("Rotate 90 Degrees", this.rotate);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.flip = gd.getNextBoolean();
        this.rotate = gd.getNextBoolean();
        return true;
    }

    private void setup() {
        Calibration cal = this.imp.getCalibration();
        if (cal.pixelDepth < 0.0) {
            cal.pixelDepth = -cal.pixelDepth;
        }
        if (cal.pixelWidth == 0.0) {
            cal.pixelWidth = 1.0;
        }
        this.inputZSpacing = cal.pixelDepth;
    }

    private void refresh() {
        if (this.imp.getRoi().getLength() < 2.0) {
            return;
        }
        if (!this.hasStarted) {
            this.start();
        }
        this.reslice();
    }

    public boolean getFlip() {
        return this.flip;
    }

    public void setFlip(boolean _flip) {
        if (this.hasStarted) {
            return;
        }
        this.flip = _flip;
    }

    public boolean getRotate() {
        return this.rotate;
    }

    public void setRotate(boolean _rotate) {
        if (this.hasStarted) {
            return;
        }
        this.rotate = _rotate;
    }

    public ImagePlus getImagePlus() {
        return this.dest_imp;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        e.consume();
        this.updater.doUpdate();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.shutdown();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    private class Updater
    extends Thread {
        long request;

        Updater() {
            super("Dynamic Reslice updater");
            this.request = 0L;
            this.setPriority(5);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doUpdate() {
            if (this.isInterrupted()) {
                return;
            }
            Updater updater = this;
            synchronized (updater) {
                ++this.request;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void quit() {
            this.interrupt();
            Updater updater = this;
            synchronized (updater) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    long r;
                    Updater updater = this;
                    synchronized (updater) {
                        r = this.request;
                    }
                    if (r > 0L) {
                        Dynamic_Reslice.this.refresh();
                    }
                    updater = this;
                    synchronized (updater) {
                        if (r == this.request) {
                            this.request = 0L;
                            this.wait();
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
        }
    }
}

