/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.FileInfo;
import ij.io.SaveDialog;
import ij.io.TiffEncoder;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Test_Save
implements PlugIn {
    ImagePlus imp;
    FileInfo fi;
    String name;
    String directory;
    String extraDescriptionEntries = "testentry1=dodo\ntestentry2=dudu\n";
    int[] extraMetaDataTypes = new int[]{0x4C5554, 0x4C5554};
    byte[][] extraMetaData = new byte[][]{new String("jajaja").getBytes(), new String("neinnein").getBytes()};

    public void run(String args) {
        String path;
        this.imp = WindowManager.getCurrentImage();
        this.fi = this.imp.getOriginalFileInfo();
        if (this.fi == null) {
            this.fi = this.imp.getFileInfo();
        }
        if ((path = this.getPath("TIFF", ".tif")) == null) {
            return;
        }
        Object info = this.imp.getProperty("Info");
        this.fi.info = info != null && info instanceof String ? (String)info : "empty info";
        this.fi.metaDataTypes = this.extraMetaDataTypes;
        this.fi.metaData = this.extraMetaData;
        if (this.imp.getStackSize() == 1) {
            this.saveAsTiff(path);
        } else {
            this.saveAsTiffStack(path);
        }
    }

    public boolean saveAsTiff(String path) {
        this.fi.nImages = 1;
        this.fi.description = this.getDescriptionString();
        try {
            TiffEncoder file = new TiffEncoder(this.fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    public boolean saveAsTiffStack(String path) {
        if (this.fi.nImages == 1) {
            IJ.error((String)"This is not a stack");
            return false;
        }
        if (this.fi.pixels == null && this.imp.getStack().isVirtual()) {
            IJ.error((String)"Save As Tiff", (String)"Virtual stacks not supported.");
            return false;
        }
        this.fi.description = this.getDescriptionString();
        this.fi.sliceLabels = this.imp.getStack().getSliceLabels();
        try {
            TiffEncoder file = new TiffEncoder(this.fi);
            DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
            file.write(out);
            out.close();
        }
        catch (IOException e) {
            this.showErrorMessage(e);
            return false;
        }
        return true;
    }

    void showErrorMessage(IOException e) {
        IJ.error((String)("An error occured writing the file.\n \n" + e));
    }

    String getDescriptionString() {
        boolean enhancedLut;
        int frames;
        int slices;
        int channels;
        StringBuffer sb = new StringBuffer(100);
        sb.append("ImageJ=1.51h\n");
        if (this.fi.nImages > 1) {
            sb.append("images=" + this.fi.nImages + "\n");
        }
        if ((channels = this.imp.getNChannels()) > 1) {
            sb.append("channels=" + channels + "\n");
        }
        if ((slices = this.imp.getNSlices()) > 1) {
            sb.append("slices=" + slices + "\n");
        }
        if ((frames = this.imp.getNFrames()) > 1) {
            sb.append("frames=" + frames + "\n");
        }
        if (this.fi.unit != null) {
            sb.append("unit=" + this.fi.unit + "\n");
        }
        if (this.fi.valueUnit != null) {
            sb.append("cf=" + this.fi.calibrationFunction + "\n");
            if (this.fi.coefficients != null) {
                for (int i = 0; i < this.fi.coefficients.length; ++i) {
                    sb.append("c" + i + "=" + this.fi.coefficients[i] + "\n");
                }
            }
            sb.append("vunit=" + this.fi.valueUnit + "\n");
            Calibration cal = this.imp.getCalibration();
            if (cal.zeroClip()) {
                sb.append("zeroclip=true\n");
            }
        }
        if (this.fi.nImages > 1) {
            if (this.fi.pixelDepth != 0.0 && this.fi.pixelDepth != 1.0) {
                sb.append("spacing=" + this.fi.pixelDepth + "\n");
            }
            if (this.fi.frameInterval != 0.0) {
                double fps = 1.0 / this.fi.frameInterval;
                if ((double)((int)fps) == fps) {
                    sb.append("fps=" + (int)fps + "\n");
                } else {
                    sb.append("fps=" + fps + "\n");
                }
            }
        }
        ImageProcessor ip = this.imp.getProcessor();
        double min = ip.getMin();
        double max = ip.getMax();
        int type = this.imp.getType();
        boolean bl = enhancedLut = !(type != 0 && type != 3 || min == 0.0 && max == 255.0);
        if (enhancedLut || type == 1 || type == 2) {
            sb.append("min=" + min + "\n");
            sb.append("max=" + max + "\n");
        }
        Calibration cal = this.imp.getCalibration();
        if (cal.xOrigin != 0.0) {
            sb.append("xorigin=" + cal.xOrigin + "\n");
        }
        if (cal.yOrigin != 0.0) {
            sb.append("yorigin=" + cal.yOrigin + "\n");
        }
        if (cal.zOrigin != 0.0) {
            sb.append("zorigin=" + cal.zOrigin + "\n");
        }
        if (cal.info != null && cal.info.length() <= 64 && cal.info.indexOf(61) == -1 && cal.info.indexOf(10) == -1) {
            sb.append("info=" + cal.info + "\n");
        }
        sb.append(this.extraDescriptionEntries);
        sb.append('\u0000');
        return new String(sb);
    }

    String getPath(String type, String extension) {
        this.name = this.imp.getTitle();
        SaveDialog sd = new SaveDialog("Save as " + type, this.name, extension);
        this.name = sd.getFileName();
        if (this.name == null) {
            return null;
        }
        this.directory = sd.getDirectory();
        this.imp.startTiming();
        String path = this.directory + this.name;
        return path;
    }
}

