/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.i5d.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import java.awt.Choice;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;
import java.awt.image.ColorModel;
import java.io.File;
import sc.fiji.i5d.I5DVirtualStack;
import sc.fiji.i5d.Image5D;
import sc.fiji.i5d.plugin.Hypervolume_Opener;
import sc.fiji.i5d.util.NumberedStringSorter;

public class Virtual_Image5D_Opener
implements PlugIn {
    private int n;
    private int start;
    private int increment;
    private String filter;
    private Calibration cal;
    private int first;
    private int middle;
    private int last;
    private int nFirst;
    private int nMiddle;
    private int nLast;
    private boolean assignColor;

    public void run(String arg) {
        I5DVirtualStack stack;
        String directory;
        block43: {
            OpenDialog od = new OpenDialog("Open Sequence of Images Stacks...", arg);
            directory = od.getDirectory();
            String name = od.getFileName();
            if (name == null) {
                return;
            }
            String[] list = new File(directory).list();
            if (list == null) {
                return;
            }
            NumberedStringSorter.sort(list);
            if (IJ.debugMode) {
                IJ.log((String)("Hypervolume_Opener: " + directory + " (" + list.length + " files)"));
            }
            int width = 0;
            int height = 0;
            stack = null;
            IJ.register(Hypervolume_Opener.class);
            try {
                ImagePlus imp = new Opener().openImage(directory, name);
                if (imp != null) {
                    width = imp.getWidth();
                    height = imp.getHeight();
                    this.cal = imp.getCalibration();
                } else {
                    for (int i = 0; i < list.length; ++i) {
                        if (list[i].endsWith(".txt") || (imp = new Opener().openImage(directory, list[i])) == null) continue;
                        width = imp.getWidth();
                        height = imp.getHeight();
                        this.cal = imp.getCalibration();
                        break;
                    }
                }
                if (imp != null && !this.showDialog(imp, list)) {
                    return;
                }
                if (width == 0) {
                    IJ.showMessage((String)"Import Sequence", (String)"This folder does not appear to contain any TIFF,\nJPEG, BMP, DICOM, GIF, FITS or PGM files.");
                    return;
                }
                if (this.n < 1) {
                    this.n = list.length;
                }
                if (this.start < 1 || this.start > list.length) {
                    this.start = 1;
                }
                if (this.start + this.n - 1 > list.length) {
                    this.n = list.length - this.start + 1;
                }
                int filteredImages = this.n;
                if (this.filter != null && (this.filter.equals("") || this.filter.equals("*"))) {
                    this.filter = null;
                }
                if (this.filter != null) {
                    filteredImages = 0;
                    for (int i = this.start - 1; i < list.length; ++i) {
                        if (list[i].indexOf(this.filter) < 0) continue;
                        ++filteredImages;
                    }
                    if (filteredImages == 0) {
                        IJ.error((String)("None of the " + this.n + " files contain\n the string '" + this.filter + "' in their name."));
                        return;
                    }
                }
                if (filteredImages < this.n) {
                    this.n = filteredImages;
                }
                int count = 0;
                int counter = 0;
                imp = null;
                for (int i = this.start - 1; i < list.length; ++i) {
                    if (list[i].endsWith(".txt") || this.filter != null && list[i].indexOf(this.filter) < 0 || counter++ % this.increment != 0) continue;
                    if (stack == null) {
                        imp = new Opener().openImage(directory, list[i]);
                    }
                    if (imp == null) continue;
                    if (stack == null) {
                        width = imp.getWidth();
                        height = imp.getHeight();
                        ColorModel cm = imp.getProcessor().getColorModel();
                        stack = new I5DVirtualStack(width, height, cm, directory);
                    }
                    count = stack.getSize() + 1;
                    IJ.showStatus((String)(count + "/" + this.n));
                    IJ.showProgress((double)((double)count / (double)this.n));
                    stack.addSlice(list[i]);
                    if (count < this.n) {
                        continue;
                    }
                    break;
                }
            }
            catch (OutOfMemoryError e) {
                IJ.outOfMemory((String)"Virtual_Image5D_Opener");
                if (stack == null) break block43;
                stack.trim();
            }
        }
        int stackSize = stack.getSize();
        this.last = 0;
        boolean[] thirdChoice = new boolean[]{true, true, true};
        thirdChoice[this.first] = false;
        thirdChoice[this.middle] = false;
        for (int j = 0; j < 3; ++j) {
            if (!thirdChoice[j]) continue;
            this.last = j;
            break;
        }
        double dLast = (double)stackSize / (double)this.nFirst / (double)this.nMiddle;
        this.nLast = (int)dLast;
        if ((double)this.nLast != dLast) {
            IJ.error((String)"channels*slices*frames!=stackSize");
            return;
        }
        int nChannels = 1;
        int nSlices = 1;
        int nFrames = 1;
        switch (this.first) {
            case 0: {
                nChannels = this.nFirst;
                break;
            }
            case 1: {
                nSlices = this.nFirst;
                break;
            }
            case 2: {
                nFrames = this.nFirst;
            }
        }
        switch (this.middle) {
            case 0: {
                nChannels = this.nMiddle;
                break;
            }
            case 1: {
                nSlices = this.nMiddle;
                break;
            }
            case 2: {
                nFrames = this.nMiddle;
            }
        }
        switch (this.last) {
            case 0: {
                nChannels = this.nLast;
                break;
            }
            case 1: {
                nSlices = this.nLast;
                break;
            }
            case 2: {
                nFrames = this.nLast;
            }
        }
        I5DVirtualStack newStack = new I5DVirtualStack(stack.getWidth(), stack.getHeight(), stack.getColorModel(), directory);
        int[] index = new int[3];
        index[2] = 0;
        while (index[2] < nFrames) {
            index[1] = 0;
            while (index[1] < nSlices) {
                index[0] = 0;
                while (index[0] < nChannels) {
                    int stackPosition = 1 + index[this.first] + index[this.middle] * this.nFirst + index[this.last] * this.nFirst * this.nMiddle;
                    newStack.addSlice(stack.getSliceLabel(stackPosition));
                    index[0] = index[0] + 1;
                }
                index[1] = index[1] + 1;
            }
            index[2] = index[2] + 1;
        }
        Image5D img5d = new Image5D("virtual", newStack, nChannels, nSlices, nFrames);
        img5d.setDefaultChannelNames();
        if (this.assignColor) {
            img5d.setDefaultColors();
        }
        img5d.setCurrentPosition(0, 0, 0, 0, 0);
        img5d.setCalibration(this.cal.copy());
        img5d.show();
        IJ.showProgress((double)1.0);
        System.gc();
    }

    boolean showDialog(ImagePlus imp, String[] list) {
        int fileCount = list.length;
        String name = imp.getTitle();
        if (name.length() > 4 && name.substring(name.length() - 4, name.length()).equalsIgnoreCase(".tif")) {
            name = name.substring(0, name.length() - 4);
        }
        for (int i = name.length() - 1; i > 1 && name.charAt(i) >= '0' && name.charAt(i) <= '9'; --i) {
            name = name.substring(0, i);
        }
        String[] dimensions = new String[]{"ch", "z", "t"};
        this.first = 1;
        this.middle = 0;
        this.last = 2;
        Vi5dOpenerDialog gd = new Vi5dOpenerDialog("Sequence Options", imp, list);
        gd.addNumericField("Number of Images: ", fileCount, 0);
        gd.addNumericField("Starting Image: ", 1.0, 0);
        gd.addNumericField("Increment: ", 1.0, 0);
        gd.addStringField("File Name Contains: ", name);
        gd.addMessage("10000 x 10000 x 1000 (100.3MB)");
        gd.addChoice("3rd dimension", dimensions, dimensions[this.first]);
        gd.addChoice("4th dimension", dimensions, dimensions[this.middle]);
        gd.addNumericField("3rd_dimension_size", 1.0, 0, 8, "");
        gd.addNumericField("4th_dimension_size", 1.0, 0, 8, "");
        gd.addCheckbox("Assign default color", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.n = (int)gd.getNextNumber();
        this.start = (int)gd.getNextNumber();
        this.increment = (int)gd.getNextNumber();
        if (this.increment < 1) {
            this.increment = 1;
        }
        this.filter = gd.getNextString();
        this.first = gd.getNextChoiceIndex();
        this.middle = gd.getNextChoiceIndex();
        this.nFirst = (int)gd.getNextNumber();
        this.nMiddle = (int)gd.getNextNumber();
        this.assignColor = gd.getNextBoolean();
        return true;
    }

    class Vi5dOpenerDialog
    extends GenericDialog {
        private static final long serialVersionUID = -2870244327145783251L;
        ImagePlus imp;
        int fileCount;
        boolean eightBits;
        String saveFilter;
        String[] list;
        Choice choice1;
        Choice choice2;
        int nChoices;

        public Vi5dOpenerDialog(String title, ImagePlus imp, String[] list) {
            super(title);
            this.saveFilter = "";
            this.imp = imp;
            this.list = list;
            this.fileCount = list.length;
        }

        protected void setup() {
            this.setStackInfo();
            this.choice1 = (Choice)this.choice.elementAt(0);
            this.choice2 = (Choice)this.choice.elementAt(1);
            this.nChoices = this.choice1.getItemCount();
        }

        public void itemStateChanged(ItemEvent e) {
            int index;
            this.setStackInfo();
            if (e.getItemSelectable().equals(this.choice1) && (index = this.choice1.getSelectedIndex()) == this.choice2.getSelectedIndex()) {
                this.choice2.select((index + 1) % this.nChoices);
            }
            if (e.getItemSelectable().equals(this.choice2) && (index = this.choice2.getSelectedIndex()) == this.choice1.getSelectedIndex()) {
                this.choice1.select((index + 1) % this.nChoices);
            }
        }

        public void textValueChanged(TextEvent e) {
            this.setStackInfo();
        }

        void setStackInfo() {
            int n2;
            TextField tf;
            String filter;
            int width = this.imp.getWidth();
            int height = this.imp.getHeight();
            int bytesPerPixel = 1;
            int n = this.getNumber(this.numberField.elementAt(0));
            int start = this.getNumber(this.numberField.elementAt(1));
            int inc = this.getNumber(this.numberField.elementAt(2));
            if (n < 1) {
                n = this.fileCount;
            }
            if (start < 1 || start > this.fileCount) {
                start = 1;
            }
            if (start + n - 1 > this.fileCount) {
                n = this.fileCount - start + 1;
            }
            if (inc < 1) {
                inc = 1;
            }
            if (!(filter = (tf = (TextField)this.stringField.elementAt(0)).getText()).equals("") && !filter.equals("*")) {
                n2 = n;
                n = 0;
                for (int i = start - 1; i < start - 1 + n2; ++i) {
                    if (this.list[i].indexOf(filter) < 0) continue;
                    ++n;
                }
                this.saveFilter = filter;
            }
            switch (this.imp.getType()) {
                case 1: {
                    bytesPerPixel = 2;
                    break;
                }
                case 2: 
                case 4: {
                    bytesPerPixel = 4;
                }
            }
            n2 = n / inc;
            if (n2 < 0) {
                n2 = 0;
            }
            double size = (double)(width * height * n2 * bytesPerPixel) / 1048576.0;
            ((Label)this.theLabel).setText(width + " x " + height + " x " + n2 + " (" + IJ.d2s((double)size, (int)1) + "MB)");
        }

        public int getNumber(Object field) {
            Double d;
            TextField tf = (TextField)field;
            String theText = tf.getText();
            try {
                d = new Double(theText);
            }
            catch (NumberFormatException e) {
                d = null;
            }
            if (d != null) {
                return (int)d.doubleValue();
            }
            return 0;
        }
    }
}

