/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.SuperEllipsoid;
import net.imglib2.roi.geom.real.WritableSphere;
import net.imglib2.roi.util.AbstractRealMaskPoint;
import net.imglib2.roi.util.RealLocalizableRealPositionable;

public abstract class AbstractWritableSphere
extends AbstractEuclideanSpace
implements WritableSphere {
    protected final double[] center;
    protected double radius;

    public AbstractWritableSphere(double[] center, double radius) {
        super(center.length);
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be positive and non-zero.");
        }
        this.center = (double[])center.clone();
        this.radius = radius;
    }

    public double realMin(int d) {
        return this.center[d] - this.radius;
    }

    public double realMax(int d) {
        return this.center[d] + this.radius;
    }

    @Override
    public double exponent() {
        return 2.0;
    }

    @Override
    public double semiAxisLength(int d) {
        return this.radius;
    }

    @Override
    public RealLocalizableRealPositionable center() {
        return new SphereCenter(this.center);
    }

    @Override
    public double radius() {
        return this.radius;
    }

    @Override
    public void setSemiAxisLength(int d, double length) {
        this.setRadius(length);
    }

    @Override
    public void setRadius(double radius) {
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be positive and non-zero.");
        }
        this.radius = radius;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SuperEllipsoid && SuperEllipsoid.equals(this, (SuperEllipsoid)obj);
    }

    public int hashCode() {
        return SuperEllipsoid.hashCode(this);
    }

    protected double distancePowered(RealLocalizable l) {
        assert (l.numDimensions() >= this.n) : "l must have no less than " + this.n + " dimensions";
        double distancePowered = 0.0;
        for (int d = 0; d < this.n; ++d) {
            distancePowered += (l.getDoublePosition(d) - this.center[d]) * (l.getDoublePosition(d) - this.center[d]);
        }
        return distancePowered;
    }

    private class SphereCenter
    extends AbstractRealMaskPoint {
        public SphereCenter(double[] pos) {
            super(pos);
        }

        @Override
        public void updateBounds() {
        }
    }
}

