/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.awt;

import java.awt.Graphics;
import java.awt.Label;
import org.scijava.Context;
import org.scijava.app.event.StatusEvent;
import org.scijava.event.EventHandler;
import org.scijava.plugin.Parameter;
import org.scijava.ui.StatusBar;
import org.scijava.ui.UIService;

public class AWTStatusBar
extends Label
implements StatusBar {
    @Parameter
    private UIService uiService;
    private int value;
    private int maximum;

    public AWTStatusBar(Context context) {
        context.inject((Object)this);
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int pix = this.maximum > 0 ? this.value * width / this.maximum : 0;
        g.setColor(this.getForeground());
        g.fillRect(0, 0, pix, height);
        g.setColor(this.getBackground());
        g.fillRect(pix, 0, width, height);
        super.paint(g);
    }

    public void setStatus(String message) {
        this.setText(message);
    }

    public void setProgress(int val, int max) {
        this.value = val;
        this.maximum = max;
        this.repaint();
    }

    @EventHandler
    protected void onEvent(StatusEvent event) {
        String message = this.uiService.getStatusMessage(event);
        int val = event.getProgressValue();
        int max = event.getProgressMaximum();
        this.setStatus(message);
        this.setProgress(val, max);
    }
}

