/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.parsington.eval;

import org.scijava.parsington.Operator;
import org.scijava.parsington.Operators;
import org.scijava.parsington.SyntaxTree;
import org.scijava.parsington.eval.StandardEvaluator;
import org.scijava.parsington.eval.TreeEvaluator;

public interface StandardTreeEvaluator
extends StandardEvaluator,
TreeEvaluator {
    @Override
    default public Object execute(Operator op, SyntaxTree tree) {
        if (op == Operators.LOGICAL_AND) {
            Object leftValue = this.value(this.evaluate(tree.child(0)));
            if (leftValue instanceof Boolean && !((Boolean)leftValue).booleanValue()) {
                return false;
            }
            Object rightValue = this.value(this.evaluate(tree.child(1)));
            return this.execute(op, leftValue, rightValue);
        }
        if (op == Operators.LOGICAL_OR) {
            Object leftValue = this.value(this.evaluate(tree.child(0)));
            if (leftValue instanceof Boolean && ((Boolean)leftValue).booleanValue()) {
                return true;
            }
            Object rightValue = this.value(this.evaluate(tree.child(1)));
            return this.execute(op, leftValue, rightValue);
        }
        if (op == Operators.QUESTION) {
            SyntaxTree conditional = tree.child(0);
            SyntaxTree consequent = tree.child(1);
            if (consequent.token() != Operators.COLON || consequent.count() != 2) {
                throw new IllegalArgumentException("Invalid ternary operator syntax");
            }
            Object conditionalValue = this.value(this.evaluate(conditional));
            if (!(conditionalValue instanceof Boolean)) {
                throw new IllegalArgumentException("Invalid ternary operator conditional expression");
            }
            return (Boolean)conditionalValue != false ? this.evaluate(consequent.child(0)) : this.evaluate(consequent.child(1));
        }
        Object[] args = new Object[tree.count()];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.evaluate(tree.child(i));
        }
        return this.execute(op, args);
    }
}

