/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.plugin.filter.GaussianBlur;
import ij.plugin.filter.PlugInFilter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Frame;

public class Helmholtz_Analysis
implements PlugInFilter {
    ImagePlus imp;
    boolean canceled = false;
    static int[] kernelX = new int[]{-1, 0, 1, -2, 0, 2, -1, 0, 1};
    static int[] kernelY = new int[]{1, 2, 1, 0, 0, 0, -1, -2, -1};
    static int[] kernelL = new int[]{0, 1, 0, 1, -4, 1, 0, 1, 0};
    static float[] average = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, 1.0f, 2.0f, 16.0f, 2.0f, 1.0f, 0.0f, 1.0f, 2.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    double lambdaMin;
    double lambdaMax;
    double preFilter;
    double trendFilter;
    double sigmaMinLambda;
    double sigmaMinPhi;
    int rAv;
    boolean showRawLambda;
    boolean showAvLambda;
    boolean showRawPhi;
    boolean showAvPhi;

    public int setup(String arg, ImagePlus imp) {
        if (IJ.versionLessThan((String)"1.17j")) {
            return 4096;
        }
        this.imp = imp;
        return 15;
    }

    public void run(ImageProcessor ip) {
        int numSlices = this.imp.getStackSize();
        ImageStack stack = this.imp.getStack();
        if (!this.getScale()) {
            return;
        }
        this.imp.unlock();
        ImageStack imsLambda = null;
        ImageStack imsPhi = null;
        ImageStack imsLambdaAv = null;
        ImageStack imsPhiAv = null;
        float[] weight = null;
        GaussianBlur gb = new GaussianBlur();
        for (int i = 0; i < numSlices; ++i) {
            IJ.showStatus((String)("Processing slice " + (i + 1) + "/" + numSlices));
            this.imp.setSlice(i + 1);
            IJ.run((String)"Duplicate...", (String)"title=tempMT");
            IJ.run((String)"32-bit");
            IJ.run((String)"Gaussian Blur...", (String)("radius=" + this.preFilter));
            IJ.run((String)"Bandpass Filter...", (String)("filter_large=" + this.lambdaMax + " filter_small=" + this.lambdaMin + " suppress=None tolerance=5 autoscale saturate"));
            ImagePlus impTemp = WindowManager.getCurrentImage();
            IJ.run((String)"Duplicate...", (String)"title=tempMT2");
            ImagePlus impTemp2 = WindowManager.getCurrentImage();
            IJ.run((String)"Gaussian Blur...", (String)("radius=" + this.trendFilter));
            IJ.run((String)"Image Calculator...", (String)"image1=tempMT operation=Subtract image2=tempMT2 create 32-bit");
            ImagePlus impFiltered = WindowManager.getCurrentImage();
            int w = impFiltered.getWidth();
            int h = impFiltered.getHeight();
            if (i == 0) {
                imsLambda = new ImageStack(w, h);
                imsPhi = new ImageStack(w, h);
                imsLambdaAv = new ImageStack(w, h);
                imsPhiAv = new ImageStack(w, h);
                weight = new float[w * h];
            }
            impTemp.hide();
            impTemp2.hide();
            ImageProcessor ipSlice = impFiltered.getProcessor();
            float[] gradX = (float[])ipSlice.getPixelsCopy();
            float[] gradY = (float[])ipSlice.getPixelsCopy();
            float[] laplace = (float[])ipSlice.getPixelsCopy();
            float[] data = (float[])ipSlice.getPixels();
            FloatProcessor ipGradX = new FloatProcessor(w, h);
            ipGradX.setPixels((Object)gradX);
            FloatProcessor ipGradY = new FloatProcessor(w, h);
            ipGradY.setPixels((Object)gradY);
            FloatProcessor ipLaplace = new FloatProcessor(w, h);
            ipLaplace.setPixels((Object)laplace);
            ipGradX.convolve3x3(kernelX);
            ipGradY.convolve3x3(kernelY);
            ipLaplace.convolve3x3(kernelL);
            FloatProcessor ipLambda = new FloatProcessor(w, h);
            FloatProcessor ipPhi = new FloatProcessor(w, h);
            float[] lambda = (float[])ipLambda.getPixels();
            float[] phi = (float[])ipPhi.getPixels();
            FloatProcessor ipLambdaAv = new FloatProcessor(w, h);
            FloatProcessor ipPhiAv = new FloatProcessor(w, h);
            float[] lambdaAv = (float[])ipLambdaAv.getPixels();
            float[] phiAv = (float[])ipPhiAv.getPixels();
            double k2 = 0.0;
            double k = 0.0;
            double k2Max = Math.PI * 2 / this.lambdaMin;
            k2Max *= k2Max;
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    int index = x + w * y;
                    double d = data[index];
                    k2 = d == 0.0 ? 0.0 : (double)laplace[index] / d;
                    if (k2 >= 0.0) {
                        lambda[index] = Float.NaN;
                        phi[index] = Float.NaN;
                        weight[index] = 0.0f;
                        continue;
                    }
                    k = Math.sqrt(-k2);
                    double wavelength = (float)(Math.PI * 2 / k);
                    if (wavelength >= this.lambdaMin && wavelength <= this.lambdaMax) {
                        lambda[index] = (float)wavelength;
                        double gx = gradX[index];
                        double gy = gradY[index];
                        double phiRad = Math.atan2(gx, gy);
                        if (phiRad < 0.0) {
                            phiRad += Math.PI;
                        }
                        phi[index] = (float)(180.0 * phiRad / Math.PI);
                        weight[index] = (float)Math.sqrt(gx * gx + gy * gy);
                        continue;
                    }
                    lambda[index] = Float.NaN;
                    phi[index] = Float.NaN;
                    weight[index] = 0.0f;
                }
            }
            impFiltered.hide();
            ipLambda.setMinAndMax(this.lambdaMin, this.lambdaMax);
            ipPhi.setMinAndMax(0.0, 180.0);
            if (this.showRawLambda) {
                imsLambda.addSlice("Lambda", (ImageProcessor)ipLambda);
            }
            if (this.showRawPhi) {
                imsPhi.addSlice("Phi", (ImageProcessor)ipPhi);
            }
            if (this.showAvLambda) {
                this.average(w, h, this.rAv, this.sigmaMinLambda, lambda, lambdaAv);
                ipLambdaAv.setMinAndMax(this.lambdaMin, this.lambdaMax);
                imsLambdaAv.addSlice("LambdaAv", (ImageProcessor)ipLambdaAv);
            }
            if (!this.showAvPhi) continue;
            this.average(w, h, this.rAv, this.sigmaMinPhi, phi, weight, phiAv);
            ipPhiAv.setMinAndMax(0.0, 180.0);
            imsPhiAv.addSlice("PhiAv", (ImageProcessor)ipPhiAv);
        }
        IJ.showStatus((String)"Done");
        if (this.showRawLambda) {
            ImagePlus impLambda = new ImagePlus("Lambda", imsLambda);
            impLambda.show();
            IJ.run((String)"Fire");
        }
        if (this.showRawPhi) {
            ImagePlus impPhi = new ImagePlus("Phi", imsPhi);
            impPhi.show();
            IJ.run((String)"Fire");
        }
        if (this.showAvLambda) {
            ImagePlus impLambdaAv = new ImagePlus("Lambda_Av", imsLambdaAv);
            impLambdaAv.show();
            IJ.run((String)"Fire");
        }
        if (this.showAvPhi) {
            ImagePlus impPhiAv = new ImagePlus("Phi_Av", imsPhiAv);
            impPhiAv.show();
            IJ.run((String)"Fire");
        }
    }

    void average(int w, int h, int rAv, double sigmaMin, float[] data, float[] av) {
        double varMin = sigmaMin * sigmaMin;
        int wMask = 2 * rAv + 1;
        boolean[] mask = new boolean[wMask * wMask];
        int indMask = 0;
        for (int jm = -rAv; jm <= rAv; ++jm) {
            for (int im = -rAv; im <= rAv; ++im) {
                mask[indMask++] = Math.sqrt(im * im + jm * jm) <= (double)rAv;
            }
        }
        for (int jCent = 0; jCent < h; ++jCent) {
            IJ.showProgress((double)((float)jCent / (float)h));
            for (int iCent = 0; iCent < w; ++iCent) {
                double var;
                int ind;
                int nROI = 0;
                int nValid = 0;
                double sum = 0.0;
                double sumSq = 0.0;
                indMask = 0;
                for (int jm = -rAv; jm <= rAv; ++jm) {
                    for (int im = -rAv; im <= rAv; ++im) {
                        if (!mask[indMask++]) continue;
                        int j = jCent + jm;
                        int i = iCent + im;
                        if (j < 0 || j >= h || i < 0 || i >= w) continue;
                        ind = i + j * w;
                        ++nROI;
                        float d = data[ind];
                        if (d != d) continue;
                        ++nValid;
                        sum += (double)d;
                        sumSq += (double)(d * d);
                    }
                }
                ind = iCent + jCent * w;
                av[ind] = Float.NaN;
                if (nValid < 2 * nROI / 3 || !((var = (sumSq /= (double)nValid) - (sum /= (double)nValid) * sum) <= varMin)) continue;
                av[ind] = (float)sum;
            }
        }
        IJ.showProgress((double)1.0);
    }

    void average(int w, int h, int rAv, double sigmaMin, float[] data, float[] weight, float[] av) {
        double varMin = sigmaMin * sigmaMin;
        int nMax = 2 * (rAv + 1) * 2 * (rAv + 1);
        float[] x = new float[nMax];
        float[] wt = new float[nMax];
        int wMask = 2 * rAv + 1;
        boolean[] mask = new boolean[wMask * wMask];
        int indMask = 0;
        for (int jm = -rAv; jm <= rAv; ++jm) {
            for (int im = -rAv; im <= rAv; ++im) {
                mask[indMask++] = Math.sqrt(im * im + jm * jm) <= (double)rAv;
            }
        }
        for (int jCent = 0; jCent < h; ++jCent) {
            IJ.showProgress((double)((float)jCent / (float)h));
            for (int iCent = 0; iCent < w; ++iCent) {
                int is;
                int ind;
                int nROI = 0;
                int nValid = 0;
                indMask = 0;
                for (int jm = -rAv; jm <= rAv; ++jm) {
                    for (int im = -rAv; im <= rAv; ++im) {
                        if (!mask[indMask++]) continue;
                        int j = jCent + jm;
                        int i = iCent + im;
                        if (j < 0 || j >= h || i < 0 || i >= w) continue;
                        ind = i + j * w;
                        ++nROI;
                        float d = data[ind];
                        if (d != d || !(weight[ind] > 0.0f)) continue;
                        x[nValid] = d;
                        wt[nValid++] = weight[ind];
                    }
                }
                ind = iCent + jCent * w;
                av[ind] = Float.NaN;
                if (nValid < 2 * nROI / 3) continue;
                double sum = 0.0;
                double wSum = 0.0;
                for (is = 0; is < nValid; ++is) {
                    sum += (double)(wt[is] * x[is]);
                    wSum += (double)wt[is];
                }
                double mu = sum / wSum;
                double sumSq = 0.0;
                for (is = 0; is < nValid; ++is) {
                    sumSq += (double)wt[is] * ((double)x[is] - mu) * ((double)x[is] - mu);
                }
                double var = sumSq / wSum;
                if (!(var <= varMin)) continue;
                av[ind] = (float)mu;
            }
        }
        IJ.showProgress((double)1.0);
    }

    boolean getScale() {
        this.lambdaMin = Prefs.get((String)"helmholtzanalysis.lambdamin", (double)2.0);
        this.lambdaMax = Prefs.get((String)"helmholtzanalysis.lambdamax", (double)12.0);
        this.rAv = (int)Prefs.get((String)"helmholtzanalysis.rav", (double)10.0);
        this.showRawLambda = Prefs.get((String)"helmholtzanalysis.showRawLambda", (boolean)true);
        this.showAvLambda = Prefs.get((String)"helmholtzanalysis.showAvLambda", (boolean)true);
        this.showRawPhi = Prefs.get((String)"helmholtzanalysis.showRawPhi", (boolean)true);
        this.showAvPhi = Prefs.get((String)"helmholtzanalysis.showAvPhi", (boolean)true);
        String[] cbls = new String[]{"Raw lambda", "Averaged lambda", "Raw phi", "Averaged phi"};
        boolean[] cbdef = new boolean[]{this.showRawLambda, this.showAvLambda, this.showRawPhi, this.showAvPhi};
        GenericDialog gd = new GenericDialog("Helmholtz Analysis...", (Frame)IJ.getInstance());
        gd.addNumericField("minimum_lambda, pixels", this.lambdaMin, 1);
        gd.addNumericField("maximum_lambda, pixels", this.lambdaMax, 1);
        gd.addNumericField("rAv, pixels: radius of postprocessing averaging circle (perhaps maximum lambda)", (double)this.rAv, 0);
        gd.addMessage("Show:");
        gd.addCheckboxGroup(1, 4, cbls, cbdef);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        this.lambdaMin = gd.getNextNumber();
        this.trendFilter = this.lambdaMax = gd.getNextNumber();
        this.preFilter = this.lambdaMin / 2.0;
        this.rAv = (int)gd.getNextNumber();
        this.sigmaMinLambda = this.lambdaMin;
        this.sigmaMinPhi = 15.0;
        this.showRawLambda = gd.getNextBoolean();
        this.showAvLambda = gd.getNextBoolean();
        this.showRawPhi = gd.getNextBoolean();
        this.showAvPhi = gd.getNextBoolean();
        Prefs.set((String)"helmholtzanalysis.lambdamin", (double)this.lambdaMin);
        Prefs.set((String)"helmholtzanalysis.lambdamax", (double)this.lambdaMax);
        Prefs.set((String)"helmholtzanalysis.rav", (int)this.rAv);
        Prefs.set((String)"helmholtzanalysis.showRawLambda", (boolean)this.showRawLambda);
        Prefs.set((String)"helmholtzanalysis.showAvLambda", (boolean)this.showAvLambda);
        Prefs.set((String)"helmholtzanalysis.showRawPhi", (boolean)this.showRawPhi);
        Prefs.set((String)"helmholtzanalysis.showAvPhi", (boolean)this.showAvPhi);
        return true;
    }
}

