/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.plugin.PlugIn;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import org.scijava.Context;
import org.scijava.io.IOService;
import org.scijava.ui.UIService;

public class HandleExtraFileTypes
extends ImagePlus
implements PlugIn {
    static final int IMAGE_OPENED = -1;
    static final int PLUGIN_NOT_FOUND = -2;
    static final boolean LOCI_PRESENT = HandleExtraFileTypes.checkForLoci();

    private static boolean checkForLoci() {
        boolean lociPresent = true;
        try {
            lociPresent = IJ.getClassLoader().loadClass("loci.plugins.LociImporter") != null;
        }
        catch (ClassNotFoundException e) {
            lociPresent = false;
        }
        if (IJ.debugMode) {
            IJ.log((String)("HEFT: loci is" + (lociPresent ? " " : " not ") + "present"));
        }
        return lociPresent;
    }

    public void run(String path) {
        if (path.equals("")) {
            return;
        }
        File theFile = new File(path);
        String fileName = theFile.getName();
        String directory = theFile.getParent();
        if (directory == null) {
            directory = "";
        } else if (!(directory = directory.replace('\\', '/')).endsWith("/")) {
            directory = directory + "/";
        }
        ImagePlus imp = this.openImage(directory, fileName, path);
        if (imp == null) {
            IJ.showStatus((String)"");
            return;
        }
        ImageStack stack = imp.getStack();
        String title = imp.getTitle().equals("") ? fileName : imp.getTitle();
        this.setStack(title, stack);
        this.setCalibration(imp.getCalibration());
        if (imp.getProperty("Info") != null) {
            this.setProperty("Info", imp.getProperty("Info"));
        }
        if (imp.getProperty("Label") != null) {
            this.setProperty("Label", imp.getProperty("Label"));
        }
        this.setFileInfo(imp.getOriginalFileInfo());
        if (IJ.getVersion().compareTo("1.38s") >= 0) {
            this.setDimensions(imp.getNChannels(), imp.getNSlices(), imp.getNFrames());
        }
        if (IJ.getVersion().compareTo("1.41o") >= 0) {
            this.setOpenAsHyperStack(imp.getOpenAsHyperStack());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object tryOpen(String directory, String name, String path) {
        byte[] buf = new byte[132];
        try {
            InputStream is = 0 == path.indexOf("http://") ? new URL(path).openStream() : new FileInputStream(path);
            is.read(buf, 0, 132);
            is.close();
        }
        catch (IOException e) {
            return null;
        }
        name = name.toLowerCase();
        this.width = -2;
        if (IJ.getVersion().compareTo("1.37u") >= 0 && LOCI_PRESENT) {
            IJ.suppressPluginNotFoundError();
        }
        if (name.endsWith(".pic.gz") || buf[54] == 57 && buf[55] == 48) {
            return this.tryPlugIn("Biorad_Reader", path);
        }
        if (name.endsWith(".dm3") && buf[0] == 0 && buf[1] == 0 && buf[2] == 0 && buf[3] == 3) {
            return this.tryPlugIn("sc.fiji.io.DM3_Reader", path);
        }
        if (name.endsWith(".ipl") || buf[0] == 105 && buf[1] == 105 && buf[2] == 105 && buf[3] == 105 || buf[0] == 109 && buf[1] == 109 && buf[2] == 109 && buf[3] == 109) {
            return this.tryPlugIn("sc.fiji.io.IPLab_Reader", path);
        }
        if (name.endsWith(".img") && buf[0] == 75 && buf[1] == 65 && buf[2] == 74 && buf[3] == 0) {
            return this.tryPlugIn("InstantImager_Reader", path);
        }
        if (name.endsWith(".img") || name.endsWith(".hdr")) {
            if (Menus.getCommands().get("NIfTI-Analyze") != null) {
                return this.tryPlugIn("Nifti_Reader", path);
            }
            return this.tryPlugIn("Analyze_Reader", path);
        }
        if (name.endsWith(".nii") || name.endsWith(".nii.gz") || name.endsWith(".nii.z")) {
            return this.tryPlugIn("Nifti_Reader", path);
        }
        if (name.endsWith(".ics")) {
            return this.tryPlugIn("Ics_Opener", path);
        }
        if (name.endsWith(".spe")) {
            return this.tryPlugIn("OpenSPE_", path);
        }
        if (name.endsWith(".lsm")) {
            Object obj = this.tryPlugIn("LSM_Reader", path);
            if (obj == null && Menus.getCommands().get("Show LSMToolbox") != null) {
                obj = this.tryPlugIn("LSM_Toolbox", "file=" + path);
            }
            return obj;
        }
        if (name.equals("ser") || name.equals("fid") || name.equals("2rr") || name.equals("2ii") || name.equals("3rrr") || name.equals("3iii") || name.equals("2dseq")) {
            IJ.showStatus((String)("Opening Bruker " + name + " File"));
            return this.tryPlugIn("BrukerOpener", name + "|" + path);
        }
        if (name.endsWith(".avi")) {
            return this.tryPlugIn("AVI_Reader", path);
        }
        if (name.endsWith(".mov") || name.endsWith(".pict")) {
            return this.tryPlugIn("QT_Movie_Opener", path);
        }
        if (name.endsWith(".zvi")) {
            return this.tryPlugIn("ZVI_Reader", path);
        }
        if (name.endsWith(".unc") || buf[3] == 117 && buf[7] == -127 && buf[11] == 36 && buf[14] == 32 && buf[15] == -127) {
            return this.tryPlugIn("UNC_Reader", path);
        }
        if (name.endsWith(".mrc") || name.endsWith(".rec") || name.endsWith(".st") || name.endsWith(".tmg")) {
            return this.tryPlugIn("sc.fiji.io.Open_MRC_Leginon", path);
        }
        if (name.endsWith(".dv") || name.endsWith(".r3d")) {
            return this.tryPlugIn("Deltavision_Opener", path);
        }
        if (name.endsWith(".dat") && 1 == buf[1] && 0 == buf[2]) {
            return this.tryPlugIn("sc.fiji.io.Open_DAT_EMMENU", path);
        }
        if (name.endsWith(".xml") || name.endsWith(".xml.gz")) {
            byte[] b = buf;
            if (name.endsWith("z")) {
                GZIPInputStream gz = null;
                b = new byte[132];
                try {
                    gz = new GZIPInputStream(new BufferedInputStream(new FileInputStream(path)));
                    gz.read(b, 0, 132);
                }
                catch (Exception gze) {
                    gze.printStackTrace();
                    Object var9_17 = null;
                    return var9_17;
                }
                finally {
                    try {
                        gz.close();
                    }
                    catch (IOException gzioe) {
                        gzioe.printStackTrace();
                        return null;
                    }
                }
            }
            if (-1 != new String(b).toLowerCase().indexOf("trakem2")) {
                try {
                    Class<?> cla = Class.forName("ini.trakem2.Project");
                    if (null != cla) {
                        Method method = cla.getMethod("openFSProject", String.class);
                        method.invoke(null, path);
                    }
                    this.width = -1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
        }
        if (name.endsWith(".df3")) {
            return this.tryPlugIn("sc.fiji.io.Open_DF3", path);
        }
        if (name.endsWith(".dat") && buf[0] == -45 && buf[1] == -19 && buf[2] == -11 && buf[3] == -14) {
            return this.tryPlugIn("sc.fiji.io.FIBSEM_Reader", path);
        }
        if (name.endsWith(".pdf")) {
            return this.tryPlugIn("sc.fiji.io.PDF_Viewer", path);
        }
        try {
            String nrrdMagic = new String(buf, 0, 7, "US-ASCII");
            if (nrrdMagic.equals("NRRD000")) {
                return this.tryPlugIn("sc.fiji.io.Nrrd_Reader", path);
            }
        }
        catch (Exception nrrdMagic) {
            // empty catch block
        }
        if (name.toLowerCase().endsWith(".bin") || name.toLowerCase().endsWith(".bin.gz")) {
            File studyDir;
            String dirWithoutSeparator = directory;
            if (directory.endsWith(File.separator)) {
                dirWithoutSeparator = directory.substring(0, directory.length() - 1);
            }
            if ((studyDir = new File(dirWithoutSeparator + ".study")).isDirectory()) {
                return this.tryPlugIn("sc.fiji.io.TorstenRaw_GZ_Reader", path);
            }
        }
        if (name.endsWith(".ico")) {
            return this.tryPlugIn("sc.fiji.io.ICO_Reader", path);
        }
        if (name.endsWith(".icns")) {
            return this.tryPlugIn("sc.fiji.io.Icns_Reader", path);
        }
        if (name.endsWith(".svg")) {
            return this.tryPlugIn("sc.fiji.io.SVG_Reader", path);
        }
        if (name.endsWith(".lss")) {
            return this.tryPlugIn("sc.fiji.io.LSS16_Reader", path);
        }
        if (name.endsWith(".py")) {
            return this.tryPlugIn("Jython.Refresh_Jython_Scripts", path);
        }
        if (name.endsWith(".rb")) {
            return this.tryPlugIn("JRuby.Refresh_JRuby_Scripts", path);
        }
        if (name.endsWith(".js")) {
            return this.tryPlugIn("Javascript.Refresh_Javascript_Scripts", path);
        }
        if (name.endsWith(".clj")) {
            return this.tryPlugIn("Clojure.Refresh_Clojure_Scripts", path);
        }
        if (name.endsWith(".bs") || name.endsWith(".bsh")) {
            return this.tryPlugIn("BSH.Refresh_BSH_Scripts", path);
        }
        if (name.endsWith(".ser")) {
            return this.tryPlugIn("edu.utexas.clm.reconstructreader.reconstruct.Reconstruct_Reader", path);
        }
        if (name.matches("[iI]\\d{7}\\.[mM]\\p{XDigit}{2}")) {
            return this.tryPlugIn("org.doube.bonej.pqct.Read_Stratec_File", path);
        }
        if (name.endsWith(".obj") || name.endsWith(".dxf") || name.endsWith(".stl")) {
            return this.tryPlugIn("ImageJ_3D_Viewer", path);
        }
        try {
            String vaa3dCookie = new String(buf, 0, 24);
            if (vaa3dCookie.equals("raw_image_stack_by_hpeng") || vaa3dCookie.equals("v3d_volume_pkbitdf_encod")) {
                return this.tryPlugIn("org.janelia.vaa3d.reader.Vaa3d_Reader", path);
            }
        }
        catch (Exception vaa3dCookie) {
            // empty catch block
        }
        try {
            String isqMagic = new String(buf, 0, 16, "UTF-8");
            if (name.matches("[a-z]\\d{7}.isq;\\d+") || isqMagic.equals("CTDATA-HEADER_V1")) {
                return this.tryPlugIn("org.bonej.io.ISQReader", path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name.endsWith(".arc")) {
            return this.tryPlugIn("edu.utexas.clm.archipelago.Fiji_Archipelago", path);
        }
        if (name.endsWith(".mhd")) {
            return this.tryPlugIn("sc.fiji.io.MetaImage_Reader", path);
        }
        if (name.endsWith(".mha")) {
            return this.tryPlugIn("sc.fiji.io.MetaImage_Reader", path);
        }
        if (name.endsWith(".bin")) {
            return this.tryPlugIn("sc.fiji.io.Koala_Bin_Reader", path);
        }
        if (name.endsWith(".raw")) {
            return this.tryPlugIn("ij.plugin.Raw", path);
        }
        if (name.endsWith(".h5j")) {
            return this.tryPlugIn("org.janelia.it.fiji.plugins.h5j.H5j_Reader", path);
        }
        return null;
    }

    private ImagePlus openImage(String directory, String name, String path) {
        Object loci;
        Object o = this.tryOpen(directory, name, path);
        if (o instanceof ImagePlus) {
            return (ImagePlus)o;
        }
        if (this.width == -1) {
            return null;
        }
        if (o == null && (IJ.getVersion().compareTo("1.38j") < 0 || !IJ.redirectingErrorMessages()) && new File(path).exists() && (loci = IJ.runPlugIn((String)"loci.plugins.LociImporter", (String)path)) != null) {
            try {
                Class<?> c = loci.getClass();
                boolean success = c.getField("success").getBoolean(loci);
                boolean canceled = c.getField("canceled").getBoolean(loci);
                if (success || canceled) {
                    this.width = -1;
                    return null;
                }
            }
            catch (Exception c) {
                // empty catch block
            }
        }
        try {
            Object ctx = IJ.runPlugIn((String)"org.scijava.Context", (String)"");
            if (ctx instanceof Context) {
                Object data;
                Context context = (Context)ctx;
                IOService ioService = (IOService)context.getService(IOService.class);
                UIService uiService = (UIService)context.getService(UIService.class);
                if (ioService != null && uiService != null && (data = ioService.open(path)) != null) {
                    this.width = -1;
                    uiService.show(data);
                    return null;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private Object tryPlugIn(String className, String path) {
        Object o = IJ.runPlugIn((String)className, (String)path);
        if (o instanceof ImagePlus) {
            ImagePlus imp = (ImagePlus)o;
            if (imp.getWidth() == 0) {
                o = null;
            } else {
                this.width = -1;
            }
        } else if (o != null) {
            this.width = -1;
        }
        return o;
    }
}

