/*
 * Decompiled with CFR 0.152.
 */
package ij3d;

import ij.IJ;
import ij.gui.GenericDialog;
import ij3d.Content;
import ij3d.Image3DUniverse;
import ij3d.UniverseListener;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import math3d.Point3d;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import vib.BenesNamedPoint;
import vib.FastMatrix;
import vib.PointList;

public class RegistrationMenubar
extends JMenuBar
implements ActionListener,
UniverseListener {
    private final Image3DUniverse univ;
    private final JMenu register;
    private final JMenuItem exit;
    private final JMenuItem adjustSlices;
    private final List openDialogs = new ArrayList();
    private Content templ;
    private Content model;

    public RegistrationMenubar(Image3DUniverse univ) {
        this.univ = univ;
        univ.addUniverseListener(this);
        this.register = new JMenu("Register");
        this.exit = new JMenuItem("Exit registration");
        this.exit.addActionListener(this);
        this.register.add(this.exit);
        this.adjustSlices = new JMenuItem("Adjust slices");
        this.adjustSlices.addActionListener(this);
        this.register.add(this.adjustSlices);
        this.add(this.register);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exit) {
            this.exitRegistration();
        } else if (e.getSource() == this.adjustSlices) {
            Content c = this.univ.getSelected();
            if (c != null) {
                this.univ.getExecuter().changeSlices(c);
            }
        } else if (e.getActionCommand().equals("LS_TEMPLATE")) {
            this.selectLandmarkSet(this.templ, "LS_MODEL");
        } else if (e.getActionCommand().equals("LS_MODEL")) {
            this.selectLandmarkSet(this.model, "REGISTER");
        } else if (e.getActionCommand().equals("REGISTER")) {
            this.doRegistration(this.templ, this.model);
        }
    }

    public void register() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                RegistrationMenubar.this.initRegistration();
            }
        }).start();
    }

    public void exitRegistration() {
        this.templ.showPointList(false);
        this.model.showPointList(false);
        JMenuBar mb = this.univ.getMenuBar();
        this.univ.setMenubar(mb);
        this.univ.clearSelection();
        this.univ.setStatus("");
        this.univ.getPointListDialog().removeExtraPanel();
        this.univ.ui.setHandTool();
    }

    private void hideAll() {
        Iterator it = this.univ.contents();
        while (it.hasNext()) {
            ((Content)it.next()).setVisible(false);
        }
    }

    private void selectLandmarkSet(Content content, String actionCommand) {
        this.hideAll();
        content.setVisible(true);
        content.displayAs(1);
        content.showPointList(true);
        this.univ.ui.setPointTool();
        this.univ.select(content);
        this.univ.setStatus("Select landmarks in " + content.getName() + " and click OK");
        Panel p = new Panel(new FlowLayout());
        Button b = new Button("OK");
        b.setActionCommand(actionCommand);
        b.addActionListener(this);
        p.add(b);
        if (actionCommand.equals("REGISTER")) {
            b = new Button("Back to template");
            b.setActionCommand("LS_TEMPLATE");
            b.addActionListener(this);
            p.add(b);
        }
        this.univ.getPointListDialog().addPanel(p);
    }

    public void initRegistration() {
        Collection contents = this.univ.getContents();
        if (contents.size() < 2) {
            IJ.error((String)"At least two bodies are required for  registration");
            return;
        }
        String[] conts = new String[contents.size()];
        int i = 0;
        Iterator it = contents.iterator();
        while (it.hasNext()) {
            conts[i++] = ((Content)it.next()).getName();
        }
        GenericDialog gd = new GenericDialog("Registration");
        gd.addChoice("template", conts, conts[0]);
        gd.addChoice("model", conts, conts[1]);
        gd.addCheckbox("allow scaling", true);
        this.openDialogs.add(gd);
        gd.showDialog();
        this.openDialogs.remove(gd);
        if (gd.wasCanceled()) {
            return;
        }
        this.templ = this.univ.getContent(gd.getNextChoice());
        this.model = this.univ.getContent(gd.getNextChoice());
        boolean scaling = gd.getNextBoolean();
        this.selectLandmarkSet(this.templ, "LS_MODEL");
    }

    public void doRegistration(Content templ, Content model) {
        this.univ.setStatus("");
        PointList tpoints = templ.getPointList();
        PointList mpoints = model.getPointList();
        if (tpoints.size() < 2 || mpoints.size() < 2) {
            IJ.error((String)"At least two points are required in each of the point lists");
        }
        ArrayList<BenesNamedPoint> sett = new ArrayList<BenesNamedPoint>();
        ArrayList<BenesNamedPoint> setm = new ArrayList<BenesNamedPoint>();
        for (int i = 0; i < tpoints.size(); ++i) {
            BenesNamedPoint pt = tpoints.get(i);
            BenesNamedPoint pm = mpoints.get(pt.getName());
            if (pm == null) continue;
            sett.add(pt);
            setm.add(pm);
        }
        if (sett.size() < 2) {
            IJ.error((String)"At least two points with the same name must exist in both bodies");
            this.univ.setStatus("");
            return;
        }
        DecimalFormat df = new DecimalFormat("00.000");
        String message = "Points used for registration\n \n";
        for (int i = 0; i < sett.size(); ++i) {
            BenesNamedPoint bnp = (BenesNamedPoint)sett.get(i);
            message = message + bnp.getName() + "    " + df.format(bnp.x) + "    " + df.format(bnp.y) + "    " + df.format(bnp.z) + "\n";
        }
        boolean cont = IJ.showMessageWithCancel((String)"Points used for registration", (String)message);
        if (!cont) {
            return;
        }
        BenesNamedPoint[] sm = new BenesNamedPoint[setm.size()];
        BenesNamedPoint[] st = new BenesNamedPoint[sett.size()];
        FastMatrix fm = FastMatrix.bestRigid((Point3d[])setm.toArray(sm), (Point3d[])sett.toArray(st));
        Transform3D t3d = new Transform3D(fm.rowwise16());
        templ.setTransform(new Transform3D());
        model.setTransform(t3d);
        templ.setVisible(true);
        templ.setLocked(true);
        model.setVisible(true);
        model.setLocked(true);
        this.univ.clearSelection();
        this.univ.ui.setHandTool();
        IJ.showMessage((String)"Contents are locked to prevent\naccidental transformations");
        this.exitRegistration();
    }

    public void closeAllDialogs() {
        while (this.openDialogs.size() > 0) {
            GenericDialog gd = (GenericDialog)this.openDialogs.get(0);
            gd.dispose();
            this.openDialogs.remove(gd);
        }
    }

    @Override
    public void transformationStarted(View view) {
    }

    @Override
    public void transformationFinished(View view) {
    }

    @Override
    public void canvasResized() {
    }

    @Override
    public void transformationUpdated(View view) {
    }

    @Override
    public void contentChanged(Content c) {
    }

    @Override
    public void universeClosed() {
    }

    @Override
    public void contentAdded(Content c) {
    }

    @Override
    public void contentRemoved(Content c) {
    }

    @Override
    public void contentSelected(Content c) {
    }
}

