/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.classes;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.scijava.search.SearchResult;
import org.scijava.search.classes.ClassesSearcher;

public class ClassSearchResult
implements SearchResult {
    private final Class<?> c;
    private final String location;
    private final Map<String, String> props;

    public ClassSearchResult(Class<?> c, String baseDir) {
        this.c = c;
        this.location = ClassesSearcher.location(c, baseDir);
        this.props = new LinkedHashMap<String, String>();
        this.props.put("Type", this.types());
        this.props.put("Modifiers", Modifier.toString(c.getModifiers()));
        this.props.put("Location", this.location == null ? "<unknown>" : this.location.toString());
    }

    public Class<?> clazz() {
        return this.c;
    }

    public String location() {
        return this.location;
    }

    @Override
    public String name() {
        return this.c.getName();
    }

    @Override
    public String identifier() {
        return this.c.getSimpleName();
    }

    @Override
    public String context() {
        Package p = this.c.getPackage();
        return p == null ? "" : p.getName();
    }

    @Override
    public String iconPath() {
        return null;
    }

    @Override
    public Map<String, String> properties() {
        return this.props;
    }

    private String types() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.c.isAnonymousClass()) {
            types.add("anonymous");
        }
        if (this.c.isLocalClass()) {
            types.add("local");
        }
        if (this.c.isMemberClass()) {
            types.add("member");
        }
        if (this.c.isSynthetic()) {
            types.add("synthetic");
        }
        if (this.c.isArray()) {
            types.add("array");
        }
        if (this.c.isAnnotation()) {
            types.add("annotation");
        }
        if (this.c.isEnum()) {
            types.add("enum");
        }
        if (this.c.isInterface()) {
            types.add("interface");
        }
        if (this.c.isPrimitive()) {
            types.add("primitive");
        }
        if (!(this.c.isArray() || this.c.isEnum() || this.c.isInterface() || this.c.isPrimitive())) {
            types.add("class");
        }
        return String.join((CharSequence)", ", types);
    }
}

