/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Enumeration;
import org.scijava.java3d.Alpha;
import org.scijava.java3d.Interpolator;
import org.scijava.java3d.Node;
import org.scijava.java3d.NodeReferenceTable;
import org.scijava.java3d.Switch;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupOnElapsedFrames;

public class SwitchValueInterpolator
extends Interpolator {
    Switch target;
    int firstSwitchIndex;
    int lastSwitchIndex;
    int childCount;
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    SwitchValueInterpolator() {
    }

    public SwitchValueInterpolator(Alpha alpha, Switch target) {
        super(alpha);
        this.target = target;
        this.firstSwitchIndex = 0;
        this.childCount = target.numChildren();
        this.lastSwitchIndex = this.childCount - 1;
    }

    public SwitchValueInterpolator(Alpha alpha, Switch target, int firstChildIndex, int lastChildIndex) {
        super(alpha);
        this.target = target;
        this.firstSwitchIndex = firstChildIndex;
        this.lastSwitchIndex = lastChildIndex;
        this.computeChildCount();
    }

    public void setFirstChildIndex(int firstIndex) {
        this.firstSwitchIndex = firstIndex;
        this.computeChildCount();
    }

    public int getFirstChildIndex() {
        return this.firstSwitchIndex;
    }

    public void setLastChildIndex(int lastIndex) {
        this.lastSwitchIndex = lastIndex;
        this.computeChildCount();
    }

    public int getLastChildIndex() {
        return this.lastSwitchIndex;
    }

    public void setTarget(Switch target) {
        this.target = target;
    }

    public Switch getTarget() {
        return this.target;
    }

    @Override
    public void processStimulus(Enumeration criteria) {
        WakeupCriterion criterion = this.passiveWakeupCriterion;
        if (this.alpha != null) {
            float value = this.alpha.value();
            if (value != this.prevAlphaValue) {
                int child = this.lastSwitchIndex > this.firstSwitchIndex ? this.firstSwitchIndex + (int)(value * (float)(this.childCount - 1) + 0.5f) : this.firstSwitchIndex - (int)(value * (float)(this.childCount - 1) + 0.5f);
                this.target.setWhichChild(child);
                this.prevAlphaValue = value;
            }
            if (!this.alpha.finished() && !this.alpha.isPaused()) {
                criterion = this.defaultWakeupCriterion;
            }
        }
        this.wakeupOn(criterion);
    }

    private final void computeChildCount() {
        this.childCount = this.lastSwitchIndex >= this.firstSwitchIndex ? this.lastSwitchIndex - this.firstSwitchIndex + 1 : this.firstSwitchIndex - this.lastSwitchIndex + 1;
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        SwitchValueInterpolator svi = new SwitchValueInterpolator();
        svi.duplicateNode(this, forceDuplicate);
        return svi;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        SwitchValueInterpolator si = (SwitchValueInterpolator)originalNode;
        this.setFirstChildIndex(si.getFirstChildIndex());
        this.setLastChildIndex(si.getLastChildIndex());
        this.setTarget(si.getTarget());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        super.updateNodeReferences(referenceTable);
        Switch n = this.getTarget();
        if (n != null) {
            this.setTarget((Switch)referenceTable.getNewObjectReference(n));
        }
    }
}

