/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.BehaviorStructure;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.java3d.WakeupCriterion;
import org.scijava.java3d.WakeupIndexedList;

public final class WakeupOnElapsedFrames
extends WakeupCriterion {
    static final int COND_IN_BS_LIST = 0;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 1;
    boolean passive;
    int frameCount;
    int countdown;

    public WakeupOnElapsedFrames(int frameCount) {
        this(frameCount, false);
    }

    public WakeupOnElapsedFrames(int frameCount, boolean passive) {
        if (frameCount < 0) {
            throw new IllegalArgumentException(J3dI18N.getString("WakeupOnElapsedFrames0"));
        }
        this.frameCount = frameCount;
        this.passive = passive;
        WakeupIndexedList.init(this, 1);
    }

    public int getElapsedFrameCount() {
        return this.frameCount;
    }

    public boolean isPassive() {
        return this.passive;
    }

    void newFrame() {
        if (this.countdown == 0) {
            this.setTriggered();
        } else {
            --this.countdown;
        }
    }

    @Override
    void addBehaviorCondition(BehaviorStructure bs) {
        this.countdown = this.frameCount;
        bs.wakeupOnElapsedFrames.add(this);
        if (!this.passive && this.behav != null && this.behav.enable) {
            ++bs.activeWakeupOnFrameCount;
        }
        VirtualUniverse.mc.sendRunMessage(bs.universe, 256);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure bs) {
        bs.wakeupOnElapsedFrames.remove(this);
        if (!this.passive && this.behav != null && this.behav.enable) {
            --bs.activeWakeupOnFrameCount;
        }
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure bs) {
        this.countdown = this.frameCount;
    }
}

