/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type.context;

import java.io.Serializable;
import java.text.Format;
import java.text.ParseException;
import org.ojalgo.ProgrammingError;
import org.ojalgo.type.context.GenericContext;
import org.ojalgo.type.context.TypeContext;

abstract class FormatContext<T, F extends Format>
implements TypeContext<T>,
Serializable {
    public static final boolean NBSP = true;
    private boolean myConfigured = false;
    private final F myFormat;

    FormatContext(F format) {
        ProgrammingError.throwIfNull(format);
        this.myFormat = (Format)((Format)format).clone();
    }

    @Override
    public final String format(Object object) {
        if (object != null) {
            try {
                if (!this.myConfigured) {
                    this.configureFormat(this.myFormat, object);
                    this.myConfigured = true;
                }
                return ((Format)this.myFormat).format(object).replace(' ', '\u00a0');
            }
            catch (IllegalArgumentException exception) {
                return this.handleFormatException(this.myFormat, object);
            }
        }
        return null;
    }

    public final F getFormat() {
        return (F)((Format)((Format)this.format()).clone());
    }

    public final <G> TypeContext<G> newFormat(F format) {
        return new GenericContext(this, (Format)format);
    }

    @Override
    public final T parse(CharSequence string) {
        if (string != null) {
            try {
                return (T)((Format)this.myFormat).parseObject(string.toString().replace('\u00a0', ' '));
            }
            catch (ParseException anException) {
                return this.handleParseException(this.myFormat, string.toString());
            }
        }
        return null;
    }

    protected abstract void configureFormat(F var1, Object var2);

    protected abstract String handleFormatException(F var1, Object var2);

    protected abstract T handleParseException(F var1, String var2);

    final F format() {
        return this.myFormat;
    }

    final boolean isConfigured() {
        return this.myConfigured;
    }
}

