/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import net.imagej.Dataset;
import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.util.Util;

public class DatasetImgFactory<T>
extends ImgFactory<T> {
    private Dataset dataset;
    private ImgCreator creator;

    public DatasetImgFactory(T type, Dataset dataset, ImgCreator creator) {
        super(type);
        this.dataset = dataset;
        this.creator = creator;
    }

    public Img<T> create(long ... dimensions) {
        return this.creator.create(this.dataset, dimensions, this.type());
    }

    public Img<T> create(Dimensions dimensions) {
        long[] size = new long[dimensions.numDimensions()];
        dimensions.dimensions(size);
        return this.create(size);
    }

    public Img<T> create(int[] dimensions) {
        return this.create(Util.int2long((int[])dimensions));
    }

    public <S> DatasetImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        return new DatasetImgFactory<S>(type, this.dataset, this.creator);
    }

    @Deprecated
    public Img<T> create(long[] dim, T type) {
        return this.creator.create(this.dataset, dim, type);
    }

    static interface ImgCreator {
        public <T> Img<T> create(Dataset var1, long[] var2, T var3);
    }
}

