/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.convert;

import java.util.Set;
import net.imagej.convert.ConciseConverter;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.roi.labeling.LabelingMapping;
import net.imglib2.type.numeric.IntegerType;
import org.scijava.convert.Converter;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.Types;

@Plugin(type=Converter.class)
public class ImgLabelingToImgConverter<T extends IntegerType<T>>
extends ConciseConverter<ImgLabeling, Img> {
    @Parameter
    private LogService log;

    public ImgLabelingToImgConverter() {
        super(ImgLabeling.class, Img.class, null);
    }

    @Override
    protected Img convert(ImgLabeling src) {
        ImgLabeling labeling = src;
        if (!this.singletonLabels(labeling)) {
            this.log.warn((Object)"Converting ImgLabeling with overlapping labels. Labels cannot be preserved in output, creating continuous integers.");
            return (Img)labeling.getIndexImg();
        }
        if (!this.integerLabels(labeling)) {
            this.log.warn((Object)"Converting non-integer label type. Labels cannot be preserved in output, creating continuous integers.");
            return (Img)labeling.getIndexImg();
        }
        Img indexImg = (Img)labeling.getIndexImg();
        Img img = indexImg.factory().create((Dimensions)indexImg);
        LabelingMapping mapping = labeling.getMapping();
        LoopBuilder.setImages((RandomAccessibleInterval)labeling, (RandomAccessibleInterval)img).forEachPixel((l, i) -> {
            Set labels = mapping.labelsAtIndex(l.getIndex().getInteger());
            if (!labels.isEmpty()) {
                i.setInteger(((Integer)labels.iterator().next()).intValue());
            }
        });
        return img;
    }

    private boolean integerLabels(ImgLabeling labeling) {
        return Types.isAssignable(labeling.getMapping().labelsAtIndex(1).iterator().next().getClass(), Integer.class);
    }

    private boolean singletonLabels(ImgLabeling labeling) {
        LabelingMapping mapping = labeling.getMapping();
        return mapping.getLabels().size() == mapping.getLabelSets().size() - 1;
    }
}

