/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.clm.archipelago.network;

import edu.utexas.clm.archipelago.FijiArchipelago;
import edu.utexas.clm.archipelago.compute.ProcessManager;
import edu.utexas.clm.archipelago.data.ClusterMessage;
import edu.utexas.clm.archipelago.listen.MessageType;
import edu.utexas.clm.archipelago.listen.TransceiverExceptionListener;
import edu.utexas.clm.archipelago.listen.TransceiverListener;
import edu.utexas.clm.archipelago.network.translation.Bottle;
import edu.utexas.clm.archipelago.network.translation.Bottler;
import edu.utexas.clm.archipelago.network.translation.FileTranslator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class MessageXC {
    public static final long DEFAULT_WAIT = 10000L;
    public static final TimeUnit DEFAULT_UNIT = TimeUnit.MILLISECONDS;
    private final List<Bottler> bottlers;
    private final LinkedBlockingQueue<ClusterMessage> messageQ;
    private BottlingOutputStream objectOutputStream;
    private BottlingInputStream objectInputStream;
    private FileTranslator fileTranslator;
    private String host;
    private final Thread txThread;
    private final Thread rxThread;
    private final AtomicBoolean active;
    private final AtomicLong lastSentID;
    private final long waitTime;
    private final TimeUnit tUnit;
    private TransceiverListener xcListener;
    private final TransceiverExceptionListener xcExceptionListener;
    private final OutputStream outStream;
    private final InputStream inStream;
    private long id;
    private final ReentrantLock listenerLock;
    private final MessageXC xc = this;

    public MessageXC(InputStream inStream, OutputStream outStream, TransceiverListener listener, TransceiverExceptionListener listenerE) throws IOException {
        this(inStream, outStream, listener, listenerE, 10000L, DEFAULT_UNIT);
    }

    public MessageXC(InputStream inStream, OutputStream outStream, TransceiverListener listener, TransceiverExceptionListener listenerE, long wait, TimeUnit unit) throws IOException {
        FijiArchipelago.debug("Creating Message Transciever");
        this.fileTranslator = new NullFileTranslator();
        this.bottlers = Collections.synchronizedList(new Vector());
        this.messageQ = new LinkedBlockingQueue();
        this.objectOutputStream = new BottlingOutputStream(outStream);
        this.objectInputStream = new BottlingInputStream(inStream);
        FijiArchipelago.debug("XC: streams are set");
        this.inStream = inStream;
        this.outStream = outStream;
        this.active = new AtomicBoolean(true);
        this.lastSentID = new AtomicLong(-1L);
        this.waitTime = wait;
        this.tUnit = unit;
        this.xcListener = listener;
        this.xcExceptionListener = listenerE;
        this.listenerLock = new ReentrantLock();
        this.host = "Unknown host";
        this.txThread = new TXThread();
        this.rxThread = new RXThread();
        this.id = -1L;
        this.rxThread.start();
        this.txThread.start();
    }

    public long getLastProcessID() {
        return this.lastSentID.get();
    }

    public void close() {
        if (this.active.get()) {
            FijiArchipelago.debug("XC: Got close.");
            this.active.set(false);
            this.listenerLock.lock();
            this.xcListener.streamClosed();
            this.listenerLock.unlock();
            this.txThread.interrupt();
            this.rxThread.interrupt();
            try {
                this.inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setListener(TransceiverListener listener) {
        this.xcListener = listener;
    }

    public boolean join() {
        if (this.txThread.isAlive() || this.rxThread.isAlive()) {
            try {
                this.txThread.join();
                this.rxThread.join();
                return true;
            }
            catch (InterruptedException ie) {
                return false;
            }
        }
        return true;
    }

    public synchronized boolean queueMessage(ClusterMessage message) {
        try {
            FijiArchipelago.debug("TX: queuing message " + (Object)((Object)message.type));
            if (message.type == MessageType.ERROR) {
                Throwable t = (Throwable)message.o;
                t.printStackTrace();
            }
            this.messageQ.put(message);
            FijiArchipelago.debug("TX: queued successfully");
            return true;
        }
        catch (InterruptedException ie) {
            FijiArchipelago.debug("TX: message rejected: " + ie.getCause());
            return false;
        }
    }

    public boolean queueMessage(MessageType type) {
        ClusterMessage cm = new ClusterMessage(type);
        return this.queueMessage(cm);
    }

    public boolean queueMessage(MessageType type, Serializable o) {
        ClusterMessage cm = new ClusterMessage(type);
        cm.o = o;
        return this.queueMessage(cm);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setHostname(String host) {
        this.host = host;
    }

    public String getHostname() {
        return this.host;
    }

    public String getLocalPath(String remotePath) {
        return this.fileTranslator.getLocalPath(remotePath);
    }

    public String getRemotePath(String localPath) {
        return this.fileTranslator.getRemotePath(localPath);
    }

    public File getLocalFile(File remoteFile) {
        return new File(this.getLocalPath(remoteFile.getAbsolutePath()));
    }

    public File getRemoteFile(File localFile) {
        return new File(this.fileTranslator.getRemotePath(localFile.getAbsolutePath()));
    }

    public synchronized void setFileSystemTranslator(FileTranslator ft) {
        this.fileTranslator = ft;
    }

    public synchronized void unsetFileSystemTranslation() {
        if (!(this.fileTranslator instanceof NullFileTranslator)) {
            this.fileTranslator = new NullFileTranslator();
        }
    }

    public void addBottler(Bottler bottler) {
        this.bottlers.add(bottler);
    }

    public List<Bottler> getBottlers() {
        return this.bottlers;
    }

    private class TXThread
    extends Thread {
        private TXThread() {
        }

        @Override
        public void run() {
            while (MessageXC.this.active.get()) {
                ClusterMessage nextMessage = null;
                try {
                    nextMessage = (ClusterMessage)MessageXC.this.messageQ.poll(MessageXC.this.waitTime, MessageXC.this.tUnit);
                }
                catch (InterruptedException ie) {
                    MessageXC.this.active.set(false);
                }
                if (nextMessage == null) continue;
                try {
                    if (nextMessage.type != MessageType.BEAT) {
                        FijiArchipelago.debug("TX: " + MessageXC.this.id + " writing message " + ClusterMessage.messageToString(nextMessage));
                    }
                    MessageXC.this.objectOutputStream.writeObject(nextMessage);
                    MessageXC.this.objectOutputStream.flush();
                }
                catch (Throwable e) {
                    MessageXC.this.xcExceptionListener.handleTXThrowable(e, MessageXC.this.xc, nextMessage);
                }
                finally {
                    try {
                        MessageXC.this.objectOutputStream = new BottlingOutputStream(MessageXC.this.outStream);
                    }
                    catch (IOException ioe) {
                        MessageXC.this.close();
                    }
                }
            }
        }
    }

    private class RXThread
    extends Thread {
        private RXThread() {
        }

        @Override
        public void run() {
            while (MessageXC.this.active.get()) {
                try {
                    ClusterMessage message = (ClusterMessage)MessageXC.this.objectInputStream.readObject();
                    if (message.type != MessageType.BEAT) {
                        FijiArchipelago.debug("RX: " + MessageXC.this.id + " got message " + ClusterMessage.messageToString(message));
                        if (message.type == MessageType.PROCESS) {
                            ProcessManager pm = (ProcessManager)message.o;
                            FijiArchipelago.debug("RX: Got message for job " + pm.getID());
                        }
                    }
                    MessageXC.this.listenerLock.lock();
                    MessageXC.this.xcListener.handleMessage(message);
                    MessageXC.this.listenerLock.unlock();
                }
                catch (Throwable e) {
                    MessageXC.this.xcExceptionListener.handleRXThrowable(e, MessageXC.this.xc, null);
                }
                finally {
                    try {
                        MessageXC.this.objectInputStream = new BottlingInputStream(MessageXC.this.inStream);
                    }
                    catch (IOException ioe) {
                        MessageXC.this.close();
                    }
                }
            }
        }
    }

    private class BottlingOutputStream
    extends ObjectOutputStream {
        public BottlingOutputStream(OutputStream os) throws IOException {
            super(os);
            this.enableReplaceObject(true);
        }

        @Override
        protected final Object replaceObject(Object object) throws IOException {
            ArrayList bottlerList = new ArrayList(MessageXC.this.bottlers);
            for (Bottler bottler : bottlerList) {
                if (!bottler.accepts(object)) continue;
                return bottler.bottle(object, MessageXC.this.xc);
            }
            return object;
        }
    }

    private class BottlingInputStream
    extends ObjectInputStream {
        public BottlingInputStream(InputStream is) throws IOException {
            super(is);
            this.enableResolveObject(true);
        }

        @Override
        protected final Object resolveObject(Object object) throws IOException {
            if (object instanceof Bottle) {
                Bottle bottle = (Bottle)object;
                return bottle.unBottle(MessageXC.this.xc);
            }
            return object;
        }
    }

    private class NullFileTranslator
    implements FileTranslator {
        private NullFileTranslator() {
        }

        @Override
        public String getLocalPath(String remotePath) {
            return remotePath;
        }

        @Override
        public String getRemotePath(String localPath) {
            return localPath;
        }
    }
}

