/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.data.generic.sequence;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.base.ViewSetupAttributes;
import mpicbg.spim.data.generic.base.XmlIoEntity;
import mpicbg.spim.data.generic.base.XmlIoEntityMap;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.XmlIoBasicViewSetup;
import org.jdom2.Content;
import org.jdom2.Element;

public class XmlIoBasicViewSetups<T extends BasicViewSetup>
extends XmlIoEntityMap<T> {
    private final XmlIoBasicViewSetup<T> xmlIoViewSetup;
    private final Map<String, XmlIoEntityMap<?>> attributeNameToXmlIoMap;

    public XmlIoBasicViewSetups(Class<T> klass) {
        this(klass, new XmlIoBasicViewSetup<T>(klass));
    }

    private XmlIoBasicViewSetups(Class<T> klass, XmlIoBasicViewSetup<T> xmlIoViewSetup) {
        super("ViewSetups", klass, xmlIoViewSetup);
        this.xmlIoViewSetup = xmlIoViewSetup;
        this.attributeNameToXmlIoMap = new HashMap();
        this.handledTags.add("Attributes");
    }

    @Override
    public Element toXml(Collection<T> setups) throws SpimDataException {
        Element elem = super.toXml(setups);
        HashMap<String, HashMap<Integer, Entity>> attributeMap = new HashMap<String, HashMap<Integer, Entity>>();
        for (BasicViewSetup basicViewSetup : setups) {
            for (Map.Entry<String, Entity> entry : basicViewSetup.getAttributes().entrySet()) {
                String name = entry.getKey();
                Entity attribute = entry.getValue();
                HashMap<Integer, Entity> map = (HashMap<Integer, Entity>)attributeMap.get(name);
                if (map == null) {
                    map = new HashMap<Integer, Entity>();
                    attributeMap.put(name, map);
                }
                map.put(attribute.getId(), attribute);
            }
        }
        for (Map.Entry entry : attributeMap.entrySet()) {
            String name = (String)entry.getKey();
            HashMap map = (HashMap)entry.getValue();
            XmlIoEntityMap<?> xmlIoAttributes = this.getXmlIoForAttributeName(name);
            Element c = xmlIoAttributes.toXml(map);
            c.setAttribute("name", name);
            elem.addContent((Content)c);
        }
        return elem;
    }

    @Override
    public HashMap<Integer, T> fromXml(Element elem) throws SpimDataException {
        HashMap<String, HashMap<Integer, ? extends Entity>> attributeMap = new HashMap<String, HashMap<Integer, ? extends Entity>>();
        for (Element c : elem.getChildren("Attributes")) {
            String name = c.getAttributeValue("name");
            XmlIoEntityMap<?> xmlIoAttributes = this.getXmlIoForAttributeName(name);
            attributeMap.put(name, (HashMap<Integer, ? extends Entity>)xmlIoAttributes.fromXml(c));
        }
        this.xmlIoViewSetup.setAttributeMap(attributeMap);
        return super.fromXml(elem);
    }

    private XmlIoEntityMap<?> getXmlIoForAttributeName(String name) throws SpimDataException {
        XmlIoEntityMap<?> xmlIoAttributes = this.attributeNameToXmlIoMap.get(name);
        if (xmlIoAttributes == null) {
            XmlIoEntity<?> xmlIoAttribute = ViewSetupAttributes.createXmlIoForName(name);
            xmlIoAttributes = new XmlIoEntityMap("Attributes", xmlIoAttribute.getEntityClass(), xmlIoAttribute);
            this.attributeNameToXmlIoMap.put(name, xmlIoAttributes);
        }
        return xmlIoAttributes;
    }
}

