/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import view5d.AnElement;

public class IntegerElement
extends AnElement {
    public int[] myData;
    int SizeXY;
    int NumBytes;

    IntegerElement(int SX, int SY, int SZ, int Bts, double MaxVal) {
        super(SX, SY, SZ, MaxVal);
        this.NumBytes = Bts;
        this.myData = new int[this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
        this.SizeXY = this.Sizes[0] * this.Sizes[1];
        this.DataType = IntegerType;
    }

    @Override
    void Clear() {
        for (int i = 0; i < this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0;
        }
    }

    @Override
    void DeleteData() {
        this.myData = null;
    }

    @Override
    int GetStdByteNum() {
        return 4;
    }

    @Override
    void SetValueAt(int x, int y, int z, double val) {
        this.myData[x + this.Sizes[0] * y + this.SizeXY * z] = (int)val;
    }

    @Override
    int GetIntValueAt(int x, int y, int z) {
        return (int)(((double)this.myData[x + this.Sizes[0] * y + this.SizeXY * z] - this.shift) * this.scaleI);
    }

    @Override
    int GetByteValueAt(int x, int y, int z) {
        return (int)(((double)this.myData[x + this.Sizes[0] * y + this.SizeXY * z] - this.shift) * this.scaleB);
    }

    @Override
    double GetRawValueAt(int x, int y, int z) {
        return this.myData[x + this.Sizes[0] * y + this.SizeXY * z];
    }

    @Override
    double GetValueAt(int x, int y, int z) {
        return (double)this.myData[x + this.Sizes[0] * y + this.SizeXY * z] * this.ScaleV + this.OffsetV;
    }

    @Override
    void ConvertSliceFromSimilar(int myslice, int bufslice, Object Ibuffer, int mstep, int moff) {
        short[] mbuffer = (short[])Ibuffer;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = mbuffer[bufslice * this.SizeXY + i + moff] & 0xFFFF;
        }
    }

    @Override
    void ConvertSliceFromByte(int myslice, int bufslice, byte[] Ibuffer, int mstep, int moff) {
        int SliceSize = this.NumBytes * this.SizeXY;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            int val;
            this.myData[i + this.SizeXY * myslice] = val = Ibuffer[bufslice * SliceSize + this.NumBytes * (i + moff)] & 0xFF;
            for (int b = 1; b < this.NumBytes; ++b) {
                val = Ibuffer[bufslice * SliceSize + this.NumBytes * (i + moff) + b] & 0xFF;
                int n = i + this.SizeXY * myslice;
                this.myData[n] = this.myData[n] | val << 8 * b;
            }
        }
    }

    @Override
    void ConvertSliceFromRGB(int myslice, int bufslice, int[] mbuffer, int mstep, int moff, int soff) {
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = mbuffer[bufslice * this.SizeXY + i + moff];
        }
    }

    @Override
    void CopySliceToSimilar(int myslice, Object buffer) {
        short[] mbuffer = (short[])buffer;
        for (int i = 0; i < this.SizeXY; ++i) {
            mbuffer[i] = (short)this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice];
        }
    }

    void CopyIntVal(AnElement other, double Min, double Max) {
        for (int z = 0; z < this.Sizes[2]; ++z) {
            for (int y = 0; y < this.Sizes[1]; ++y) {
                for (int x = 0; x < this.Sizes[0]; ++x) {
                    double val = other.GetValueAt(x, y, z);
                    if ((val = (val - Min) / (Max - Min)) < 0.0) {
                        val = 0.0;
                    }
                    if (val > 1.0) {
                        val = 1.0;
                    }
                    this.SetValueAt(x, y, z, 32767.0 * val);
                }
            }
        }
    }
}

