/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.scijava.widget.AbstractInputPanel;
import org.scijava.widget.InputWidget;
import org.scijava.widget.WidgetModel;

public class SwingInputPanel
extends AbstractInputPanel<JPanel, JPanel> {
    private JPanel uiComponent;

    public void addWidget(InputWidget<?, JPanel> widget) {
        super.addWidget(widget);
        JPanel widgetPane = (JPanel)widget.getComponent();
        WidgetModel model = widget.get();
        if (widget.isLabeled()) {
            JLabel l = new JLabel(model.getWidgetLabel());
            String desc = model.getItem().getDescription();
            if (desc != null && !desc.isEmpty()) {
                l.setToolTipText(desc);
            }
            this.getComponent().add(l);
            this.getComponent().add(widgetPane);
        } else {
            this.getComponent().add((Component)widgetPane, "span");
        }
    }

    public Class<JPanel> getWidgetComponentType() {
        return JPanel.class;
    }

    public JPanel getComponent() {
        if (this.uiComponent == null) {
            this.uiComponent = new JPanel();
            MigLayout layout = new MigLayout("fillx,wrap 2", "[right]10[fill,grow]");
            this.uiComponent.setLayout((LayoutManager)layout);
        }
        return this.uiComponent;
    }

    public Class<JPanel> getComponentType() {
        return JPanel.class;
    }
}

