/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.volumeviewer;

import fiji.plugin.volumeviewer.Control;

class Transform {
    private Control control;
    private float[][] mP;
    private float xRot;
    private float yRot;
    private float zRot;
    private float rotAngle = 0.0f;
    private float xSOff;
    private float ySOff;
    private float xOff;
    private float yOff;
    private float xvOff;
    private float yvOff;
    private float zvOff;
    private float scale = 1.0f;
    private float zAspect = 1.0f;
    private float a00;
    private float a01;
    private float a02;
    private float a03;
    private float a10;
    private float a11;
    private float a12;
    private float a13;
    private float a20;
    private float a21;
    private float a22;
    private float a23;
    private float ai00;
    private float ai01;
    private float ai02;
    private float ai03;
    private float ai10;
    private float ai11;
    private float ai12;
    private float ai13;
    private float ai20;
    private float ai21;
    private float ai22;
    private float ai23;
    private float degreeX;
    private float degreeY;
    private float degreeZ;

    void initializeTransformation() {
        float s;
        if (this.control.LOG) {
            System.out.println("initializeTransformation");
        }
        float[][] m = new float[4][4];
        m[0][0] = s = this.scale;
        m[0][1] = 0.0f;
        m[0][2] = 0.0f;
        m[0][3] = -s * this.xvOff;
        m[1][0] = 0.0f;
        m[1][1] = s;
        m[1][2] = 0.0f;
        m[1][3] = -s * this.yvOff;
        m[2][0] = 0.0f;
        m[2][1] = 0.0f;
        m[2][2] = s * this.zAspect;
        m[2][3] = -s * this.zAspect * this.zvOff;
        m[3][0] = 0.0f;
        m[3][1] = 0.0f;
        m[3][2] = 0.0f;
        m[3][3] = 1.0f;
        float[][] mR = new float[4][4];
        float u = this.xRot;
        float v = this.yRot;
        float w = this.zRot;
        float u2 = u * u;
        float v2 = v * v;
        float w2 = w * w;
        float cos = (float)Math.cos(this.rotAngle);
        float sin = (float)Math.sin(this.rotAngle);
        this.rotAngle = 0.0f;
        mR[0][0] = u2 + (1.0f - u2) * cos;
        mR[0][1] = u * v * (1.0f - cos) - w * sin;
        mR[0][2] = u * w * (1.0f - cos) + v * sin;
        mR[1][0] = u * v * (1.0f - cos) + w * sin;
        mR[1][1] = v2 + (1.0f - v2) * cos;
        mR[1][2] = v * w * (1.0f - cos) - u * sin;
        mR[2][0] = u * w * (1.0f - cos) - v * sin;
        mR[2][1] = v * w * (1.0f - cos) + u * sin;
        mR[2][2] = w2 + (1.0f - w2) * cos;
        mR[3][3] = 1.0f;
        float[][] m_RP = new float[4][4];
        this.matProd(m_RP, mR, this.mP);
        this.matCopy4(this.mP, m_RP);
        double ar = 0.0;
        double br = 0.0;
        double gr = 0.0;
        if (this.mP[2][0] != 1.0f && this.mP[2][0] != -1.0f) {
            br = -Math.asin(this.mP[2][0]);
            double cosbr = Math.cos(br);
            ar = Math.atan2((double)this.mP[2][1] / cosbr, (double)this.mP[2][2] / cosbr);
            gr = Math.atan2((double)this.mP[1][0] / cosbr, (double)this.mP[0][0] / cosbr);
        } else {
            gr = 0.0;
            if (this.mP[2][0] == -1.0f) {
                br = 1.5707963267948966;
                ar = Math.atan2(this.mP[0][1], this.mP[0][2]);
            } else {
                br = -1.5707963267948966;
                ar = Math.atan2(-this.mP[0][1], -this.mP[0][2]);
            }
        }
        this.degreeX = (float)Math.toDegrees(ar);
        this.degreeY = (float)Math.toDegrees(br);
        this.degreeZ = (float)Math.toDegrees(gr);
        float[][] mat = new float[4][4];
        this.matProd(mat, this.mP, m);
        this.a00 = mat[0][0];
        this.a01 = mat[0][1];
        this.a02 = mat[0][2];
        this.a03 = mat[0][3] + this.xSOff + this.xOff * this.scale;
        this.a10 = mat[1][0];
        this.a11 = mat[1][1];
        this.a12 = mat[1][2];
        this.a13 = mat[1][3] + this.ySOff + this.yOff * this.scale;
        this.a20 = mat[2][0];
        this.a21 = mat[2][1];
        this.a22 = mat[2][2];
        this.a23 = mat[2][3];
        float[][] matInv = new float[4][4];
        this.matInv4(matInv, mat);
        this.ai00 = matInv[0][0];
        this.ai01 = matInv[0][1];
        this.ai02 = matInv[0][2];
        this.ai03 = matInv[0][3];
        this.ai10 = matInv[1][0];
        this.ai11 = matInv[1][1];
        this.ai12 = matInv[1][2];
        this.ai13 = matInv[1][3];
        this.ai20 = matInv[2][0];
        this.ai21 = matInv[2][1];
        this.ai22 = matInv[2][2];
        this.ai23 = matInv[2][3];
    }

    public float getDegreeX() {
        return this.degreeX;
    }

    public float getDegreeY() {
        return this.degreeY;
    }

    public float getDegreeZ() {
        return this.degreeZ;
    }

    void matProd(float[][] z, float[][] u, float[][] v) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                z[i][j] = 0.0f;
                for (int k = 0; k < 4; ++k) {
                    float[] fArray = z[i];
                    int n = j;
                    fArray[n] = fArray[n] + u[i][k] * v[k][j];
                }
            }
        }
    }

    public void setView(double angleX, double angleY, double angleZ) {
        float cosX = (float)Math.cos(angleX);
        float sinX = (float)Math.sin(angleX);
        float cosY = (float)Math.cos(angleY);
        float sinY = (float)Math.sin(angleY);
        float cosZ = (float)Math.cos(angleZ);
        float sinZ = (float)Math.sin(angleZ);
        float[][] mX = new float[4][4];
        mX[0][0] = 1.0f;
        mX[0][1] = 0.0f;
        mX[0][2] = 0.0f;
        mX[0][3] = 0.0f;
        mX[1][0] = 0.0f;
        mX[1][1] = cosX;
        mX[1][2] = -sinX;
        mX[1][3] = 0.0f;
        mX[2][0] = 0.0f;
        mX[2][1] = sinX;
        mX[2][2] = cosX;
        mX[2][3] = 0.0f;
        mX[3][0] = 0.0f;
        mX[3][1] = 0.0f;
        mX[3][2] = 0.0f;
        mX[3][3] = 1.0f;
        float[][] mY = new float[4][4];
        mY[0][0] = cosY;
        mY[0][1] = 0.0f;
        mY[0][2] = sinY;
        mY[0][3] = 0.0f;
        mY[1][0] = 0.0f;
        mY[1][1] = 1.0f;
        mY[1][2] = 0.0f;
        mY[1][3] = 0.0f;
        mY[2][0] = -sinY;
        mY[2][1] = 0.0f;
        mY[2][2] = cosY;
        mY[2][3] = 0.0f;
        mY[3][0] = 0.0f;
        mY[3][1] = 0.0f;
        mY[3][2] = 0.0f;
        mY[3][3] = 1.0f;
        float[][] mZ = new float[4][4];
        mZ[0][0] = cosZ;
        mZ[0][1] = -sinZ;
        mZ[0][2] = 0.0f;
        mZ[0][3] = 0.0f;
        mZ[1][0] = sinZ;
        mZ[1][1] = cosZ;
        mZ[1][2] = 0.0f;
        mZ[1][3] = 0.0f;
        mZ[2][0] = 0.0f;
        mZ[2][1] = 0.0f;
        mZ[2][2] = 1.0f;
        mZ[2][3] = 0.0f;
        mZ[3][0] = 0.0f;
        mZ[3][1] = 0.0f;
        mZ[3][2] = 0.0f;
        mZ[3][3] = 1.0f;
        float[][] m_XY = new float[4][4];
        this.matProd(m_XY, mY, mX);
        this.matProd(this.mP, mZ, m_XY);
        this.initializeTransformation();
    }

    void matInv4(float[][] z, float[][] u) {
        int j;
        int i;
        int[] ii = new int[4];
        float[][] w = new float[4][4];
        int n = 4;
        this.matCopy4(w, u);
        this.matUnit4(z);
        for (i = 0; i < n; ++i) {
            ii[i] = this.matge4(w, i);
            this.matXr4(w, i, ii[i]);
            for (j = 0; j < n; ++j) {
                if (i == j) continue;
                float f = -w[i][j] / w[i][i];
                this.matAc4(w, j, j, f, i);
                this.matAc4(z, j, j, f, i);
            }
        }
        for (i = 0; i < n; ++i) {
            this.matMc4(z, 1.0f / w[i][i], i);
        }
        for (i = 0; i < n; ++i) {
            j = n - i - 1;
            this.matXc4(z, j, ii[j]);
        }
    }

    int matge4(float[][] p, int n) {
        int m = n;
        float g = p[n][n];
        g = (double)g < 0.0 ? -g : g;
        for (int i = n; i < 4; ++i) {
            float h = p[i][n];
            float f = h = (double)h < 0.0 ? -h : h;
            if (h < g) continue;
            g = h;
            m = i;
        }
        return m;
    }

    void matCopy4(float[][] z, float[][] x) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                z[i][j] = x[i][j];
            }
        }
    }

    void matUnit4(float[][] z) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                z[i][j] = 0.0f;
            }
            z[i][i] = 1.0f;
        }
    }

    void matXc4(float[][] z, int i, int j) {
        if (i == j) {
            return;
        }
        for (int k = 0; k < 4; ++k) {
            float t = z[k][i];
            z[k][i] = z[k][j];
            z[k][j] = t;
        }
    }

    void matXr4(float[][] z, int i, int j) {
        if (i == j) {
            return;
        }
        for (int k = 0; k < 4; ++k) {
            float t = z[i][k];
            z[i][k] = z[j][k];
            z[j][k] = t;
        }
    }

    void matAc4(float[][] z, int i, int j, float f, int k) {
        for (int l = 0; l < 4; ++l) {
            z[l][i] = z[l][j] + f * z[l][k];
        }
    }

    void matMc4(float[][] z, float f, int i) {
        for (int j = 0; j < 4; ++j) {
            float[] fArray = z[j];
            int n = i;
            fArray[n] = fArray[n] * f;
        }
    }

    final float[] trVol2Screen(float[] xyzV) {
        float xV = xyzV[0];
        float yV = xyzV[1];
        float zV = xyzV[2];
        float[] xyzS = new float[]{this.a00 * xV + this.a01 * yV + this.a02 * zV + this.a03, this.a10 * xV + this.a11 * yV + this.a12 * zV + this.a13, this.a20 * xV + this.a21 * yV + this.a22 * zV + this.a23};
        return xyzS;
    }

    final float[] trVol2Screen(float xV, float yV, float zV) {
        float[] xyzS = new float[]{this.a00 * xV + this.a01 * yV + this.a02 * zV + this.a03, this.a10 * xV + this.a11 * yV + this.a12 * zV + this.a13, this.a20 * xV + this.a21 * yV + this.a22 * zV + this.a23};
        return xyzS;
    }

    final float[] trScreen2Vol(float xS, float yS, float zS) {
        float[] xyzV = new float[]{this.ai00 * (xS -= this.xSOff + this.xOff * this.scale) + this.ai01 * (yS -= this.ySOff + this.yOff * this.scale) + this.ai02 * zS + this.ai03, this.ai10 * xS + this.ai11 * yS + this.ai12 * zS + this.ai13, this.ai20 * xS + this.ai21 * yS + this.ai22 * zS + this.ai23};
        return xyzV;
    }

    final float[] screen2Volume(float[] xyzS) {
        float xS = xyzS[0] - this.xSOff - this.xOff * this.scale;
        float yS = xyzS[1] - this.ySOff - this.yOff * this.scale;
        float zS = xyzS[2];
        float[] xyzV = new float[]{this.ai00 * xS + this.ai01 * yS + this.ai02 * zS + this.ai03, this.ai10 * xS + this.ai11 * yS + this.ai12 * zS + this.ai13, this.ai20 * xS + this.ai21 * yS + this.ai22 * zS + this.ai23};
        return xyzV;
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.initializeTransformation();
    }

    public void setMouseMovement(int xAct, int yAct, int xStart, int yStart, float width) {
        float size = 2.0f * width;
        float x1 = ((float)xStart - width / 2.0f) / size;
        float y1 = ((float)yStart - width / 2.0f) / size;
        float z1 = 1.0f - x1 * x1 - y1 * y1;
        z1 = z1 > 0.0f ? (float)Math.sqrt(z1) : 0.0f;
        float x2 = ((float)xAct - width / 2.0f) / size;
        float y2 = ((float)yAct - width / 2.0f) / size;
        float z2 = 1.0f - x2 * x2 - y2 * y2;
        z2 = z2 > 0.0f ? (float)Math.sqrt(z2) : 0.0f;
        this.xRot = y1 * z2 - z1 * y2;
        this.yRot = z1 * x2 - x1 * z2;
        this.zRot = -x1 * y2 + y1 * x2;
        float len = this.xRot * this.xRot + this.yRot * this.yRot + this.zRot * this.zRot;
        if (len <= 0.0f) {
            return;
        }
        float len_ = (float)(1.0 / Math.sqrt(this.xRot * this.xRot + this.yRot * this.yRot + this.zRot * this.zRot));
        this.xRot *= len_;
        this.yRot *= len_;
        this.zRot *= len_;
        float dot = x1 * x2 + y1 * y2 + z1 * z2;
        if (dot > 1.0f) {
            dot = 1.0f;
        } else if (dot < -1.0f) {
            dot = -1.0f;
        }
        this.rotAngle = (float)Math.acos(dot) * 10.0f;
        this.initializeTransformation();
    }

    public void setMouseMovementOffset(int dx, int dy) {
        this.xOff += (float)dx / this.scale;
        this.yOff += (float)dy / this.scale;
        this.initializeTransformation();
    }

    Transform(Control control, float width, float height, float xOffa, float yOffa, float zOffa) {
        this.control = control;
        this.xSOff = (float)((double)width / 2.0 + 0.5);
        this.ySOff = (float)((double)height / 2.0 + 0.5);
        this.xvOff = xOffa;
        this.yvOff = yOffa;
        this.zvOff = zOffa;
        this.mP = new float[4][4];
        this.mP[3][3] = 1.0f;
        this.mP[2][2] = 1.0f;
        this.mP[1][1] = 1.0f;
        this.mP[0][0] = 1.0f;
    }

    public void setZAspect(float zAspect) {
        this.zAspect = zAspect;
    }
}

