/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.detection;

import de.biomedical_imaging.ij.steger.Line;
import de.biomedical_imaging.ij.steger.LineDetector;
import de.biomedical_imaging.ij.steger.Lines;
import de.biomedical_imaging.ij.steger.OverlapOption;
import ij.ImagePlus;
import ij.process.ImageProcessor;
import java.awt.Color;
import net.imagej.display.ImageDisplayService;
import org.scijava.convert.ConvertService;
import org.scijava.event.EventService;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.filamentdetector.detection.AbstractFilamentDetector;
import sc.fiji.filamentdetector.detection.FilamentDetector;
import sc.fiji.filamentdetector.event.ImageNotFoundEvent;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.FilamentFactory;
import sc.fiji.filamentdetector.model.Filaments;
import sc.fiji.filamentdetector.overlay.ColorService;

@Plugin(type=FilamentDetector.class, priority=100.0)
public class RidgeDetectionFilamentDetector
extends AbstractFilamentDetector {
    private static String NAME = "Ridge Detection";
    @Parameter
    ConvertService convertService;
    @Parameter
    LogService log;
    @Parameter
    private ColorService colorService;
    @Parameter
    private EventService eventService;
    @Parameter
    private ImageDisplayService imds;
    private double sigma = 1.51;
    private double upperThresh = 7.99;
    private double lowerThresh = 3.06;
    private double lineWidth = 3.5;
    private double highContrast = 230.0;
    private double lowContrast = 87.0;
    private double minLength = 0.0;
    private double maxLength = 0.0;
    private boolean isDarkLine = false;
    private boolean doCorrectPosition = true;
    private boolean doEstimateWidth = true;
    private boolean doExtendLine = true;
    private OverlapOption overlapOption = OverlapOption.NONE;
    private LineDetector lineDetector;
    private ImagePlus imp;
    private ImagePlus impData;

    public RidgeDetectionFilamentDetector() {
        this.setName(NAME);
        this.lineDetector = new LineDetector();
    }

    private void initDetection() {
        try {
            if (this.imp == null) {
                this.impData = this.imp = (ImagePlus)this.convertService.convert((Object)this.getImageDisplay(), ImagePlus.class);
            }
            if (this.impData == null) {
                this.impData = (ImagePlus)this.convertService.convert((Object)this.getDataset(), ImagePlus.class);
            }
        }
        catch (NullPointerException e) {
            this.eventService.publish((SciJavaEvent)new ImageNotFoundEvent());
        }
        this.colorService.initialize();
        this.setFilaments(new Filaments());
    }

    @Override
    public void detect() {
        this.detect(0);
    }

    @Override
    public void detect(int channelIndex) {
        this.initDetection();
        int currentFrame = this.imp.getFrame();
        int currentChannel = this.imp.getChannel();
        this.impData.setC(channelIndex + 1);
        for (int frame = 0; frame < this.impData.getNFrames(); ++frame) {
            this.detectFrame(frame);
        }
        this.imp.setT(currentFrame);
        this.imp.setC(currentChannel);
        this.simplifyFilaments();
    }

    @Override
    public void detectCurrentFrame() {
        this.detectCurrentFrame(0);
    }

    @Override
    public void detectCurrentFrame(int channelIndex) {
        this.initDetection();
        int currentFrame = this.imp.getFrame() - 1;
        int currentChannel = this.imp.getChannel();
        this.impData.setC(channelIndex + 1);
        this.detectFrame(currentFrame);
        this.imp.setC(currentChannel);
        this.simplifyFilaments();
    }

    @Override
    public void detectFrame(int frame, int channel) {
        this.detectFrame(frame);
    }

    @Override
    public void detectFrame(int frame) {
        Filaments filaments = this.getFilaments();
        if (filaments == null) {
            filaments = new Filaments();
        }
        this.impData.setT(frame + 1);
        ImageProcessor ip = this.impData.getProcessor();
        Lines lines = this.lineDetector.detectLines(ip, this.getSigma(), this.getUpperThresh(), this.getLowerThresh(), this.getMinLength(), this.getMaxLength(), this.isDarkLine(), this.isDoCorrectPosition(), this.isDoEstimateWidth(), this.isDoExtendLine(), this.getOverlapOption());
        for (Line line : lines) {
            Filament filament = FilamentFactory.fromLine(line, frame);
            Color color = this.colorService.getColor(filaments.size() + 1);
            filament.setColor(color);
            filaments.add(filament);
        }
        this.setFilaments(filaments);
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    public double getUpperThresh() {
        return this.upperThresh;
    }

    public void setUpperThresh(double upperThresh) {
        this.upperThresh = upperThresh;
    }

    public double getLowerThresh() {
        return this.lowerThresh;
    }

    public void setLowerThresh(double lowerThresh) {
        this.lowerThresh = lowerThresh;
    }

    public double getMinLength() {
        return this.minLength;
    }

    public void setMinLength(double minLength) {
        this.minLength = minLength;
    }

    public double getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(double maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isDarkLine() {
        return this.isDarkLine;
    }

    public void setDarkLine(boolean isDarkLine) {
        this.isDarkLine = isDarkLine;
    }

    public boolean isDoCorrectPosition() {
        return this.doCorrectPosition;
    }

    public void setDoCorrectPosition(boolean doCorrectPosition) {
        this.doCorrectPosition = doCorrectPosition;
    }

    public boolean isDoEstimateWidth() {
        return this.doEstimateWidth;
    }

    public void setDoEstimateWidth(boolean doEstimateWidth) {
        this.doEstimateWidth = doEstimateWidth;
    }

    public boolean isDoExtendLine() {
        return this.doExtendLine;
    }

    public void setDoExtendLine(boolean doExtendLine) {
        this.doExtendLine = doExtendLine;
    }

    public OverlapOption getOverlapOption() {
        return this.overlapOption;
    }

    public void setOverlapOption(OverlapOption overlapOption) {
        this.overlapOption = overlapOption;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
        this.computerParameters();
    }

    public double getHighContrast() {
        return this.highContrast;
    }

    public void setHighContrast(double highContrast) {
        this.highContrast = highContrast;
        this.computerParameters();
    }

    public double getLowContrast() {
        return this.lowContrast;
    }

    public void setLowContrast(double lowContrast) {
        this.lowContrast = lowContrast;
        this.computerParameters();
    }

    private void computerParameters() {
        this.sigma = this.lineWidth / (2.0 * Math.sqrt(3.0)) + 0.5;
        double firstTerm = 0.17;
        double secondTerm = -2.0 * this.highContrast * (this.lineWidth / 2.0) / (Math.sqrt(Math.PI * 2) * Math.pow(this.sigma, 3.0));
        secondTerm = Math.abs(secondTerm);
        double thirdTerm = Math.exp(-Math.pow(this.lineWidth / 2.0, 2.0) / (2.0 * Math.pow(this.sigma, 2.0)));
        this.upperThresh = Math.floor(firstTerm * secondTerm) * thirdTerm;
        firstTerm = 0.17;
        secondTerm = -2.0 * this.lowContrast * (this.lineWidth / 2.0) / (Math.sqrt(Math.PI * 2) * Math.pow(this.sigma, 3.0));
        secondTerm = Math.abs(secondTerm);
        thirdTerm = Math.exp(-Math.pow(this.lineWidth / 2.0, 2.0) / (2.0 * Math.pow(this.sigma, 2.0)));
        this.lowerThresh = Math.floor(firstTerm * secondTerm) * thirdTerm;
    }

    @Override
    public String toString() {
        String out = "";
        out = out + "Detector : " + this.getName() + "\n";
        out = out + "Sigma = " + this.sigma + "\n";
        out = out + "Lower Threshold = " + this.lowerThresh + "\n";
        out = out + "Upper Threshold = " + this.upperThresh + "\n";
        out = out + "Line Width = " + this.lineWidth + "\n";
        out = out + "High Contrast = " + this.highContrast + "\n";
        out = out + "Low Contrast = " + this.lowContrast + "\n";
        out = out + "Detect Only Current Frame = " + this.isDetectOnlyCurrentFrame() + "\n";
        out = out + "Simplify Filaments = " + this.isSimplifyFilaments() + "\n";
        out = out + "Simplify Tolerance Distance = " + this.getSimplifyToleranceDistance();
        return out;
    }
}

