/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.tracking.lap;

import fiji.plugin.trackmate.tracking.jaqaman.LAPUtils;
import fiji.plugin.trackmate.tracking.jaqaman.costfunction.CostFunction;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.CostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.DefaultCostMatrixCreator;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.ResizableDoubleArray;
import fiji.plugin.trackmate.tracking.jaqaman.costmatrix.SparseCostMatrix;
import fiji.plugin.trackmate.util.TMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.imglib2.algorithm.MultiThreaded;
import net.imglib2.util.Util;
import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultWeightedEdge;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.tracking.lap.BoundingBoxOverlapCostFunction;
import sc.fiji.filamentdetector.tracking.lap.FilamentGraphSegmentSplitter;

public class JaqamanFilamentSegmentCostMatrixCreator
implements CostMatrixCreator<Filament, Filament>,
MultiThreaded {
    private static final String BASE_ERROR_MESSAGE = "[JaqamanFilamentSegmentCostMatrixCreator] ";
    private final Map<String, Object> settings;
    private String errorMessage;
    private SparseCostMatrix scm;
    private long processingTime;
    private List<Filament> uniqueSources;
    private List<Filament> uniqueTargets;
    private final Graph<Filament, DefaultWeightedEdge> graph;
    private double alternativeCost = -1.0;
    private int numThreads;

    public JaqamanFilamentSegmentCostMatrixCreator(Graph<Filament, DefaultWeightedEdge> graph, Map<String, Object> settings) {
        this.graph = graph;
        this.settings = settings;
        this.setNumThreads();
    }

    public boolean checkInput() {
        StringBuilder str = new StringBuilder();
        if (!JaqamanFilamentSegmentCostMatrixCreator.checkSettingsValidity(this.settings, str)) {
            this.errorMessage = "[JaqamanFilamentSegmentCostMatrixCreator] Incorrect settings map:\n" + str.toString();
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean process() {
        List<Filament> allMiddles;
        long start = System.currentTimeMillis();
        Map gcFeaturePenalties = (Map)this.settings.get("GAP_CLOSING_FEATURE_PENALTIES");
        final CostFunction<Filament, Filament> gcCostFunction = this.getCostFunctionFor(gcFeaturePenalties);
        final int maxFrameInterval = (Integer)this.settings.get("MAX_FRAME_GAP");
        double gcMaxDistance = (Double)this.settings.get("GAP_CLOSING_MAX_DISTANCE");
        final double gcCostThreshold = gcMaxDistance * gcMaxDistance;
        final boolean allowGapClosing = (Boolean)this.settings.get("ALLOW_GAP_CLOSING");
        Map mFeaturePenalties = (Map)this.settings.get("MERGING_FEATURE_PENALTIES");
        final CostFunction<Filament, Filament> mCostFunction = this.getCostFunctionFor(mFeaturePenalties);
        double mMaxDistance = (Double)this.settings.get("MERGING_MAX_DISTANCE");
        final double mCostThreshold = mMaxDistance * mMaxDistance;
        final boolean allowMerging = (Boolean)this.settings.get("ALLOW_TRACK_MERGING");
        Map sFeaturePenalties = (Map)this.settings.get("SPLITTING_FEATURE_PENALTIES");
        final CostFunction<Filament, Filament> sCostFunction = this.getCostFunctionFor(sFeaturePenalties);
        boolean allowSplitting = (Boolean)this.settings.get("ALLOW_TRACK_SPLITTING");
        double sMaxDistance = (Double)this.settings.get("SPLITTING_MAX_DISTANCE");
        final double sCostThreshold = sMaxDistance * sMaxDistance;
        double alternativeCostFactor = (Double)this.settings.get("ALTERNATIVE_LINKING_COST_FACTOR");
        double percentile = (Double)this.settings.get("CUTOFF_PERCENTILE");
        if (!(allowGapClosing || allowSplitting || allowMerging)) {
            this.uniqueSources = Collections.emptyList();
            this.uniqueTargets = Collections.emptyList();
            this.scm = new SparseCostMatrix(new double[0], new int[0], new int[0], 0);
            return true;
        }
        boolean mergingOrSplitting = allowMerging || allowSplitting;
        FilamentGraphSegmentSplitter segmentSplitter = new FilamentGraphSegmentSplitter(this.graph, mergingOrSplitting);
        List<Filament> segmentEnds = segmentSplitter.getSegmentEnds();
        final List<Filament> segmentStarts = segmentSplitter.getSegmentStarts();
        if (mergingOrSplitting) {
            List<List<Filament>> segmentMiddles = segmentSplitter.getSegmentMiddles();
            allMiddles = new ArrayList<Filament>();
            for (List<Filament> segment : segmentMiddles) {
                allMiddles.addAll(segment);
            }
        } else {
            allMiddles = Collections.emptyList();
        }
        final Object lock = new Object();
        final ArrayList sources = new ArrayList();
        final ArrayList targets = new ArrayList();
        final ResizableDoubleArray linkCosts = new ResizableDoubleArray();
        ExecutorService executorGCM = Executors.newFixedThreadPool(this.numThreads);
        for (final Filament filament : segmentEnds) {
            executorGCM.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object;
                    double cost;
                    int tdiff;
                    int targetFrame;
                    int sourceFrame = filament.getFrame();
                    if (allowGapClosing) {
                        for (Filament target : segmentStarts) {
                            targetFrame = target.getFrame();
                            tdiff = targetFrame - sourceFrame;
                            if (tdiff < 1 || tdiff > maxFrameInterval || (cost = gcCostFunction.linkingCost((Object)filament, (Object)target)) > gcCostThreshold) continue;
                            object = lock;
                            synchronized (object) {
                                sources.add(filament);
                                targets.add(target);
                                linkCosts.add(cost);
                            }
                        }
                    }
                    if (allowMerging) {
                        for (Filament target : allMiddles) {
                            targetFrame = target.getFrame();
                            tdiff = targetFrame - sourceFrame;
                            if (tdiff != 1 || (cost = mCostFunction.linkingCost((Object)filament, (Object)target)) > mCostThreshold) continue;
                            object = lock;
                            synchronized (object) {
                                sources.add(filament);
                                targets.add(target);
                                linkCosts.add(cost);
                            }
                        }
                    }
                }
            });
        }
        executorGCM.shutdown();
        try {
            executorGCM.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            this.errorMessage = BASE_ERROR_MESSAGE + e.getMessage();
            return false;
        }
        if (allowSplitting) {
            ExecutorService executorS = Executors.newFixedThreadPool(this.numThreads);
            for (final Filament source : allMiddles) {
                executorS.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        int sourceFrame = source.getFrame();
                        for (Filament target : segmentStarts) {
                            double cost;
                            int targetFrame = target.getFrame();
                            int tdiff = targetFrame - sourceFrame;
                            if (tdiff != 1 || (cost = sCostFunction.linkingCost((Object)source, (Object)target)) > sCostThreshold) continue;
                            Object object = lock;
                            synchronized (object) {
                                sources.add(source);
                                targets.add(target);
                                linkCosts.add(cost);
                            }
                        }
                    }
                });
            }
            executorS.shutdown();
            try {
                executorS.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {
                this.errorMessage = BASE_ERROR_MESSAGE + interruptedException.getMessage();
            }
        }
        linkCosts.trimToSize();
        if (sources.isEmpty() || targets.isEmpty()) {
            this.uniqueSources = Collections.emptyList();
            this.uniqueTargets = Collections.emptyList();
            this.alternativeCost = Double.NaN;
            this.scm = null;
        } else {
            DefaultCostMatrixCreator creator = new DefaultCostMatrixCreator(sources, targets, linkCosts.data, alternativeCostFactor, percentile);
            if (!creator.checkInput() || !creator.process()) {
                this.errorMessage = "Linking track segments: " + creator.getErrorMessage();
                return false;
            }
            this.alternativeCost = percentile == 1.0 ? alternativeCostFactor * Util.max((double[])linkCosts.data) : alternativeCostFactor * Util.percentile((double[])linkCosts.data, (double)percentile);
            this.scm = creator.getResult();
            this.uniqueSources = creator.getSourceList();
            this.uniqueTargets = creator.getTargetList();
        }
        long end = System.currentTimeMillis();
        this.processingTime = end - start;
        return true;
    }

    protected CostFunction<Filament, Filament> getCostFunctionFor(Map<String, Double> featurePenalties) {
        BoundingBoxOverlapCostFunction costFunction = new BoundingBoxOverlapCostFunction();
        return costFunction;
    }

    public SparseCostMatrix getResult() {
        return this.scm;
    }

    public List<Filament> getSourceList() {
        return this.uniqueSources;
    }

    public List<Filament> getTargetList() {
        return this.uniqueTargets;
    }

    public double getAlternativeCostForSource(Filament source) {
        return this.alternativeCost;
    }

    public double getAlternativeCostForTarget(Filament target) {
        return this.alternativeCost;
    }

    public long getProcessingTime() {
        return this.processingTime;
    }

    private static final boolean checkSettingsValidity(Map<String, Object> settings, StringBuilder str) {
        if (null == settings) {
            str.append("Settings map is null.\n");
            return false;
        }
        boolean ok = true;
        ok &= TMUtils.checkParameter(settings, (String)"ALLOW_GAP_CLOSING", Boolean.class, (StringBuilder)str);
        ok &= TMUtils.checkParameter(settings, (String)"GAP_CLOSING_MAX_DISTANCE", Double.class, (StringBuilder)str);
        ok &= TMUtils.checkParameter(settings, (String)"MAX_FRAME_GAP", Integer.class, (StringBuilder)str);
        ok &= LAPUtils.checkFeatureMap(settings, (String)"GAP_CLOSING_FEATURE_PENALTIES", (StringBuilder)str);
        ok &= TMUtils.checkParameter(settings, (String)"ALLOW_TRACK_SPLITTING", Boolean.class, (StringBuilder)str);
        ok &= TMUtils.checkParameter(settings, (String)"SPLITTING_MAX_DISTANCE", Double.class, (StringBuilder)str);
        ok &= LAPUtils.checkFeatureMap(settings, (String)"SPLITTING_FEATURE_PENALTIES", (StringBuilder)str);
        ok &= TMUtils.checkParameter(settings, (String)"ALLOW_TRACK_MERGING", Boolean.class, (StringBuilder)str);
        ok &= TMUtils.checkParameter(settings, (String)"MERGING_MAX_DISTANCE", Double.class, (StringBuilder)str);
        ok &= LAPUtils.checkFeatureMap(settings, (String)"MERGING_FEATURE_PENALTIES", (StringBuilder)str);
        ok &= TMUtils.checkParameter(settings, (String)"ALTERNATIVE_LINKING_COST_FACTOR", Double.class, (StringBuilder)str);
        ok &= TMUtils.checkParameter(settings, (String)"CUTOFF_PERCENTILE", Double.class, (StringBuilder)str);
        ArrayList<String> mandatoryKeys = new ArrayList<String>();
        mandatoryKeys.add("ALLOW_GAP_CLOSING");
        mandatoryKeys.add("GAP_CLOSING_MAX_DISTANCE");
        mandatoryKeys.add("MAX_FRAME_GAP");
        mandatoryKeys.add("ALLOW_TRACK_SPLITTING");
        mandatoryKeys.add("SPLITTING_MAX_DISTANCE");
        mandatoryKeys.add("ALLOW_TRACK_MERGING");
        mandatoryKeys.add("MERGING_MAX_DISTANCE");
        mandatoryKeys.add("ALTERNATIVE_LINKING_COST_FACTOR");
        mandatoryKeys.add("CUTOFF_PERCENTILE");
        ArrayList<String> optionalKeys = new ArrayList<String>();
        optionalKeys.add("GAP_CLOSING_FEATURE_PENALTIES");
        optionalKeys.add("SPLITTING_FEATURE_PENALTIES");
        optionalKeys.add("MERGING_FEATURE_PENALTIES");
        return ok &= TMUtils.checkMapKeys(settings, mandatoryKeys, optionalKeys, (StringBuilder)str);
    }

    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public int getNumThreads() {
        return this.numThreads;
    }
}

