/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.blockmatching;

import ij.IJ;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.TransformMapping;
import mpicbg.ij.util.Filter;
import mpicbg.ij.util.Util;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.CoordinateTransformList;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.Model;
import mpicbg.models.MovingLeastSquaresTransform;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TransformMesh;
import mpicbg.models.TranslationModel2D;

public class BlockMatching {
    private static final float minSigma = 1.6f;

    private BlockMatching() {
    }

    protected static float blockMean(FloatProcessor fp, int tx, int ty, int blockWidth, int blockHeight) {
        int width = fp.getWidth();
        float[] pixels = (float[])fp.getPixels();
        double sum = 0.0;
        for (int y = ty + blockHeight - 1; y >= ty; --y) {
            int ry = y * width;
            for (int x = tx + blockWidth - 1; x >= tx; --x) {
                sum += (double)pixels[ry + x];
            }
        }
        return (float)(sum / (double)blockWidth / (double)blockHeight);
    }

    private static final void mask(FloatProcessor source, FloatProcessor mask) {
        float[] sourcePixels = (float[])source.getPixels();
        float[] maskPixels = (float[])mask.getPixels();
        int n = sourcePixels.length;
        for (int i = 0; i < n; ++i) {
            float m = maskPixels[i];
            if (!(m < 0.95f)) continue;
            sourcePixels[i] = Float.NaN;
        }
    }

    private static final void mapAndMask(ImageProcessor source, ImageProcessor mask, ImageProcessor target, CoordinateTransform transform) {
        double[] t = new double[2];
        int sw = source.getWidth() - 1;
        int sh = source.getHeight() - 1;
        int tw = target.getWidth();
        int th = target.getHeight();
        for (int y = 0; y < th; ++y) {
            for (int x = 0; x < tw; ++x) {
                t[0] = x;
                t[1] = y;
                transform.applyInPlace(t);
                if (!(t[0] >= 0.0) || !(t[0] <= (double)sw) || !(t[1] >= 0.0) || !(t[1] <= (double)sh) || mask.getPixelInterpolated(t[0], t[1]) <= 0) continue;
                target.putPixel(x, y, source.getPixelInterpolated(t[0], t[1]));
            }
        }
    }

    protected static float blockVariance(FloatProcessor fp, int tx, int ty, int blockWidth, int blockHeight, float mean) {
        int width = fp.getWidth();
        float[] pixels = (float[])fp.getPixels();
        double sum = 0.0;
        for (int y = ty + blockHeight - 1; y >= ty; --y) {
            int ry = y * width;
            for (int x = tx + blockWidth - 1; x >= tx; --x) {
                float a = pixels[ry + x] - mean;
                sum += (double)(a * a);
            }
        }
        return (float)(sum / (double)(blockWidth * blockHeight - 1));
    }

    public static void matchByMinimalSquareDifference(FloatProcessor source, FloatProcessor target, InvertibleCoordinateTransform transform, int blockRadiusX, int blockRadiusY, int searchRadiusX, int searchRadiusY, Collection<? extends Point> sourcePoints, Collection<PointMatch> sourceMatches) {
        Util.normalizeContrast(source);
        Util.normalizeContrast(target);
        FloatProcessor mappedTarget = new FloatProcessor(source.getWidth() + 2 * searchRadiusX, source.getHeight() + 2 * searchRadiusY);
        Util.fillWithNaN(mappedTarget);
        TranslationModel2D tTarget = new TranslationModel2D();
        tTarget.set(-searchRadiusX, -searchRadiusY);
        CoordinateTransformList<InvertibleCoordinateTransform> lTarget = new CoordinateTransformList<InvertibleCoordinateTransform>();
        lTarget.add(tTarget);
        lTarget.add(transform);
        TransformMapping targetMapping = new TransformMapping(lTarget);
        targetMapping.mapInverseInterpolated((ImageProcessor)target, (ImageProcessor)mappedTarget);
        int k = 0;
        for (Point point : sourcePoints) {
            double[] s = point.getL();
            int px = (int)Math.round(s[0]);
            int py = (int)Math.round(s[1]);
            if (px - blockRadiusX < 0 || px + blockRadiusX >= source.getWidth() || py - blockRadiusY < 0 || py + blockRadiusY >= source.getHeight()) continue;
            IJ.showProgress((int)k++, (int)sourcePoints.size());
            double tx = 0.0;
            double ty = 0.0;
            float dMin = Float.MAX_VALUE;
            for (int ity = -searchRadiusY; ity <= searchRadiusY; ++ity) {
                for (int itx = -searchRadiusX; itx <= searchRadiusX; ++itx) {
                    float d = 0.0f;
                    float n = 0.0f;
                    for (int iy = -blockRadiusY; iy <= blockRadiusY; ++iy) {
                        int y = py + iy;
                        for (int ix = -blockRadiusX; ix <= blockRadiusX; ++ix) {
                            int x = px + ix;
                            float sf = source.getf(x, y);
                            float tf = mappedTarget.getf(x + itx + searchRadiusX, y + ity + searchRadiusY);
                            if (sf == Float.NaN || tf == Float.NaN) continue;
                            float a = sf - tf;
                            d += a * a;
                            n += 1.0f;
                        }
                    }
                    if (!(n > 0.0f) || !((d /= n) < dMin)) continue;
                    dMin = d;
                    tx = itx;
                    ty = ity;
                }
            }
            double[] t = new double[]{tx + s[0], ty + s[1]};
            System.out.println(k + " : " + tx + ", " + ty);
            transform.applyInPlace(t);
            sourceMatches.add(new PointMatch(point, new Point(t)));
        }
    }

    protected static void matchByMaximalPMCC(final FloatProcessor source, final FloatProcessor target, final int blockRadiusX, final int blockRadiusY, final int searchRadiusX, final int searchRadiusY, final float minR, final float rod, float maxCurvature, final Collection<PointMatch> query, Collection<PointMatch> results) throws InterruptedException, ExecutionException {
        final float maxCurvatureRatio = (maxCurvature + 1.0f) * (maxCurvature + 1.0f) / maxCurvature;
        final int blockWidth = 2 * blockRadiusX + 1;
        final int blockHeight = 2 * blockRadiusY + 1;
        final AtomicInteger k = new AtomicInteger(0);
        ExecutorService exec = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<Future<PointMatch>> tasks = new ArrayList<Future<PointMatch>>();
        for (final PointMatch pointMatch : query) {
            tasks.add(exec.submit(new Callable<PointMatch>(){

                @Override
                public PointMatch call() {
                    IJ.showProgress((int)k.getAndIncrement(), (int)query.size());
                    Point p = pointMatch.getP1();
                    double[] s = p.getL();
                    int px = (int)Math.round(s[0]);
                    int py = (int)Math.round(s[1]);
                    int ptx = px - blockRadiusX;
                    int pty = py - blockRadiusY;
                    if (ptx >= 0 && ptx + blockWidth < source.getWidth() && pty >= 0 && pty + blockHeight < source.getHeight()) {
                        float sourceBlockMean = BlockMatching.blockMean(source, ptx, pty, blockWidth, blockHeight);
                        if (Float.isNaN(sourceBlockMean)) {
                            return null;
                        }
                        float sourceBlockStd = (float)Math.sqrt(BlockMatching.blockVariance(source, ptx, pty, blockWidth, blockHeight, sourceBlockMean));
                        if (sourceBlockStd == 0.0f) {
                            return null;
                        }
                        double tx = 0.0;
                        double ty = 0.0;
                        float rMax = -3.4028235E38f;
                        FloatProcessor rMap = new FloatProcessor(2 * searchRadiusX + 1, 2 * searchRadiusY + 1);
                        for (int ity = -searchRadiusY; ity <= searchRadiusY; ++ity) {
                            int ipty = ity + pty + searchRadiusY;
                            for (int itx = -searchRadiusX; itx <= searchRadiusX; ++itx) {
                                int iptx = itx + ptx + searchRadiusX;
                                float targetBlockMean = BlockMatching.blockMean(target, iptx, ipty, blockWidth, blockHeight);
                                if (Float.isNaN(targetBlockMean)) {
                                    return null;
                                }
                                float targetBlockStd = (float)Math.sqrt(BlockMatching.blockVariance(target, iptx, ipty, blockWidth, blockHeight, targetBlockMean));
                                if (targetBlockStd == 0.0f) {
                                    return null;
                                }
                                float r = 0.0f;
                                for (int iy = 0; iy < blockHeight; ++iy) {
                                    int ys = pty + iy;
                                    int yt = ipty + iy;
                                    for (int ix = 0; ix < blockWidth; ++ix) {
                                        int xs = ptx + ix;
                                        int xt = iptx + ix;
                                        r += (source.getf(xs, ys) - sourceBlockMean) * (target.getf(xt, yt) - targetBlockMean);
                                    }
                                }
                                if ((r /= sourceBlockStd * targetBlockStd * (float)(blockWidth * blockHeight - 1)) > rMax) {
                                    rMax = r;
                                    tx = itx;
                                    ty = ity;
                                }
                                rMap.setf(itx + searchRadiusX, ity + searchRadiusY, r);
                            }
                        }
                        float bestR = -2.0f;
                        float secondBestR = -2.0f;
                        double dx = 0.0;
                        double dy = 0.0;
                        double dxx = 0.0;
                        double dyy = 0.0;
                        double dxy = 0.0;
                        for (int y = 2 * searchRadiusY - 1; y > 0; --y) {
                            for (int x = 2 * searchRadiusX - 1; x > 0; --x) {
                                float c22;
                                float c21;
                                float c20;
                                float c12;
                                float c10;
                                float c02;
                                float c01;
                                float c11 = rMap.getf(x, y);
                                float c00 = rMap.getf(x - 1, y - 1);
                                if (c00 >= c11 || (c01 = rMap.getf(x, y - 1)) >= c11 || (c02 = rMap.getf(x + 1, y - 1)) >= c11 || (c10 = rMap.getf(x - 1, y)) >= c11 || (c12 = rMap.getf(x + 1, y)) >= c11 || (c20 = rMap.getf(x - 1, y + 1)) >= c11 || (c21 = rMap.getf(x, y + 1)) >= c11 || (c22 = rMap.getf(x + 1, y + 1)) >= c11) continue;
                                if (c11 <= bestR) {
                                    if (!(c11 > secondBestR)) continue;
                                    secondBestR = c11;
                                    continue;
                                }
                                secondBestR = bestR;
                                bestR = c11;
                                if (c11 < minR) continue;
                                dx = (c12 - c10) / 2.0f;
                                dy = (c21 - c01) / 2.0f;
                                dxx = c10 - c11 - c11 + c12;
                                dyy = c01 - c11 - c11 + c21;
                                dxy = (c22 - c20 - c02 + c00) / 4.0f;
                            }
                        }
                        if (bestR < minR) {
                            return null;
                        }
                        float r = (1.0f + secondBestR) / (1.0f + bestR);
                        if (r > rod) {
                            return null;
                        }
                        double det = dxx * dyy - dxy * dxy;
                        double trace = dxx + dyy;
                        if (det <= 0.0 || trace * trace / det > (double)maxCurvatureRatio) {
                            return null;
                        }
                        double ixx = dyy / det;
                        double ixy = -dxy / det;
                        double iyy = dxx / det;
                        double ox = -ixx * dx - ixy * dy;
                        double oy = -ixy * dx - iyy * dy;
                        if (ox >= 1.0 || oy >= 1.0 || ox <= -1.0 || oy <= -1.0) {
                            return null;
                        }
                        double[] t = new double[]{tx + s[0] + ox, ty + s[1] + oy};
                        return new PointMatch(p, new Point(t));
                    }
                    return null;
                }
            }));
        }
        for (Future future : tasks) {
            try {
                PointMatch pm = (PointMatch)future.get();
                if (pm == null) continue;
                results.add(pm);
            }
            catch (InterruptedException e) {
                exec.shutdownNow();
                throw e;
            }
        }
        tasks.clear();
        exec.shutdown();
    }

    public static void matchByMaximalPMCC(FloatProcessor source, FloatProcessor target, FloatProcessor sourceMask, FloatProcessor targetMask, double scale, CoordinateTransform transform, int blockRadiusX, int blockRadiusY, int searchRadiusX, int searchRadiusY, float minR, float rod, float maxCurvature, Collection<? extends Point> sourcePoints, Collection<PointMatch> sourceMatches, ErrorStatistic observer) throws InterruptedException, ExecutionException {
        int scaledBlockRadiusX = (int)Math.ceil(scale * (double)blockRadiusX);
        int scaledBlockRadiusY = (int)Math.ceil(scale * (double)blockRadiusY);
        int scaledSearchRadiusX = (int)Math.ceil(scale * (double)searchRadiusX) + 1;
        int scaledSearchRadiusY = (int)Math.ceil(scale * (double)searchRadiusY) + 1;
        source = Filter.createDownsampled(source, scale, 0.5f, 1.6f);
        Util.normalizeContrast(source);
        if (sourceMask != null) {
            BlockMatching.mask(source, Filter.createDownsampled(sourceMask, scale, 0.5f, 0.5f));
        }
        sourceMask = null;
        target = (FloatProcessor)target.duplicate();
        Filter.smoothForScale(target, scale, 0.5f, 1.6f);
        Util.normalizeContrast(target);
        FloatProcessor mappedScaledTarget = new FloatProcessor(source.getWidth() + 2 * scaledSearchRadiusX, source.getHeight() + 2 * scaledSearchRadiusY);
        Util.fillWithNaN(mappedScaledTarget);
        TranslationModel2D tTarget = new TranslationModel2D();
        tTarget.set((double)(-scaledSearchRadiusX) / scale, (double)(-scaledSearchRadiusY) / scale);
        SimilarityModel2D sTarget = new SimilarityModel2D();
        sTarget.set(1.0 / scale, 0.0, 0.0, 0.0);
        CoordinateTransformList<CoordinateTransform> lTarget = new CoordinateTransformList<CoordinateTransform>();
        lTarget.add(sTarget);
        lTarget.add(tTarget);
        lTarget.add(transform);
        if (targetMask == null) {
            TransformMapping targetMapping = new TransformMapping(lTarget);
            targetMapping.mapInverseInterpolated((ImageProcessor)target, (ImageProcessor)mappedScaledTarget);
        } else {
            FloatProcessor smoothedTargetMask = (FloatProcessor)targetMask.duplicate();
            Filter.smoothForScale(smoothedTargetMask, scale, 0.5f, 0.5f);
            BlockMatching.mapAndMask((ImageProcessor)target, (ImageProcessor)smoothedTargetMask, (ImageProcessor)mappedScaledTarget, lTarget);
        }
        target = null;
        HashMap<Point, Point> scaledSourcePoints = new HashMap<Point, Point>();
        ArrayList<PointMatch> scaledSourceMatches = new ArrayList<PointMatch>();
        for (Point point : sourcePoints) {
            double[] dArray = (double[])point.getL().clone();
            dArray[0] = dArray[0] * scale;
            dArray[1] = dArray[1] * scale;
            scaledSourcePoints.put(new Point(dArray), point);
        }
        ArrayList<PointMatch> query = new ArrayList<PointMatch>();
        for (Point point : scaledSourcePoints.keySet()) {
            query.add(new PointMatch(point, point.clone()));
        }
        BlockMatching.matchByMaximalPMCC(source, mappedScaledTarget, scaledBlockRadiusX, scaledBlockRadiusY, scaledSearchRadiusX, scaledSearchRadiusY, minR, rod, maxCurvature, query, scaledSourceMatches);
        for (PointMatch pointMatch : scaledSourceMatches) {
            double[] l1 = (double[])pointMatch.getP1().getL().clone();
            double[] l2 = (double[])pointMatch.getP2().getL().clone();
            l1[0] = l1[0] / scale;
            l1[1] = l1[1] / scale;
            l2[0] = l2[0] / scale;
            l2[1] = l2[1] / scale;
            double tx = l2[0] - l1[0];
            double ty = l2[1] - l1[1];
            observer.add(Math.sqrt(tx * tx + ty * ty));
            transform.applyInPlace(l2);
            sourceMatches.add(new PointMatch((Point)scaledSourcePoints.get(pointMatch.getP1()), new Point(l2)));
        }
    }

    public static void matchByMaximalPMCCFromPreScaledImages(FloatProcessor source_scaled, FloatProcessor target_scaled, double scale, int blockRadiusX, int blockRadiusY, int searchRadiusX, int searchRadiusY, float minR, float rod, float maxCurvature, Collection<? extends Point> sourcePoints, Collection<PointMatch> sourceMatches) throws InterruptedException, ExecutionException {
        int scaledBlockRadiusX = (int)Math.ceil(scale * (double)blockRadiusX);
        int scaledBlockRadiusY = (int)Math.ceil(scale * (double)blockRadiusY);
        int scaledSearchRadiusX = (int)Math.ceil(scale * (double)searchRadiusX) + 1;
        int scaledSearchRadiusY = (int)Math.ceil(scale * (double)searchRadiusY) + 1;
        FloatProcessor mappedScaledTarget = new FloatProcessor(source_scaled.getWidth() + 2 * scaledSearchRadiusX, source_scaled.getHeight() + 2 * scaledSearchRadiusY);
        Util.fillWithNaN(mappedScaledTarget);
        TranslationModel2D tTarget = new TranslationModel2D();
        tTarget.set(-scaledSearchRadiusX, -scaledSearchRadiusY);
        TransformMapping<TranslationModel2D> targetMapping = new TransformMapping<TranslationModel2D>(tTarget);
        targetMapping.mapInverseInterpolated((ImageProcessor)target_scaled, (ImageProcessor)mappedScaledTarget);
        HashMap<Point, Point> scaledSourcePoints = new HashMap<Point, Point>();
        ArrayList<PointMatch> scaledSourceMatches = new ArrayList<PointMatch>();
        for (Point point : sourcePoints) {
            double[] dArray = (double[])point.getL().clone();
            dArray[0] = dArray[0] * scale;
            dArray[1] = dArray[1] * scale;
            scaledSourcePoints.put(new Point(dArray), point);
        }
        ArrayList<PointMatch> query = new ArrayList<PointMatch>();
        for (Point point : scaledSourcePoints.keySet()) {
            query.add(new PointMatch(point, point.clone()));
        }
        BlockMatching.matchByMaximalPMCC(source_scaled, mappedScaledTarget, scaledBlockRadiusX, scaledBlockRadiusY, scaledSearchRadiusX, scaledSearchRadiusY, minR, rod, maxCurvature, query, scaledSourceMatches);
        for (PointMatch pointMatch : scaledSourceMatches) {
            double[] l1 = (double[])pointMatch.getP1().getL().clone();
            double[] l2 = (double[])pointMatch.getP2().getL().clone();
            l1[0] = l1[0] / scale;
            l1[1] = l1[1] / scale;
            l2[0] = l2[0] / scale;
            l2[1] = l2[1] / scale;
            sourceMatches.add(new PointMatch((Point)scaledSourcePoints.get(pointMatch.getP1()), new Point(l2)));
        }
    }

    public static void matchByMaximalPMCC(FloatProcessor source, FloatProcessor target, FloatProcessor sourceMask, FloatProcessor targetMask, float scale, CoordinateTransform transform, int blockRadiusX, int blockRadiusY, int searchRadiusX, int searchRadiusY, Collection<? extends Point> sourcePoints, Collection<PointMatch> sourceMatches, ErrorStatistic observer) throws InterruptedException, ExecutionException {
        BlockMatching.matchByMaximalPMCC(source, target, sourceMask, targetMask, scale, transform, blockRadiusX, blockRadiusY, searchRadiusX, searchRadiusY, 0.7f, 0.9f, 10.0f, sourcePoints, sourceMatches, observer);
    }

    public static void findMatches(FloatProcessor source, FloatProcessor target, FloatProcessor sourceMask, FloatProcessor targetMask, Model<?> initialModel, Class<? extends AbstractAffineModel2D<?>> localModelClass, float maxEpsilon, float maxScale, float minR, float rodR, float maxCurvatureR, int meshResolution, float alpha, Collection<PointMatch> sourceMatches) throws InterruptedException, ExecutionException {
        CoordinateTransform ict = initialModel;
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        ErrorStatistic observer = new ErrorStatistic(1);
        for (int n = Math.max(4, Math.min(meshResolution, (int)Math.ceil((float)source.getWidth() / maxEpsilon / 4.0f))); n <= meshResolution; n *= 2) {
            n = Math.min(meshResolution, n);
            MovingLeastSquaresTransform mlst = new MovingLeastSquaresTransform();
            try {
                mlst.setModel(localModelClass);
            }
            catch (Exception e) {
                IJ.error((String)"Invalid local model selected.");
                return;
            }
            int searchRadius = observer.n() < mlst.getModel().getMinNumMatches() ? (int)Math.ceil(maxEpsilon) : (int)Math.ceil(observer.max);
            double scale = Math.min((double)maxScale, 16.0 / (double)searchRadius);
            int blockRadius = (int)Math.ceil(32.0 / scale);
            sourcePoints.clear();
            sourceMatches.clear();
            TransformMesh mesh = new TransformMesh(n, source.getWidth(), source.getHeight());
            PointMatch.sourcePoints(mesh.getVA().keySet(), sourcePoints);
            observer.clear();
            BlockMatching.matchByMaximalPMCC(source, target, sourceMask, targetMask, scale, ict, blockRadius, blockRadius, searchRadius, searchRadius, minR, rodR, maxCurvatureR, sourcePoints, sourceMatches, observer);
            IJ.log((String)("Blockmatching at n = " + n));
            IJ.log((String)(" average offset : " + observer.mean));
            IJ.log((String)(" minimal offset : " + observer.min));
            IJ.log((String)(" maximal offset : " + observer.max));
            if (sourceMatches.size() < mlst.getModel().getMinNumMatches()) continue;
            mlst.setAlpha(alpha);
            try {
                mlst.setMatches(sourceMatches);
                ict = mlst;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static Shape illustrateMatches(Collection<PointMatch> matches) {
        GeneralPath path = new GeneralPath();
        for (PointMatch m : matches) {
            double[] w1 = m.getP1().getW();
            double[] w2 = m.getP2().getW();
            path.moveTo(w1[0] - 1.0, w1[1] - 1.0);
            path.lineTo(w1[0] - 1.0, w1[1] + 1.0);
            path.lineTo(w1[0] + 1.0, w1[1] + 1.0);
            path.lineTo(w1[0] + 1.0, w1[1] - 1.0);
            path.closePath();
            path.moveTo(w1[0], w1[1]);
            path.lineTo(w2[0], w2[1]);
        }
        return path;
    }
}

