/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.models.TileUtil;
import mpicbg.util.RealSum;

public class TileConfiguration
implements Serializable {
    private static final long serialVersionUID = -5684886132202549487L;
    protected static final DecimalFormat decimalFormat = new DecimalFormat();
    protected static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    protected final HashSet<Tile<?>> tiles = new HashSet();
    protected final HashSet<Tile<?>> fixedTiles = new HashSet();
    protected double minError = Double.MAX_VALUE;
    protected double maxError = 0.0;
    protected double error = Double.MAX_VALUE;

    public final HashSet<Tile<?>> getTiles() {
        return this.tiles;
    }

    public final HashSet<Tile<?>> getFixedTiles() {
        return this.fixedTiles;
    }

    public final double getMinError() {
        return this.minError;
    }

    public final double getMaxError() {
        return this.maxError;
    }

    public final double getError() {
        return this.error;
    }

    public TileConfiguration() {
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
    }

    protected void println(String s) {
        System.out.println(s);
    }

    public void clear() {
        this.tiles.clear();
        this.fixedTiles.clear();
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        this.error = Double.MAX_VALUE;
    }

    public void addTile(Tile<?> t) {
        this.tiles.add(t);
    }

    public void addTiles(Collection<? extends Tile<?>> t) {
        this.tiles.addAll(t);
    }

    public void addTiles(TileConfiguration t) {
        this.tiles.addAll(t.tiles);
    }

    public void fixTile(Tile<?> t) {
        this.fixedTiles.add(t);
    }

    protected void apply() {
        for (Tile<?> t : this.tiles) {
            t.apply();
        }
    }

    protected void apply(ThreadPoolExecutor executor) {
        ArrayList allTiles = new ArrayList(this.tiles);
        int nTiles = allTiles.size();
        int nThreads = executor.getMaximumPoolSize();
        int tilesPerThread = nTiles / nThreads + (nTiles % nThreads == 0 ? 0 : 1);
        ArrayList<Future<Void>> applyTasks = new ArrayList<Future<Void>>(nThreads);
        for (int j = 0; j < nThreads; ++j) {
            int n = j * tilesPerThread;
            int end = Math.min((j + 1) * tilesPerThread, nTiles);
            applyTasks.add(executor.submit(() -> TileConfiguration.applyToRange(allTiles, start, end)));
        }
        for (Future future : applyTasks) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static Void applyToRange(List<Tile<?>> tiles, int start, int end) {
        for (int i = start; i < end; ++i) {
            Tile<?> t = tiles.get(i);
            t.apply();
        }
        return null;
    }

    protected void updateErrors() {
        double cd = 0.0;
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        for (Tile<?> t : this.tiles) {
            t.updateCost();
            double d = t.getDistance();
            if (d < this.minError) {
                this.minError = d;
            }
            if (d > this.maxError) {
                this.maxError = d;
            }
            cd += d;
        }
        this.error = cd /= (double)this.tiles.size();
    }

    protected void updateErrors(ThreadPoolExecutor executor) {
        ArrayList allTiles = new ArrayList(this.tiles);
        int nTiles = allTiles.size();
        int nThreads = executor.getMaximumPoolSize();
        int tilesPerThread = nTiles / nThreads + (nTiles % nThreads == 0 ? 0 : 1);
        ArrayList<Future<Double[]>> applyTasks = new ArrayList<Future<Double[]>>(nThreads);
        for (int j = 0; j < nThreads; ++j) {
            int start = j * tilesPerThread;
            int end = Math.min((j + 1) * tilesPerThread, nTiles);
            applyTasks.add(executor.submit(() -> TileConfiguration.computeErrorsOfRange(allTiles, start, end)));
        }
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        double sum = 0.0;
        for (Future future : applyTasks) {
            try {
                Double[] minMaxSum = (Double[])future.get();
                if (minMaxSum[0] < this.minError) {
                    this.minError = minMaxSum[0];
                }
                if (minMaxSum[1] > this.maxError) {
                    this.maxError = minMaxSum[1];
                }
                sum += minMaxSum[2].doubleValue();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        this.error = sum / (double)allTiles.size();
    }

    private static Double[] computeErrorsOfRange(List<Tile<?>> tiles, int start, int end) {
        double sum = 0.0;
        double minError = Double.MAX_VALUE;
        double maxError = 0.0;
        for (int i = start; i < end; ++i) {
            Tile<?> t = tiles.get(i);
            t.updateCost();
            double d = t.getDistance();
            if (d < minError) {
                minError = d;
            }
            if (d > maxError) {
                maxError = d;
            }
            sum += d;
        }
        return new Double[]{minError, maxError, sum};
    }

    protected void update() {
        double cd = 0.0;
        this.minError = Double.MAX_VALUE;
        this.maxError = 0.0;
        for (Tile<?> t : this.tiles) {
            t.update();
            double d = t.getDistance();
            if (d < this.minError) {
                this.minError = d;
            }
            if (d > this.maxError) {
                this.maxError = d;
            }
            cd += d;
        }
        this.error = cd /= (double)this.tiles.size();
    }

    public void optimizeSilently(ErrorStatistic observer, double maxAllowedError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.optimizeSilently(observer, maxAllowedError, maxIterations, maxPlateauwidth, 1.0);
    }

    public void optimizeSilently(ErrorStatistic observer, double maxAllowedError, int maxIterations, int maxPlateauwidth, double damp) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        int i;
        this.apply();
        for (boolean proceed = (i = 0) < maxIterations ? true : false; proceed; proceed &= ++i < maxIterations) {
            for (Tile<?> tile : this.tiles) {
                if (this.fixedTiles.contains(tile)) continue;
                tile.fitModel();
                tile.apply(damp);
            }
            this.updateErrors();
            observer.add(this.error);
            if (i <= maxPlateauwidth) continue;
            proceed = this.error > maxAllowedError;
            for (int d = maxPlateauwidth; !proceed && d >= 1; d /= 2) {
                try {
                    proceed |= Math.abs(observer.getWideSlope(d)) > 1.0E-4;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void optimizeSilentlyConcurrent(ErrorStatistic observer, double maxAllowedError, int maxIterations, int maxPlateauwidth, double damp) throws InterruptedException, ExecutionException {
        TileUtil.optimizeConcurrently(observer, maxAllowedError, maxIterations, maxPlateauwidth, damp, this, this.tiles, this.fixedTiles, Runtime.getRuntime().availableProcessors());
    }

    public void optimize(double maxAllowedError, int maxIterations, int maxPlateauwidth, double damp) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
        this.optimize(observer, maxAllowedError, maxIterations, maxPlateauwidth, damp);
    }

    public void optimize(double maxAllowedError, int maxIterations, int maxPlateauwidth) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.optimize(maxAllowedError, maxIterations, maxPlateauwidth, 1.0);
    }

    public void optimize(ErrorStatistic observer, double maxAllowedError, int maxIterations, int maxPlateauwidth, double damp) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.println("Optimizing...");
        try {
            this.optimizeSilentlyConcurrent(observer, maxAllowedError, maxIterations, maxPlateauwidth, damp);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.println(new StringBuffer("Successfully optimized configuration of ").append(this.tiles.size()).append(" tiles after ").append(observer.n()).append(" iterations:").toString());
        this.println(new StringBuffer("  average displacement: ").append(decimalFormat.format(this.error)).append("px").toString());
        this.println(new StringBuffer("  minimal displacement: ").append(decimalFormat.format(this.minError)).append("px").toString());
        this.println(new StringBuffer("  maximal displacement: ").append(decimalFormat.format(this.maxError)).append("px").toString());
    }

    public void optimizeAndFilter(double maxAllowedError, int maxIterations, int maxPlateauwidth, double damp, double maxMeanFactor) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        boolean proceed = true;
        block0: while (proceed) {
            ErrorStatistic observer = new ErrorStatistic(maxPlateauwidth + 1);
            this.optimize(observer, maxAllowedError, maxIterations, maxPlateauwidth, damp);
            RealSum sum = new RealSum();
            RealSum weights = new RealSum();
            double dMax = 0.0;
            for (Tile<?> t : this.tiles) {
                t.update();
            }
            for (Tile<?> t : this.tiles) {
                for (PointMatch p : t.getMatches()) {
                    double d = p.getDistance();
                    double w = p.getWeight();
                    sum.add(d * w);
                    weights.add(w);
                    if (!(d > dMax)) continue;
                    dMax = d;
                }
            }
            this.println("Filter outliers...");
            if (dMax > maxMeanFactor * sum.getSum() / weights.getSum()) {
                for (Tile<?> t : this.tiles) {
                    for (PointMatch p : t.getMatches()) {
                        if (!(p.getDistance() >= dMax)) continue;
                        Tile<?> o = t.findConnectedTile(p);
                        t.removeConnectedTile(o);
                        o.removeConnectedTile(t);
                        this.println("Removing bad tile connection from configuration, error = " + dMax);
                        continue block0;
                    }
                }
                continue;
            }
            proceed = false;
        }
    }

    public void optimizeAndFilter(double maxAllowedError, int maxIterations, int maxPlateauwidth, double maxMeanFactor) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        this.optimizeAndFilter(maxAllowedError, maxIterations, maxPlateauwidth, 1.0, maxMeanFactor);
    }

    public List<Tile<?>> preAlign() throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        ArrayList unAlignedTiles = new ArrayList();
        ArrayList alignedTiles = new ArrayList();
        if (this.getFixedTiles().size() == 0) {
            Iterator<Tile<?>> it = this.getTiles().iterator();
            alignedTiles.add(it.next());
            while (it.hasNext()) {
                unAlignedTiles.add(it.next());
            }
        } else {
            for (Tile<?> tile : this.getTiles()) {
                if (this.getFixedTiles().contains(tile)) {
                    alignedTiles.add(tile);
                    continue;
                }
                unAlignedTiles.add(tile);
            }
        }
        ListIterator<Tile<?>> referenceIterator = alignedTiles.listIterator();
        while (referenceIterator.hasNext() && unAlignedTiles.size() != 0) {
            Tile referenceTile = (Tile)referenceIterator.next();
            referenceTile.apply();
            ListIterator<Tile<?>> targetIterator = unAlignedTiles.listIterator();
            while (targetIterator.hasNext()) {
                ArrayList<PointMatch> pm;
                Tile<?> targetTile = targetIterator.next();
                if (!referenceTile.getConnectedTiles().contains(targetTile) || (pm = this.getConnectingPointMatches(targetTile, referenceTile)).size() < targetTile.getModel().getMinNumMatches()) continue;
                targetTile.getModel().fit(pm);
                targetIterator.remove();
                int countFwd = 0;
                while (referenceIterator.hasNext()) {
                    referenceIterator.next();
                    ++countFwd;
                }
                referenceIterator.add(targetTile);
                for (int j = 0; j < countFwd + 1; ++j) {
                    referenceIterator.previous();
                }
            }
        }
        return unAlignedTiles;
    }

    public ArrayList<PointMatch> getConnectingPointMatches(Tile<?> targetTile, Tile<?> referenceTile) {
        Set<PointMatch> referenceMatches = referenceTile.getMatches();
        ArrayList<Point> referencePoints = new ArrayList<Point>(referenceMatches.size());
        for (PointMatch pm : referenceMatches) {
            referencePoints.add(pm.getP1());
        }
        ArrayList<PointMatch> connectedPointMatches = new ArrayList<PointMatch>();
        for (PointMatch pm : targetTile.getMatches()) {
            if (!referencePoints.contains(pm.getP2())) continue;
            connectedPointMatches.add(pm);
        }
        return connectedPointMatches;
    }
}

