/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import bdv.export.ProgressWriter;
import bdv.export.ProgressWriterNull;
import bdv.export.SubTaskProgressWriter;
import bdv.img.n5.DataTypeProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.algorithm.blocks.downsample.Downsample;
import net.imglib2.blocks.BlockInterval;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Intervals;
import net.imglib2.view.fluent.RandomAccessibleIntervalView;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;

public class ExportScalePyramid {
    public static <T extends RealType<T> & NativeType<T>, D> void writeScalePyramid(RandomAccessibleInterval<T> img, T type, ExportMipmapInfo mipmapInfo, DatasetIO<D, T> io, ExecutorService executorService, int numThreads, LoopbackHeuristic loopbackHeuristic, AfterEachPlane afterEachPlane, ProgressWriter progressWriter) throws IOException {
        DataType dataType = DataTypeProperties.n5DataType(type);
        if (progressWriter == null) {
            progressWriter = new ProgressWriterNull();
        }
        int numTasks = mipmapInfo.getNumLevels();
        int numCompletedTasks = 0;
        progressWriter.setProgress(0.0);
        int n = 3;
        int[][] resolutions = mipmapInfo.getExportResolutions();
        int[][] subdivisions = mipmapInfo.getSubdivisions();
        int numLevels = mipmapInfo.getNumLevels();
        for (int level = 0; level < numLevels; ++level) {
            int[] factor;
            RandomAccessibleInterval<T> sourceImg;
            progressWriter.out().println("writing level " + level);
            boolean useLoopBack = false;
            int[] factorsToPreviousLevel = null;
            RandomAccessibleInterval<T> loopbackImg = null;
            if (loopbackHeuristic != null) {
                int previousLevel = -1;
                block3: for (int l = level - 1; l >= 0; --l) {
                    int[] f = new int[3];
                    for (int d = 0; d < 3; ++d) {
                        f[d] = resolutions[level][d] / resolutions[l][d];
                        if (f[d] * resolutions[l][d] != resolutions[level][d]) continue block3;
                    }
                    factorsToPreviousLevel = f;
                    previousLevel = l;
                    break;
                }
                if (previousLevel >= 0) {
                    useLoopBack = loopbackHeuristic.decide(img, resolutions[level], previousLevel, factorsToPreviousLevel, subdivisions[level]);
                }
                if (useLoopBack) {
                    loopbackImg = io.getImage(previousLevel);
                }
                if (loopbackImg == null) {
                    useLoopBack = false;
                }
            }
            if (useLoopBack) {
                sourceImg = loopbackImg;
                factor = factorsToPreviousLevel;
            } else {
                sourceImg = img;
                factor = resolutions[level];
            }
            long[] dimensions = Downsample.getDownsampledDimensions((long[])sourceImg.dimensionsAsLongArray(), (int[])factor);
            boolean fullResolution = Intervals.numElements(factor) == 1L;
            int[] cellDimensions = subdivisions[level];
            Object dataset = io.createDataset(level, dimensions, cellDimensions);
            BlockSupplier imgBlocks = BlockSupplier.of(sourceImg.view().extend(RandomAccessibleIntervalView.Extension.border()));
            BlockSupplier blocks = (fullResolution ? imgBlocks : imgBlocks.andThen(Downsample.downsample((int[])factor))).threadSafe();
            SubTaskProgressWriter subProgressWriter = new SubTaskProgressWriter(progressWriter, (double)numCompletedTasks / (double)numTasks, (double)(numCompletedTasks + 1) / (double)numTasks);
            CellGrid grid = new CellGrid(dimensions, cellDimensions);
            long[] numCells = grid.getGridDimensions();
            long numBlocksPerPlane = ExportScalePyramid.numElements(numCells, 0, 2);
            long numPlanes = ExportScalePyramid.numElements(numCells, 2, 3);
            int plane = 0;
            while ((long)plane < numPlanes) {
                long planeBaseIndex = numBlocksPerPlane * (long)plane;
                AtomicInteger nextCellInPlane = new AtomicInteger();
                ArrayList<Callable<Void>> tasks = new ArrayList<Callable<Void>>();
                for (int threadNum = 0; threadNum < numThreads; ++threadNum) {
                    tasks.add(() -> {
                        long[] currentCellMin = new long[3];
                        int i = nextCellInPlane.getAndIncrement();
                        while ((long)i < numBlocksPerPlane) {
                            long index = planeBaseIndex + (long)i;
                            int[] blockSize = grid.getCellDimensions(index, currentCellMin).dimensions();
                            long[] gridPosition = new long[3];
                            grid.getCellGridPositionFlat(index, gridPosition);
                            DataBlock block = dataType.createDataBlock(blockSize, gridPosition);
                            blocks.copy((Interval)BlockInterval.wrap(currentCellMin, blockSize), block.getData());
                            io.writeBlock(dataset, block);
                            i = nextCellInPlane.getAndIncrement();
                        }
                        return null;
                    });
                }
                try {
                    List futures = executorService.invokeAll(tasks);
                    for (Future future : futures) {
                        future.get();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                    throw new IOException(e);
                }
                if (afterEachPlane != null) {
                    afterEachPlane.afterEachPlane(useLoopBack);
                }
                subProgressWriter.setProgress((double)plane / (double)numPlanes);
                ++plane;
            }
            io.flush();
            progressWriter.setProgress((double)(++numCompletedTasks) / (double)numTasks);
        }
    }

    private static long numElements(long[] size, int mind, int maxd) {
        long numElements = 1L;
        for (int d = mind; d < maxd; ++d) {
            numElements *= size[d];
        }
        return numElements;
    }

    public static interface DatasetIO<D, T extends NativeType<T>> {
        public D createDataset(int var1, long[] var2, int[] var3) throws IOException;

        public void writeBlock(D var1, DataBlock<?> var2) throws IOException;

        public void flush() throws IOException;

        default public RandomAccessibleInterval<T> getImage(int level) throws IOException {
            return null;
        }
    }

    public static interface AfterEachPlane {
        public void afterEachPlane(boolean var1);
    }

    public static class DefaultLoopbackHeuristic
    implements LoopbackHeuristic {
        @Override
        public boolean decide(RandomAccessibleInterval<?> originalImg, int[] factorsToOriginalImg, int previousLevel, int[] factorsToPreviousLevel, int[] chunkSize) {
            if (previousLevel < 0) {
                return false;
            }
            return Intervals.numElements(factorsToOriginalImg) / Intervals.numElements(factorsToPreviousLevel) >= 8L;
        }
    }

    public static interface LoopbackHeuristic {
        public boolean decide(RandomAccessibleInterval<?> var1, int[] var2, int var3, int[] var4, int[] var5);
    }
}

