/*
 * Decompiled with CFR 0.152.
 */
package bdv.export;

import bdv.export.ExportMipmapInfo;
import bdv.img.hdf5.Util;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5FileLevelReadWriteHandler;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import hdf.hdf5lib.structs.H5O_info_t;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.RawCompression;

class HDF5Access {
    private final IHDF5Writer hdf5Writer;
    private final long fileId;
    private static final int MAX_OPEN_DATASETS = 48;
    private final OpenDataSetCache openDataSetCache;

    public HDF5Access(IHDF5Writer hdf5Writer) {
        this.hdf5Writer = hdf5Writer;
        long fileAccessPropertyListId = HDF5Constants.H5P_DEFAULT;
        IHDF5FileLevelReadWriteHandler fileHandler = hdf5Writer.file();
        boolean performNumericConversions = fileHandler.isPerformNumericConversions();
        File file = fileHandler.getFile();
        H5.H5open();
        this.fileId = H5.H5Fopen((String)file.getAbsolutePath(), (int)HDF5Constants.H5F_ACC_RDWR, (long)fileAccessPropertyListId);
        this.openDataSetCache = new OpenDataSetCache();
    }

    public void writeMipmapDescription(int setupId, ExportMipmapInfo mipmapInfo) {
        this.hdf5Writer.writeDoubleMatrix(Util.getResolutionsPath(setupId), mipmapInfo.getResolutions());
        this.hdf5Writer.writeIntMatrix(Util.getSubdivisionsPath(setupId), mipmapInfo.getSubdivisions());
    }

    public void writeDataType(int setupId, DataType dataType) {
        this.hdf5Writer.string().setAttr(Util.getSetupPath(setupId), "dataType", dataType.toString());
    }

    public void createDataset(String pathName, long[] dimensions, int[] blockSize, DataType dataType, Compression compression) {
        HDF5IntStorageFeatures uintCompression;
        HDF5IntStorageFeatures intCompression;
        HDF5FloatStorageFeatures floatCompression;
        if (compression instanceof RawCompression) {
            floatCompression = HDF5FloatStorageFeatures.FLOAT_NO_COMPRESSION;
            intCompression = HDF5IntStorageFeatures.INT_NO_COMPRESSION;
            uintCompression = HDF5IntStorageFeatures.INT_NO_COMPRESSION_UNSIGNED;
        } else {
            floatCompression = HDF5FloatStorageFeatures.FLOAT_SHUFFLE_DEFLATE;
            intCompression = HDF5IntStorageFeatures.INT_AUTO_SCALING_DEFLATE;
            uintCompression = HDF5IntStorageFeatures.INT_AUTO_SCALING_DEFLATE_UNSIGNED;
        }
        switch (dataType) {
            case UINT8: {
                this.hdf5Writer.uint8().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), uintCompression);
                break;
            }
            case UINT16: {
                this.hdf5Writer.uint16().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), uintCompression);
                break;
            }
            case UINT32: {
                this.hdf5Writer.uint32().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), uintCompression);
                break;
            }
            case UINT64: {
                this.hdf5Writer.uint64().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), uintCompression);
                break;
            }
            case INT8: {
                this.hdf5Writer.int8().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), intCompression);
                break;
            }
            case INT16: {
                this.hdf5Writer.int16().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), intCompression);
                break;
            }
            case INT32: {
                this.hdf5Writer.int32().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), intCompression);
                break;
            }
            case INT64: {
                this.hdf5Writer.int64().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), intCompression);
                break;
            }
            case FLOAT32: {
                this.hdf5Writer.float32().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), floatCompression);
                break;
            }
            case FLOAT64: {
                this.hdf5Writer.float64().createMDArray(pathName, Util.reorder(dimensions), Util.reorder(blockSize), floatCompression);
                break;
            }
            case OBJECT: {
                throw new IllegalArgumentException();
            }
        }
    }

    public <T> void writeBlock(String pathName, DatasetAttributes datasetAttributes, DataBlock<T> data) {
        int n = data.getSize().length;
        long[] reorderedDimensions = Util.reorder(data.getSize(), new long[n]);
        long[] reorderedOffset = HDF5Access.reorderMultiply(data.getGridPosition(), datasetAttributes.getBlockSize(), new long[n]);
        try (OpenDataSet dataset = this.openDataSetCache.getDataSet(pathName);){
            long memorySpaceId = H5.H5Screate_simple((int)reorderedDimensions.length, (long[])reorderedDimensions, null);
            long fileSpaceId = H5.H5Dget_space((long)dataset.dataSetId);
            H5.H5Sselect_hyperslab((long)fileSpaceId, (int)HDF5Constants.H5S_SELECT_SET, (long[])reorderedOffset, null, (long[])reorderedDimensions, null);
            long memTypeId = Util.memTypeId(datasetAttributes.getDataType());
            H5.H5Dwrite((long)dataset.dataSetId, (long)memTypeId, (long)memorySpaceId, (long)fileSpaceId, (long)HDF5Constants.H5P_DEFAULT, (Object)data.getData());
            H5.H5Sclose((long)fileSpaceId);
            H5.H5Sclose((long)memorySpaceId);
        }
    }

    private static long[] reorderMultiply(long[] in1, int[] in2, long[] out) {
        assert (in1.length == in2.length && in2.length == out.length);
        int n = in1.length;
        Arrays.setAll(out, d -> in1[n - 1 - d] * (long)in2[n - 1 - d]);
        return out;
    }

    public void closeAllDataSets() {
        this.openDataSetCache.clear();
    }

    public void close() {
        this.closeAllDataSets();
        int status = H5.H5Fclose((long)this.fileId);
        if (status < 0) {
            System.err.println("Error closing file");
        }
        this.hdf5Writer.close();
    }

    public IHDF5Writer getIHDF5Writer() {
        return this.hdf5Writer;
    }

    private class OpenDataSetCache {
        private final Map<String, OpenDataSet> cache;

        public OpenDataSetCache() {
            this.cache = new LinkedHashMap<String, OpenDataSet>(48, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, OpenDataSet> eldest) {
                    if (this.size() > 48) {
                        OpenDataSet dataSet = eldest.getValue();
                        if (dataSet != null) {
                            dataSet.close();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }

        public synchronized OpenDataSet getDataSet(String pathName) {
            OpenDataSet dataSet = this.cache.get(pathName);
            if (dataSet == null && this.datasetExists(pathName)) {
                dataSet = new OpenDataSet(pathName);
                this.cache.put(pathName, dataSet);
            }
            if (dataSet != null) {
                dataSet.retain();
            }
            return dataSet;
        }

        public synchronized void clear() {
            this.cache.values().forEach(OpenDataSet::close);
            this.cache.clear();
        }

        private boolean datasetExists(String pathName) {
            if ("/".equals(pathName)) {
                return false;
            }
            try {
                H5O_info_t info = H5.H5Oget_info_by_name((long)HDF5Access.this.fileId, (String)pathName, (int)HDF5Constants.H5O_INFO_BASIC, (long)HDF5Constants.H5P_DEFAULT);
                return info.type == HDF5Constants.H5O_TYPE_DATASET;
            }
            catch (HDF5LibraryException e) {
                return false;
            }
        }
    }

    private class OpenDataSet
    implements AutoCloseable {
        final AtomicInteger refcount = new AtomicInteger(1);
        final long dataSetId;

        public OpenDataSet(String pathName) {
            this.dataSetId = H5.H5Dopen((long)HDF5Access.this.fileId, (String)pathName, (long)HDF5Constants.H5P_DEFAULT);
        }

        public void retain() {
            if (this.refcount.getAndIncrement() <= 0) {
                throw new IllegalStateException();
            }
        }

        @Override
        public void close() {
            if (this.refcount.decrementAndGet() == 0) {
                H5.H5Dclose((long)this.dataSetId);
            }
        }
    }
}

