/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.commands.debug;

import java.util.List;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.display.event.DisplayActivatedEvent;
import org.scijava.display.event.DisplayUpdatedEvent;
import org.scijava.event.EventService;
import org.scijava.event.EventSubscriber;
import org.scijava.event.SciJavaEvent;
import org.scijava.object.event.ObjectCreatedEvent;
import org.scijava.object.event.ObjectDeletedEvent;
import org.scijava.object.event.ObjectsListEvent;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>Debug>Subscribers", headless=true, attrs={@Attr(name="no-legacy")})
public class ShowSubscribers
implements Command {
    @Parameter
    private EventService eventService;
    @Parameter(label="Subscriber Log", type=ItemIO.OUTPUT)
    private String subscriberLog;

    public String getSubscriberLog() {
        return this.subscriberLog;
    }

    public void run() {
        StringBuilder sb = new StringBuilder();
        this.listSubs(sb, ObjectsListEvent.class);
        this.listSubs(sb, ObjectCreatedEvent.class);
        this.listSubs(sb, ObjectDeletedEvent.class);
        this.listSubs(sb, DisplayActivatedEvent.class);
        this.listSubs(sb, DisplayUpdatedEvent.class);
        this.subscriberLog = sb.toString();
    }

    private <E extends SciJavaEvent> void listSubs(StringBuilder sb, Class<E> c) {
        List subscribers = this.eventService.getSubscribers(c);
        sb.append(c.getSimpleName() + ":\n");
        for (EventSubscriber subscriber : subscribers) {
            sb.append("    " + subscriber.toString() + "\n");
        }
    }
}

