/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import edu.mines.jtk.util.Stopwatch;
import java.util.ArrayList;

public class ArrayListBench {
    private static final int INITIAL_CAPACITY = 8;

    public static void main(String[] args) {
        double maxtime = 2.0;
        int n = 10000;
        for (int niter = 0; niter < 5; ++niter) {
            double rate = ArrayListBench.benchArrayList(maxtime, n);
            System.out.println("ArrayList<Float> rate=" + rate);
            rate = ArrayListBench.benchFloatList(maxtime, n);
            System.out.println("FloatList        rate=" + rate);
        }
    }

    static double benchList(double maxtime, int n, ListMaker lm) {
        Stopwatch sw = new Stopwatch();
        sw.start();
        int niter = 0;
        while (sw.time() < maxtime) {
            lm.makeList(n);
            ++niter;
        }
        sw.stop();
        return (double)n * (double)niter / sw.time() * 1.0E-6;
    }

    static double benchArrayList(double maxtime, int n) {
        return ArrayListBench.benchList(maxtime, n, new ListMaker(){

            @Override
            public void makeList(int n) {
                ArrayList<Float> list = new ArrayList<Float>(8);
                float f = 0.0f;
                for (int i = 0; i < n; ++i) {
                    list.add(Float.valueOf(f));
                    f += 1.0f;
                }
            }
        });
    }

    static double benchFloatList(double maxtime, int n) {
        return ArrayListBench.benchList(maxtime, n, new ListMaker(){

            @Override
            public void makeList(int n) {
                FloatList list = new FloatList();
                float f = 0.0f;
                for (int i = 0; i < n; ++i) {
                    list.add(f);
                    f += 1.0f;
                }
            }
        });
    }

    static interface ListMaker {
        public void makeList(int var1);
    }

    public static class FloatList {
        public int n;
        public float[] a = new float[8];

        public void add(float f) {
            if (this.n == this.a.length) {
                float[] t = new float[2 * this.a.length];
                System.arraycopy(this.a, 0, t, 0, this.n);
                this.a = t;
            }
            this.a[this.n++] = f;
        }

        public float[] trim() {
            float[] t = new float[this.n];
            System.arraycopy(this.a, 0, t, 0, this.n);
            return t;
        }
    }
}

