/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Histogram;
import edu.mines.jtk.util.ArrayMath;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class HistogramTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(HistogramTest.class);
        TestRunner.run((Test)suite);
    }

    public void testConstant() {
        int n = 1001;
        float vfill = 2.0f;
        float[] v = ArrayMath.fillfloat(vfill, n);
        float vmin = vfill;
        float vmax = vfill;
        int nbin = 1;
        double dbin = 1.0;
        double fbin = (double)vmin + 0.5 * dbin;
        Histogram h = new Histogram(v);
        HistogramTest.assertEquals((Object)Float.valueOf(vmin), (Object)Float.valueOf(h.getMinValue()));
        HistogramTest.assertEquals((Object)Float.valueOf(vmax), (Object)Float.valueOf(h.getMaxValue()));
        HistogramTest.assertEquals((int)nbin, (int)h.getBinCount());
        HistogramTest.assertEquals((Object)dbin, (Object)h.getBinDelta());
        HistogramTest.assertEquals((Object)fbin, (Object)h.getBinFirst());
        HistogramTest.assertEquals((long)0L, (long)h.getLowCount());
        HistogramTest.assertEquals((long)n, (long)h.getInCount());
        HistogramTest.assertEquals((long)0L, (long)h.getHighCount());
        vmin = vfill;
        vmax = vfill;
        nbin = 3;
        dbin = 1.0;
        fbin = (double)vmin + 0.5 * dbin;
        h = new Histogram(v, nbin);
        HistogramTest.assertEquals((Object)Float.valueOf(vmin), (Object)Float.valueOf(h.getMinValue()));
        HistogramTest.assertEquals((Object)Float.valueOf(vmax), (Object)Float.valueOf(h.getMaxValue()));
        HistogramTest.assertEquals((int)nbin, (int)h.getBinCount());
        HistogramTest.assertEquals((Object)dbin, (Object)h.getBinDelta());
        HistogramTest.assertEquals((Object)fbin, (Object)h.getBinFirst());
        HistogramTest.assertEquals((long)0L, (long)h.getLowCount());
        HistogramTest.assertEquals((long)n, (long)h.getInCount());
        HistogramTest.assertEquals((long)0L, (long)h.getHighCount());
        vmin = vfill - 2.0f;
        vmax = vfill - 1.0f;
        nbin = 1;
        dbin = vmax - vmin;
        fbin = 0.5 * (double)(vmin + vmax);
        h = new Histogram(v, vmin, vmax);
        HistogramTest.assertEquals((Object)Float.valueOf(vmin), (Object)Float.valueOf(h.getMinValue()));
        HistogramTest.assertEquals((Object)Float.valueOf(vmax), (Object)Float.valueOf(h.getMaxValue()));
        HistogramTest.assertEquals((int)nbin, (int)h.getBinCount());
        HistogramTest.assertEquals((Object)dbin, (Object)h.getBinDelta());
        HistogramTest.assertEquals((Object)fbin, (Object)h.getBinFirst());
        HistogramTest.assertEquals((long)0L, (long)h.getLowCount());
        HistogramTest.assertEquals((long)0L, (long)h.getInCount());
        HistogramTest.assertEquals((long)n, (long)h.getHighCount());
        vmin = vfill + 1.0f;
        vmax = vfill + 2.0f;
        nbin = 1;
        dbin = vmax - vmin;
        fbin = 0.5 * (double)(vmin + vmax);
        h = new Histogram(v, vmin, vmax);
        HistogramTest.assertEquals((Object)Float.valueOf(vmin), (Object)Float.valueOf(h.getMinValue()));
        HistogramTest.assertEquals((Object)Float.valueOf(vmax), (Object)Float.valueOf(h.getMaxValue()));
        HistogramTest.assertEquals((int)nbin, (int)h.getBinCount());
        HistogramTest.assertEquals((Object)dbin, (Object)h.getBinDelta());
        HistogramTest.assertEquals((Object)fbin, (Object)h.getBinFirst());
        HistogramTest.assertEquals((long)n, (long)h.getLowCount());
        HistogramTest.assertEquals((long)0L, (long)h.getInCount());
        HistogramTest.assertEquals((long)0L, (long)h.getHighCount());
    }

    public void testRamp() {
        int n = 1001;
        float[] v = ArrayMath.rampfloat(0.0f, 1.0f, n);
        float vmin = ArrayMath.min(v);
        float vmax = ArrayMath.max(v);
        int nbin = 10;
        double dbin = (vmax - vmin) / (float)nbin;
        double fbin = (double)vmin + 0.5 * dbin;
        Histogram h = new Histogram(v, nbin);
        HistogramTest.assertEquals((int)nbin, (int)h.getBinCount());
        HistogramTest.assertEquals((Object)dbin, (Object)h.getBinDelta());
        HistogramTest.assertEquals((Object)fbin, (Object)h.getBinFirst());
        HistogramTest.assertEquals((long)n, (long)h.getInCount());
        HistogramTest.assertEquals((long)0L, (long)h.getLowCount());
        HistogramTest.assertEquals((long)0L, (long)h.getHighCount());
    }
}

