/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v03;

import com.google.gson.JsonObject;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.DoubleStream;
import net.imglib2.realtransform.AffineTransform3D;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.universe.metadata.MetadataUtils;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5SingleScaleMetadataParser;

public class OmeNgffMultiScaleMetadata
extends MultiscaleMetadata<N5SingleScaleMetadata> {
    public final String name;
    public final String type;
    public final String version;
    public final String[] axes;
    public final OmeNgffDataset[] datasets;
    public final OmeNgffDownsamplingMetadata metadata;
    public transient String path;
    public transient N5SingleScaleMetadata[] childrenMetadata;
    public transient DatasetAttributes[] childrenAttributes;

    public OmeNgffMultiScaleMetadata(int nd, String path, String name, String type, String version, String[] axes, OmeNgffDataset[] datasets, DatasetAttributes[] childrenAttributes, OmeNgffDownsamplingMetadata metadata) {
        super(path, (N5DatasetMetadata[])OmeNgffMultiScaleMetadata.buildMetadata(nd, path, datasets, childrenAttributes, metadata));
        this.name = name;
        this.type = type;
        this.version = version;
        this.axes = axes;
        this.datasets = datasets;
        this.childrenAttributes = childrenAttributes;
        this.metadata = metadata;
    }

    private static N5SingleScaleMetadata[] buildMetadata(int nd, String path, OmeNgffDataset[] datasets, DatasetAttributes[] childrenAttributes, OmeNgffDownsamplingMetadata metadata) {
        int N = datasets.length;
        double[] pixelRes = DoubleStream.generate(() -> 1.0).limit(nd).toArray();
        double[] offset = DoubleStream.generate(() -> 0.0).limit(nd).toArray();
        double[] factors = metadata == null || metadata.scale == null ? DoubleStream.generate(() -> 2.0).limit(nd).toArray() : metadata.scale;
        N5SingleScaleMetadata[] childrenMetadata = new N5SingleScaleMetadata[N];
        for (int i = 0; i < N; ++i) {
            double[] factorsi = MetadataUtils.pow(factors, i);
            AffineTransform3D tform = N5SingleScaleMetadataParser.buildTransform(factorsi, pixelRes, Optional.empty());
            childrenMetadata[i] = new N5SingleScaleMetadata(MetadataUtils.canonicalPath(path, datasets[i].path), tform, factorsi, pixelRes, offset, "pixel", childrenAttributes[i]);
        }
        return childrenMetadata;
    }

    public N5SingleScaleMetadata[] buildChildren(int nd, DatasetAttributes[] datasetAttributes) {
        return OmeNgffMultiScaleMetadata.buildMetadata(nd, this.path, this.datasets, datasetAttributes, this.metadata);
    }

    public N5SingleScaleMetadata buildChild(int nd, N5DatasetMetadata datasetMeta) {
        AffineTransform3D id = new AffineTransform3D();
        double[] pixelRes = DoubleStream.of(1.0).limit(nd).toArray();
        double[] offset = DoubleStream.of(0.0).limit(nd).toArray();
        double[] factors = this.metadata == null || this.metadata.scale == null ? DoubleStream.of(2.0).limit(nd).toArray() : this.metadata.scale;
        N5SingleScaleMetadata childrenMetadata = new N5SingleScaleMetadata(this.path, id, factors, pixelRes, offset, "pixel", datasetMeta.getAttributes());
        return childrenMetadata;
    }

    @Override
    public String[] getPaths() {
        return (String[])Arrays.stream(this.datasets).map(x -> x.path).toArray(String[]::new);
    }

    public String[] getCanonicalPaths() {
        return (String[])Arrays.stream(this.getPaths()).map(x -> {
            N5URI url;
            if (x.startsWith("/")) {
                return x;
            }
            try {
                url = new N5URI("?" + this.path + "/" + x);
            }
            catch (URISyntaxException e) {
                return null;
            }
            return url.getGroupPath();
        }).toArray(String[]::new);
    }

    public N5SingleScaleMetadata[] getChildrenMetadata() {
        return this.childrenMetadata;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String[] units() {
        return (String[])Arrays.stream(this.datasets).map(x -> "pixel").toArray(String[]::new);
    }

    public static class OmeNgffDownsamplingMetadata {
        public int order;
        public boolean preserve_range;
        public double[] scale;
        public String method;
        public String version;
        public String args;
        public JsonObject kwargs;
    }

    public static class OmeNgffDataset {
        public String path;
    }
}

