/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imglib2.RandomAccessible;
import net.imglib2.RealLocalizable;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineSet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.type.numeric.NumericType;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.axes.Axis;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.IdentityCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.ScaleCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.SequenceCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.TranslationCoordinateTransform;

public class TransformUtils {
    public static double[][] affineToMatrix(AffineGet affine) {
        if (affine == null) {
            return null;
        }
        int N = affine.numSourceDimensions();
        double[][] mtx = new double[N][N + 1];
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N + 1; ++j) {
                mtx[i][j] = affine.get(i, j);
            }
        }
        return mtx;
    }

    public static AffineTransform3D spatialTransform3D(AffineGet affine, Axis[] axes) {
        int numSpatialDims = (int)Arrays.stream(axes).filter(x -> x.getType().equals("space")).count();
        if (affine.numTargetDimensions() == 3 && numSpatialDims == 3) {
            AffineTransform3D affine3d = new AffineTransform3D();
            affine3d.set(affine.getRowPackedCopy());
            return affine3d;
        }
        int[] spatialIndexes = new int[numSpatialDims];
        int j = 0;
        for (int i = 0; i < affine.numSourceDimensions(); ++i) {
            if (!axes[i].getType().equals("space")) continue;
            spatialIndexes[j++] = i;
        }
        return TransformUtils.spatialTransform3D(affine, spatialIndexes);
    }

    public static AffineTransform3D spatialTransform3D(AffineGet affine, int[] spatialIndexes) {
        int numSpatialDims = spatialIndexes.length;
        if (affine.numTargetDimensions() == 3 && numSpatialDims == 3) {
            AffineTransform3D affine3d = new AffineTransform3D();
            affine3d.set(affine.getRowPackedCopy());
            return affine3d;
        }
        int numAffineDims = affine.numTargetDimensions();
        if (numAffineDims < 3 || numSpatialDims < 3) {
            AffineGet spatialAffine = TransformUtils.subAffine(affine, spatialIndexes);
            return (AffineTransform3D)TransformUtils.superAffine(spatialAffine, 3, IntStream.range(0, numSpatialDims).toArray());
        }
        if (numAffineDims > 3 && numSpatialDims == 3) {
            return (AffineTransform3D)TransformUtils.subAffine(affine, spatialIndexes);
        }
        return null;
    }

    public static AffineGet subAffine(AffineGet affine, int[] indexes) {
        int nd = indexes.length;
        if (nd == 2) {
            AffineTransform2D out = new AffineTransform2D();
            out.set(TransformUtils.rowPackedSubMatrix(affine, indexes));
            return out;
        }
        if (nd == 3) {
            AffineTransform3D out = new AffineTransform3D();
            out.set(TransformUtils.rowPackedSubMatrix(affine, indexes));
            return out;
        }
        AffineTransform out = new AffineTransform(nd);
        out.set(TransformUtils.rowPackedSubMatrix(affine, indexes));
        return out;
    }

    public static double[] flatten(double[][] arr) {
        double[] out = new double[arr.length * arr[0].length];
        int k = 0;
        for (int i = 0; i < arr.length; ++i) {
            for (int j = 0; j < arr[i].length; ++j) {
                out[k++] = arr[i][j];
            }
        }
        return out;
    }

    public static double[] flattenColMajor(double[][] arr) {
        double[] out = new double[arr.length * arr[0].length];
        int k = 0;
        for (int j = 0; j < arr[0].length; ++j) {
            for (int i = 0; i < arr.length; ++i) {
                out[k++] = arr[i][j];
            }
        }
        return out;
    }

    private static double[] rowPackedSubMatrix(AffineGet affine, int[] indexes) {
        int ndIn = affine.numTargetDimensions();
        int nd = indexes.length;
        double[] dat = new double[nd * (nd + 1)];
        int k = 0;
        for (int i = 0; i < nd; ++i) {
            for (int j = 0; j < nd; ++j) {
                dat[k++] = affine.get(indexes[i], indexes[j]);
            }
            dat[k++] = affine.get(indexes[i], ndIn);
        }
        return dat;
    }

    public static <T extends AffineGet & AffineSet> AffineGet superAffine(AffineGet affine, int nd, int[] indexes) {
        int i;
        assert (indexes.length == affine.numSourceDimensions());
        if (affine.numTargetDimensions() == nd) {
            return affine;
        }
        Object out = nd == 2 ? new AffineTransform2D() : (nd == 3 ? new AffineTransform3D() : new AffineTransform(nd));
        int N = indexes.length;
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                ((AffineSet)out).set(affine.get(i, j), indexes[i], indexes[j]);
            }
        }
        for (i = 0; i < N; ++i) {
            ((AffineSet)out).set(affine.get(i, N), indexes[i], nd);
        }
        return out;
    }

    public static AffineTransform3D toAffine3D(SequenceCoordinateTransform seq) {
        return TransformUtils.toAffine3D(Arrays.stream(seq.getTransformations()).map(x -> CoordinateTransform.create(x)).collect(Collectors.toList()));
    }

    public static AffineTransform3D toAffine3D(Collection<CoordinateTransform<?>> transforms) {
        return TransformUtils.toAffine3D(null, transforms);
    }

    public static AffineGet toAffine(CoordinateTransform<?> transform, int nd) {
        if (transform.getType().equals("scale")) {
            return ((ScaleCoordinateTransform)transform).getTransform();
        }
        if (transform.getType().equals("translation")) {
            return ((TranslationCoordinateTransform)transform).getTransform();
        }
        if (transform.getType().equals("sequence")) {
            SequenceCoordinateTransform seq = (SequenceCoordinateTransform)transform;
            if (seq.isAffine()) {
                return seq.asAffine(nd);
            }
            return null;
        }
        return null;
    }

    public static AffineTransform3D toAffine3D(N5Reader n5, Collection<CoordinateTransform<?>> transforms) {
        AffineTransform3D total = new AffineTransform3D();
        for (CoordinateTransform<?> ct : transforms) {
            Object t;
            if (ct instanceof IdentityCoordinateTransform) continue;
            if (ct instanceof SequenceCoordinateTransform) {
                t = TransformUtils.toAffine3D((SequenceCoordinateTransform)ct);
                if (t == null) {
                    return null;
                }
                TransformUtils.preConcatenate(total, (AffineGet)t);
                continue;
            }
            t = ct.getTransform(n5);
            if (t instanceof AffineGet) {
                TransformUtils.preConcatenate(total, (AffineGet)t);
                continue;
            }
            return null;
        }
        return total;
    }

    public static void preConcatenate(AffineTransform3D tgt, AffineGet concatenate) {
        if (concatenate.numTargetDimensions() >= 3) {
            tgt.preConcatenate(concatenate);
        } else if (concatenate.numTargetDimensions() == 2) {
            AffineTransform3D c = new AffineTransform3D();
            c.set(concatenate.get(0, 0), concatenate.get(0, 1), 0.0, concatenate.get(0, 2), concatenate.get(1, 0), concatenate.get(1, 1), 0.0, concatenate.get(1, 2), 0.0, 0.0, 1.0, 0.0);
            tgt.preConcatenate(c);
        } else if (concatenate.numTargetDimensions() == 1) {
            ScaleAndTranslation c = new ScaleAndTranslation(new double[]{1.0, 1.0, 1.0}, new double[]{0.0, 0.0, 0.0});
            tgt.preConcatenate((AffineGet)c);
        }
    }

    public static <T extends NumericType<T>> InterpolatorFactory<T, RandomAccessible<T>> interpolator(String interpolator) {
        switch (interpolator) {
            case "linear": {
                return new NLinearInterpolatorFactory();
            }
            case "nearest": {
                return new NearestNeighborInterpolatorFactory();
            }
        }
        return null;
    }

    public static double squaredDistance(Double[] p, RealLocalizable q) {
        double dist = 0.0;
        for (int j = 0; j < p.length; ++j) {
            dist += (p[j] - q.getDoublePosition(j)) * (p[j] - q.getDoublePosition(j));
        }
        return dist;
    }

    public static double distance(Double[] p, RealLocalizable q) {
        return Math.sqrt(TransformUtils.squaredDistance(p, q));
    }

    public static double squaredDistance(RealLocalizable p, RealLocalizable q) {
        double dist = 0.0;
        for (int j = 0; j < p.numDimensions(); ++j) {
            dist += (p.getDoublePosition(j) - q.getDoublePosition(j)) * (p.getDoublePosition(j) - q.getDoublePosition(j));
        }
        return dist;
    }

    public static double distance(RealLocalizable p, RealLocalizable q) {
        return Math.sqrt(TransformUtils.squaredDistance(p, q));
    }
}

