/*
 * Decompiled with CFR 0.152.
 */
package QuickPALM;

import QuickPALM.MyDialogs;
import QuickPALM.MyFunctions;
import QuickPALM.MyIO;
import QuickPALM.ParticleSaver;
import ij.IJ;
import ij.ImagePlus;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public class Save_particles_table2img
implements PlugIn {
    MyDialogs dg = new MyDialogs();
    MyFunctions f = new MyFunctions();
    MyIO io = new MyIO();
    ParticleSaver psaver = new ParticleSaver();
    ImagePlus imp;
    ImageProcessor ip;

    public void run(String arg) {
        SaveDialog sd = new SaveDialog("File to save particles into", "Particles Table", ".tif");
        String path = sd.getDirectory();
        String filename = path + sd.getFileName();
        double[] s = this.f.ptable.getColumnAsDoubles(0);
        double[] x = this.f.ptable.getColumnAsDoubles(1);
        double[] y = this.f.ptable.getColumnAsDoubles(2);
        double[] x_ = this.f.ptable.getColumnAsDoubles(3);
        double[] y_ = this.f.ptable.getColumnAsDoubles(4);
        double[] z_ = this.f.ptable.getColumnAsDoubles(5);
        double[] left = this.f.ptable.getColumnAsDoubles(6);
        double[] right = this.f.ptable.getColumnAsDoubles(7);
        double[] up = this.f.ptable.getColumnAsDoubles(8);
        double[] down = this.f.ptable.getColumnAsDoubles(9);
        double[] xsym = this.f.ptable.getColumnAsDoubles(10);
        double[] ysym = this.f.ptable.getColumnAsDoubles(11);
        double[] wmh = this.f.ptable.getColumnAsDoubles(12);
        double[] frame = this.f.ptable.getColumnAsDoubles(13);
        this.ip = new FloatProcessor(14, s.length);
        this.imp = new ImagePlus("Particles Table", this.ip);
        IJ.showStatus((String)"Generating Particles Table Image...");
        for (int n = 0; n < s.length; ++n) {
            IJ.showProgress((int)n, (int)s.length);
            this.ip.setf(0, n, (float)s[n]);
            this.ip.setf(1, n, (float)x[n]);
            this.ip.setf(2, n, (float)y[n]);
            this.ip.setf(3, n, (float)x_[n] / 1000.0f);
            this.ip.setf(4, n, (float)y_[n] / 1000.0f);
            this.ip.setf(5, n, (float)z_[n] / 1000.0f);
            this.ip.setf(6, n, (float)left[n]);
            this.ip.setf(7, n, (float)right[n]);
            this.ip.setf(8, n, (float)up[n]);
            this.ip.setf(9, n, (float)down[n]);
            this.ip.setf(10, n, (float)xsym[n]);
            this.ip.setf(11, n, (float)ysym[n]);
            this.ip.setf(12, n, (float)wmh[n]);
            this.ip.setf(13, n, (float)frame[n] / 1000000.0f);
        }
        IJ.showStatus((String)"Saving Particles Table Image...");
        IJ.save((ImagePlus)this.imp, (String)filename);
        this.imp.close();
    }
}

