/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata;

import java.util.ArrayList;
import java.util.List;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.metadata.MetadataSource;
import org.janelia.saalfeldlab.n5.universe.metadata.N5DatasetMetadata;

public class MetadataSources<T extends NumericType<T> & NativeType<T>> {
    private final N5Reader n5;
    private final N5DatasetMetadata metadata;
    private int nChannels;
    private int channelDim;
    private List<MetadataSource<T>> sources;

    public MetadataSources(N5Reader n5, N5DatasetMetadata metadata) {
        this.n5 = n5;
        this.metadata = metadata;
        MetadataSource src = new MetadataSource(n5, metadata);
        this.channelDim = src.getChannelDimension();
        this.nChannels = this.channelDim < 0 ? 1 : (int)src.getRawImage().dimension(this.channelDim);
        this.sources = this.buildSources();
    }

    public List<MetadataSource<T>> buildSources() {
        this.sources = new ArrayList<MetadataSource<T>>();
        for (int i = 0; i < this.nChannels; ++i) {
            this.sources.add(new MetadataSource(this.n5, this.metadata, this.channelDim, i));
        }
        return this.sources;
    }

    public List<MetadataSource<T>> getSources() {
        return this.sources;
    }
}

