/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.imaris;

import io.scif.formats.imaris.PipelineImage;
import io.scif.formats.imaris.ResolutionLevel;
import java.util.LinkedList;
import java.util.TreeMap;

public class HDFPreprocessor {
    private final int batchSize_;
    private final ResolutionLevel[] resLevels_;
    private final TreeMap<Integer, long[][]> histograms_;
    private final int bitDepth_;
    private final int width_;
    private final int height_;

    public HDFPreprocessor(int width, int height, int bitDepth, ResolutionLevel[] resLevels) {
        this.bitDepth_ = bitDepth;
        this.resLevels_ = resLevels;
        this.batchSize_ = this.resLevels_[this.resLevels_.length - 1].getReductionFactorZ();
        this.width_ = width;
        this.height_ = height;
        this.histograms_ = new TreeMap();
    }

    /*
     * WARNING - void declaration
     */
    public PipelineImage process(LinkedList<PipelineImage> slices) {
        if (slices.getFirst().slice == 0) {
            this.histograms_.put(slices.getFirst().channel, new long[this.resLevels_.length][256]);
        }
        int numSlicesInChunk = slices.size();
        Object[][] downsampledPixSum = new Object[this.resLevels_.length][numSlicesInChunk];
        Object[][] pixelsToWrite = new Object[this.resLevels_.length][numSlicesInChunk];
        for (int i = 0; i < numSlicesInChunk; ++i) {
            pixelsToWrite[0][i] = slices.get((int)i).pixels;
            if (pixelsToWrite[0][i] == null) break;
            if (this.bitDepth_ > 8) {
                for (short s : (short[])slices.get((int)i).pixels) {
                    long[] lArray = this.histograms_.get(slices.getFirst().channel)[0];
                    int n = (int)(255.0 * ((double)(s & 0xFFFF) / Math.pow(2.0, this.bitDepth_)));
                    lArray[n] = lArray[n] + 1L;
                }
                continue;
            }
            for (byte b : (byte[])slices.get((int)i).pixels) {
                long[] lArray = this.histograms_.get(slices.getFirst().channel)[0];
                int n = b & 0xFF;
                lArray[n] = lArray[n] + 1L;
            }
        }
        for (int resLevel = 1; resLevel < this.resLevels_.length; ++resLevel) {
            void var6_10;
            boolean bl = false;
            while (var6_10 < numSlicesInChunk) {
                if (var6_10 % this.resLevels_[resLevel].getReductionFactorZ() == false) {
                    downsampledPixSum[resLevel][var6_10] = new long[this.resLevels_[resLevel].getImageSizeX() * this.resLevels_[resLevel].getImageSizeY()];
                    pixelsToWrite[resLevel][var6_10] = this.bitDepth_ > 8 ? (Object)new short[this.resLevels_[resLevel].getImageSizeX() * this.resLevels_[resLevel].getImageSizeY()] : (Object)new byte[this.resLevels_[resLevel].getImageSizeX() * this.resLevels_[resLevel].getImageSizeY()];
                }
                ++var6_10;
            }
        }
        int res0Width = this.width_;
        int n = res0Width * this.height_;
        for (int sliceIndex = 0; sliceIndex < numSlicesInChunk; ++sliceIndex) {
            for (int i = 0; i < n; ++i) {
                int x = i % res0Width;
                int y = i / res0Width;
                for (int resLevel = 1; resLevel < this.resLevels_.length; ++resLevel) {
                    int val;
                    int resLevelSizeX = this.resLevels_[resLevel].getImageSizeX();
                    int resLevelSizeY = this.resLevels_[resLevel].getImageSizeY();
                    int zDSFactor = this.resLevels_[resLevel].getReductionFactorZ();
                    int xDSFactor = this.resLevels_[resLevel].getReductionFactorX();
                    int yDSFactor = this.resLevels_[resLevel].getReductionFactorY();
                    int dsX = x / xDSFactor;
                    int dsY = y / yDSFactor;
                    if (dsX >= resLevelSizeX || dsY >= resLevelSizeY) continue;
                    int downsampledSliceIndex = sliceIndex - sliceIndex % zDSFactor;
                    if (slices.get((int)sliceIndex).pixels == null) {
                        val = 0;
                        val = this.bitDepth_ > 8 ? ((short[])slices.get((int)0).pixels)[i] & 0xFFFF : ((byte[])slices.get((int)0).pixels)[i] & 0xFF;
                    } else if (this.bitDepth_ > 8) {
                        if (slices.get(sliceIndex) == null) {
                            System.out.println("null slice index");
                        } else if (slices.get(sliceIndex) == null) {
                            System.out.println("null pix");
                        }
                        val = ((short[])slices.get((int)sliceIndex).pixels)[i] & 0xFFFF;
                        long[] lArray = this.histograms_.get(slices.getFirst().channel)[resLevel];
                        int n2 = (int)(255.0 * ((double)val / Math.pow(2.0, this.bitDepth_)));
                        lArray[n2] = lArray[n2] + 1L;
                    } else {
                        val = ((byte[])slices.get((int)sliceIndex).pixels)[i] & 0xFF;
                        long[] lArray = this.histograms_.get(slices.getFirst().channel)[resLevel];
                        int n3 = val;
                        lArray[n3] = lArray[n3] + 1L;
                    }
                    long[] lArray = (long[])downsampledPixSum[resLevel][downsampledSliceIndex];
                    int n4 = dsY * resLevelSizeX + dsX;
                    lArray[n4] = lArray[n4] + (long)val;
                    if (x % xDSFactor != xDSFactor - 1 || y % yDSFactor != yDSFactor - 1 || sliceIndex % zDSFactor != zDSFactor - 1) continue;
                    int pixelIndex = x / xDSFactor + y / yDSFactor * resLevelSizeX;
                    if (this.bitDepth_ > 8) {
                        ((short[])pixelsToWrite[resLevel][downsampledSliceIndex])[pixelIndex] = (short)(((long[])downsampledPixSum[resLevel][downsampledSliceIndex])[pixelIndex] / (long)(xDSFactor * yDSFactor * zDSFactor));
                        continue;
                    }
                    ((byte[])pixelsToWrite[resLevel][downsampledSliceIndex])[pixelIndex] = (byte)(((long[])downsampledPixSum[resLevel][downsampledSliceIndex])[pixelIndex] / (long)(xDSFactor * yDSFactor * zDSFactor));
                }
            }
        }
        PipelineImage img = new PipelineImage(pixelsToWrite, slices.getFirst().channel, slices.getFirst().slice, slices.getFirst().frame, slices.getFirst().dateAndtime);
        if (slices.getFirst().slice + this.batchSize_ >= this.resLevels_[0].getImageSizeZ()) {
            img.histograms = this.histograms_.get(slices.getFirst().channel);
            this.histograms_.put(slices.getFirst().channel, null);
        }
        return img;
    }
}

