/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.imaris;

import hdf.hdf5lib.H5;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5Exception;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import io.scif.formats.imaris.HDFUtils;
import io.scif.formats.imaris.PipelineImage;
import io.scif.formats.imaris.ResolutionLevel;
import io.scif.formats.imaris.TimePoint;
import java.awt.Color;
import java.text.DecimalFormat;
import javax.swing.JOptionPane;

public class HDFWriter {
    private static final Color[] DEFAULT_CHANNEL_COLORS = new Color[]{new Color(75, 0, 130), Color.blue, Color.green, Color.yellow, Color.red, Color.pink, Color.orange, Color.magenta};
    private static final String VERSION = "7.6";
    private final int bitDepth_;
    private String acqDate_ = "2012-11-08 16:14:17.000";
    private final int numChannels_;
    private final int numFrames_;
    private final int imageWidth_;
    private final int imageHeight_;
    private final int numSlices_;
    private final double pixelSize_;
    private final double pixelSizeZ_;
    private long fileID_;
    private long timeInfoID_;
    private final DecimalFormat numberFormat_ = new DecimalFormat("#.###");
    private final ResolutionLevel[] resLevels_;
    private long[] resLevelIDs_;
    private final String path_;
    private TimePoint currentTimePoint_;
    private int timePointImageCount_ = 0;
    private final boolean compressImageData_;
    private final int slicesPerWrite_;
    private Color[] channelColors_;
    private boolean initialized_ = false;

    public HDFWriter(String path, int numChannels, int numFrames, int numSlices, int bitDepth, double pixelSize, double pixelSizeZ, Color[] channelColors, int width, int height, ResolutionLevel[] resLevels) {
        this.compressImageData_ = true;
        this.path_ = path;
        this.numChannels_ = numChannels;
        this.numFrames_ = numFrames;
        this.numSlices_ = numSlices;
        this.pixelSize_ = pixelSize;
        this.pixelSizeZ_ = pixelSizeZ;
        this.channelColors_ = channelColors == null ? DEFAULT_CHANNEL_COLORS : channelColors;
        this.bitDepth_ = bitDepth;
        this.imageWidth_ = width;
        this.imageHeight_ = height;
        this.resLevels_ = resLevels;
        this.slicesPerWrite_ = this.resLevels_[this.resLevels_.length - 1].getReductionFactorZ();
    }

    public void close() {
        try {
            if (this.currentTimePoint_ != null) {
                this.currentTimePoint_.closeTimePoint();
            }
            H5.H5Gclose((long)this.timeInfoID_);
            for (long id : this.resLevelIDs_) {
                H5.H5Gclose((long)id);
            }
            H5.H5Fclose((long)this.fileID_);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Couldn't close Imaris file");
            e.printStackTrace();
        }
    }

    public void writeImage(PipelineImage img) throws Exception {
        if (!this.initialized_) {
            this.acqDate_ = img.dateAndtime;
            this.createFile();
            this.initialized_ = true;
        }
        if (this.timePointImageCount_ == 0) {
            this.currentTimePoint_ = new TimePoint(this.resLevels_, this.resLevelIDs_, this.numChannels_, img.frame, this.bitDepth_, this.compressImageData_);
            HDFUtils.writeStringAttribute(this.timeInfoID_, "TimePoint" + (1 + img.frame), img.dateAndtime);
        }
        this.currentTimePoint_.writePixels(img);
        this.timePointImageCount_ = this.numSlices_ % this.slicesPerWrite_ != 0 && img.slice + this.slicesPerWrite_ - 1 >= this.numSlices_ ? (this.timePointImageCount_ += this.numSlices_ % this.slicesPerWrite_) : (this.timePointImageCount_ += this.slicesPerWrite_);
        if (this.timePointImageCount_ == this.numChannels_ * this.numSlices_) {
            if (img.histograms == null) {
                JOptionPane.showMessageDialog(null, "histogram not created correctly");
                img.histograms = new long[this.resLevels_.length][256];
            }
            this.currentTimePoint_.closeTimePoint();
            this.currentTimePoint_ = null;
            this.timePointImageCount_ = 0;
        }
    }

    private void createFile() {
        try {
            this.fileID_ = H5.H5Fcreate((String)this.path_, (int)((int)HDF5Constants.H5P_DEFAULT), (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
            this.addRootAttributes();
            this.makeDataSetInfo();
            this.makeDataSet();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Couldnt create imaris file");
            e.printStackTrace();
        }
    }

    private void addRootAttributes() throws HDF5LibraryException, HDF5Exception {
        HDFUtils.writeStringAttribute(this.fileID_, "DataSetDirectoryName", "DataSet");
        HDFUtils.writeStringAttribute(this.fileID_, "DataSetInfoDirectoryName", "DataSetInfo");
        HDFUtils.writeStringAttribute(this.fileID_, "ImarisDataSet", "ImarisDataSet");
        HDFUtils.writeStringAttribute(this.fileID_, "ImarisVersion", "5.5.0");
        long dataspaceID = H5.H5Screate_simple((int)1, (long[])new long[]{1L}, null);
        long attID = H5.H5Acreate((long)this.fileID_, (String)"NumberOfDataSets", (long)HDF5Constants.H5T_NATIVE_UINT32, (long)dataspaceID, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        H5.H5Awrite((long)attID, (long)HDF5Constants.H5T_NATIVE_UINT32, (byte[])new byte[]{1, 0, 0, 0});
        H5.H5Sclose((long)dataspaceID);
        H5.H5Aclose((long)attID);
    }

    private void makeDataSetInfo() throws NullPointerException, HDF5LibraryException, HDF5Exception {
        long dataSetGroupID = H5.H5Gcreate((long)this.fileID_, (String)"/DataSetInfo", (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        for (int c = 0; c < this.numChannels_; ++c) {
            long channelID = H5.H5Gcreate((long)dataSetGroupID, (String)("Channel " + c), (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
            float[] rgb = this.channelColors_[c % this.numChannels_].getRGBColorComponents(null);
            HDFUtils.writeStringAttribute(channelID, "Color", this.numberFormat_.format(rgb[0]) + " " + this.numberFormat_.format(rgb[1]) + " " + this.numberFormat_.format(rgb[2]));
            HDFUtils.writeStringAttribute(channelID, "ColorMode", "BaseColor");
            HDFUtils.writeStringAttribute(channelID, "ColorOpacity", "1.000");
            HDFUtils.writeStringAttribute(channelID, "ColorRange", "0 " + ((int)Math.pow(2.0, this.bitDepth_) - 1));
            HDFUtils.writeStringAttribute(channelID, "Description", "(description not specified)");
            HDFUtils.writeStringAttribute(channelID, "GammaCorrection", "1.000");
            HDFUtils.writeStringAttribute(channelID, "Name", "(name not specified)");
            H5.H5Gclose((long)channelID);
        }
        long imageID = H5.H5Gcreate((long)dataSetGroupID, (String)"Image", (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        HDFUtils.writeStringAttribute(imageID, "Description", "(description not specified)");
        HDFUtils.writeStringAttribute(imageID, "ExtMax0", this.numberFormat_.format((double)this.imageWidth_ * this.pixelSize_));
        HDFUtils.writeStringAttribute(imageID, "ExtMax1", this.numberFormat_.format((double)this.imageHeight_ * this.pixelSize_));
        HDFUtils.writeStringAttribute(imageID, "ExtMax2", this.numberFormat_.format((double)this.numSlices_ * this.pixelSizeZ_));
        HDFUtils.writeStringAttribute(imageID, "ExtMin0", "0");
        HDFUtils.writeStringAttribute(imageID, "ExtMin1", "0");
        HDFUtils.writeStringAttribute(imageID, "ExtMin2", "0");
        HDFUtils.writeStringAttribute(imageID, "Name", "(name not specified)");
        if (this.acqDate_ != null) {
            HDFUtils.writeStringAttribute(imageID, "RecordingDate", this.acqDate_);
        }
        HDFUtils.writeStringAttribute(imageID, "Unit", "um");
        HDFUtils.writeStringAttribute(imageID, "X", this.imageWidth_ + "");
        HDFUtils.writeStringAttribute(imageID, "Y", this.imageHeight_ + "");
        HDFUtils.writeStringAttribute(imageID, "Z", this.numSlices_ + "");
        H5.H5Gclose((long)imageID);
        long imarisID = H5.H5Gcreate((long)dataSetGroupID, (String)"Imaris", (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        HDFUtils.writeStringAttribute(imarisID, "Version", VERSION);
        H5.H5Gclose((long)imarisID);
        long imarisDSID = H5.H5Gcreate((long)dataSetGroupID, (String)"ImarisDataSet", (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        HDFUtils.writeStringAttribute(imarisDSID, "Creator", "Imaricumpiler");
        HDFUtils.writeStringAttribute(imarisDSID, "NumberOfImages", "1");
        HDFUtils.writeStringAttribute(imarisDSID, "Version", VERSION);
        H5.H5Gclose((long)imarisDSID);
        long logID = H5.H5Gcreate((long)dataSetGroupID, (String)"Log", (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        HDFUtils.writeStringAttribute(logID, "Entries", "0");
        H5.H5Gclose((long)logID);
        this.timeInfoID_ = H5.H5Gcreate((long)dataSetGroupID, (String)"TimeInfo", (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        HDFUtils.writeStringAttribute(this.timeInfoID_, "DatasetTimePoints", this.numFrames_ + "");
        HDFUtils.writeStringAttribute(this.timeInfoID_, "FileTimePoints", this.numFrames_ + "");
        H5.H5Gclose((long)dataSetGroupID);
    }

    private void makeDataSet() throws NullPointerException, HDF5LibraryException, HDF5Exception {
        this.resLevelIDs_ = new long[this.resLevels_.length];
        long dataSetGroupID = H5.H5Gcreate((long)this.fileID_, (String)"/DataSet", (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        for (int level = 0; level < this.resLevels_.length; ++level) {
            this.resLevelIDs_[level] = H5.H5Gcreate((long)dataSetGroupID, (String)("ResolutionLevel " + level), (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT, (long)HDF5Constants.H5P_DEFAULT);
        }
        H5.H5Gclose((long)dataSetGroupID);
    }
}

