/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bigwarp.landmarks.LandmarkTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigWarpLandmarkPanel
extends JPanel {
    private static final long serialVersionUID = 8470689265638231579L;
    protected LandmarkTableModel tableModel;
    protected JTable table;
    public final Logger logger = LoggerFactory.getLogger(BigWarpLandmarkPanel.class);

    public BigWarpLandmarkPanel(LandmarkTableModel tableModel) {
        super(new GridLayout(1, 0));
        this.setTableModel(tableModel);
        this.genJTable();
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
    }

    public LandmarkTableModel getTableModel() {
        return this.tableModel;
    }

    public int numDimensions() {
        return this.tableModel.getNumdims();
    }

    public void genJTable() {
        this.table = new JTableChecking(this.getTableModel());
        this.table.setPreferredScrollableViewportSize(new Dimension(400, 800));
        this.table.setFillsViewportHeight(true);
        this.table.setShowVerticalLines(false);
        this.table.setDefaultEditor(String.class, new TextFieldCellEditor(new TextFieldCell(this.table), String.class));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BigWarpLandmarkPanel.this.logger.trace("table selection changed");
                boolean setMoving = false;
                boolean setFixed = false;
                int row = BigWarpLandmarkPanel.this.table.getSelectedRow();
                if (row < 0) {
                    BigWarpLandmarkPanel.this.tableModel.setNextRow(true, BigWarpLandmarkPanel.this.tableModel.getRowCount());
                    BigWarpLandmarkPanel.this.tableModel.setNextRow(false, BigWarpLandmarkPanel.this.tableModel.getRowCount());
                    return;
                }
                if (!BigWarpLandmarkPanel.this.tableModel.isMovingPoint(row) && !setMoving) {
                    BigWarpLandmarkPanel.this.tableModel.setNextRow(true, row);
                    setMoving = true;
                    BigWarpLandmarkPanel.this.logger.trace("nextRow Moving: " + row);
                } else {
                    BigWarpLandmarkPanel.this.tableModel.setNextRow(true, BigWarpLandmarkPanel.this.tableModel.getRowCount());
                }
                if (!BigWarpLandmarkPanel.this.tableModel.isFixedPoint(row) && !setFixed) {
                    BigWarpLandmarkPanel.this.tableModel.setNextRow(false, row);
                    setFixed = true;
                    BigWarpLandmarkPanel.this.logger.trace("nextRow Fixed: " + row);
                } else {
                    BigWarpLandmarkPanel.this.tableModel.setNextRow(false, BigWarpLandmarkPanel.this.tableModel.getRowCount());
                }
            }
        });
    }

    public void setTableModel(LandmarkTableModel tableModel) {
        this.tableModel = tableModel;
        this.genJTable();
    }

    public JTable getJTable() {
        return this.table;
    }

    public static class TextFieldCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 9185738725311357320L;
        TextFieldCell textField;
        Class<?> columnClass;
        Object valueObject;

        public TextFieldCellEditor(TextFieldCell tf, Class<?> cc) {
            super(tf);
            this.textField = tf;
            this.columnClass = cc;
            this.valueObject = null;
        }

        @Override
        public boolean stopCellEditing() {
            this.delegate.setValue(this.textField.getText());
            this.fireEditingStopped();
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            TextFieldCell tf = (TextFieldCell)super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value != null) {
                tf.setText(value.toString());
            }
            this.valueObject = value;
            return tf;
        }

        @Override
        public Object getCellEditorValue() {
            try {
                if (this.columnClass.equals(Double.class)) {
                    return Double.parseDouble(this.textField.getText());
                }
                if (this.columnClass.equals(Float.class)) {
                    return Float.valueOf(Float.parseFloat(this.textField.getText()));
                }
                if (this.columnClass.equals(Integer.class)) {
                    return Integer.parseInt(this.textField.getText());
                }
                if (this.columnClass.equals(Byte.class)) {
                    return Byte.parseByte(this.textField.getText());
                }
                if (this.columnClass.equals(String.class)) {
                    return this.textField.getText();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (this.valueObject != null) {
                if (this.valueObject instanceof Double) {
                    return (double)((Double)this.valueObject);
                }
                if (this.valueObject instanceof Float) {
                    return Float.valueOf(((Float)this.valueObject).floatValue());
                }
                if (this.valueObject instanceof Integer) {
                    return (int)((Integer)this.valueObject);
                }
                if (this.valueObject instanceof Byte) {
                    return (byte)((Byte)this.valueObject);
                }
                if (this.valueObject instanceof String) {
                    return (String)this.valueObject;
                }
            }
            return null;
        }
    }

    public static class TextFieldCell
    extends JTextField {
        private static final long serialVersionUID = -4327183047476876882L;

        public TextFieldCell(JTable cellTable) {
            final JTable table = cellTable;
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    TableCellEditor cellEditor = table.getCellEditor();
                    if (cellEditor != null) {
                        if (cellEditor.getCellEditorValue() != null) {
                            cellEditor.stopCellEditing();
                        } else {
                            cellEditor.cancelCellEditing();
                        }
                    }
                }
            });
        }
    }

    public static class JTableChecking
    extends JTable {
        private static final long serialVersionUID = 1437406384583869710L;

        public JTableChecking(AbstractTableModel tableModel) {
            super(tableModel);
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (this.isEditing()) {
                return false;
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
    }
}

