/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.export.ProgressWriterConsole;
import bdv.img.WarpedSource;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.WrapBasicImgLoader;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bigwarp.BigWarp;
import bigwarp.BigWarpData;
import bigwarp.BigWarpExporter;
import bigwarp.BigWarpInit;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.loader.ImagePlusLoader;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;
import loci.formats.FormatException;
import loci.formats.in.TiffReader;
import loci.plugins.BF;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.generic.sequence.TypedBasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.ConstantUtils;
import org.janelia.utility.parse.ParseUtils;

public class BigWarpBatchTransformFOV {
    private transient JCommander jCommander;
    @Parameter(names={"--image", "-i"}, description="Input image file")
    private String imageFilePath;
    @Parameter(names={"--landmarks", "-l"}, description="Input landmarks file")
    private String landmarkFilePath;
    @Parameter(names={"--output", "-o"}, description="Output image file")
    private String outputFilePath;
    @Parameter(names={"--dimension", "-d"}, description="Dimension of output image (overrides target image)", converter=ParseUtils.LongArrayConverter.class)
    private long[] dims;
    @Parameter(names={"--target", "-t"}, description="Path to reference (target) image")
    private String referenceImagePath;
    @Parameter(names={"--threads", "-j"}, description="Number of threads")
    private int nThreads = 1;
    @Parameter(names={"--out-spacing", "-s"}, description="Output voxel spacing, e.g. \"0.5,0.5,2.0\" (overrides target image)", converter=ParseUtils.DoubleArrayConverter.class)
    private double[] spacing;
    @Parameter(names={"--in-spacing"}, description="Input voxel spacing (overrides image metadata)", converter=ParseUtils.DoubleArrayConverter.class)
    private double[] input_spacing;
    @Parameter(names={"--offset", "-f"}, description="Offset, e.g. \"5.0,5.0,-1.0\" (overrides target image)", converter=ParseUtils.DoubleArrayConverter.class)
    private double[] offset;
    @Parameter(names={"--help", "-h"}, help=true)
    private boolean help;
    private long[] dimsFull;
    private double[] spacingFull;
    private double[] offsetFull;
    @Parameter(names={"--interpolation", "-p"}, description="Interpolation Type {NLINEAR,NEARESTNEIGHBOR}")
    private String interpType = "NLINEAR";

    public static void main(String[] args) throws IOException {
        BigWarpBatchTransformFOV alg = BigWarpBatchTransformFOV.parseCommandLineArgs(args);
        alg.process();
    }

    private void initCommander() {
        this.jCommander = new JCommander((Object)this);
        this.jCommander.setProgramName("input parser");
    }

    public static BigWarpBatchTransformFOV parseCommandLineArgs(String[] args) {
        BigWarpBatchTransformFOV alg = new BigWarpBatchTransformFOV();
        alg.initCommander();
        try {
            alg.jCommander.parse(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (alg.help) {
            alg.jCommander.usage();
            return alg;
        }
        if (alg.referenceImagePath != null && !alg.referenceImagePath.isEmpty() && (alg.referenceImagePath.endsWith("tif") || alg.referenceImagePath.endsWith("tiff") || alg.referenceImagePath.endsWith("TIF") || alg.referenceImagePath.endsWith("TIFF"))) {
            TiffReader reader = new TiffReader();
            try {
                reader.setId(alg.referenceImagePath);
                Hashtable meta = reader.getGlobalMetadata();
                alg.dimsFull = new long[3];
                alg.dimsFull[0] = reader.getSizeX();
                alg.dimsFull[1] = reader.getSizeY();
                alg.dimsFull[2] = reader.getSizeZ();
                alg.spacingFull = new double[3];
                alg.spacingFull[0] = 1.0 / (Double)meta.get("XResolution");
                alg.spacingFull[1] = 1.0 / (Double)meta.get("YResolution");
                alg.spacingFull[2] = (Double)meta.get("Spacing");
                alg.offsetFull = new double[3];
                reader.close();
            }
            catch (IOException | FormatException e) {
                alg.dimsFull = null;
                e.printStackTrace();
            }
        }
        int nd = 3;
        if (alg.offset != null) {
            nd = alg.offset.length;
            alg.offsetFull = alg.offset.length < 3 ? BigWarpBatchTransformFOV.fill(alg.offset, nd) : alg.offset;
        }
        if (alg.offsetFull == null) {
            alg.offsetFull = new double[3];
        }
        if (alg.spacing != null) {
            alg.spacingFull = alg.spacing.length < 3 ? BigWarpBatchTransformFOV.fill(alg.spacing, nd) : alg.spacing;
        }
        if (alg.spacingFull == null) {
            alg.spacingFull = new double[3];
            Arrays.fill(alg.spacingFull, 1.0);
        }
        if (alg.dims != null) {
            if (alg.dims.length == 1) {
                alg.dimsFull = new long[3];
                Arrays.fill(alg.dimsFull, alg.dims[0]);
            } else if (alg.dims.length == 2) {
                alg.dimsFull = new long[3];
                System.arraycopy(alg.dims, 0, alg.dimsFull, 0, 2);
                alg.dimsFull[2] = 1L;
            } else if (alg.dims.length == 3) {
                alg.dimsFull = alg.dims;
            }
        }
        return alg;
    }

    public void process() throws IOException {
        if (this.help) {
            return;
        }
        long startTime = System.currentTimeMillis();
        int nd = this.dimsFull.length;
        if (nd != 3 && nd != 2) {
            System.err.println("For 2D or 3D use only");
            return;
        }
        LandmarkTableModel ltm = new LandmarkTableModel(nd);
        ltm.load(new File(this.landmarkFilePath));
        ImagePlus impP = null;
        try {
            impP = IJ.openImage((String)this.imageFilePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (impP == null) {
            try {
                impP = BF.openImagePlus((String)this.imageFilePath)[0];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (impP == null) {
            System.err.println("FAILED TO READ IMAGE FROM: " + this.imageFilePath);
        }
        if (this.input_spacing != null) {
            System.out.println("overriding input resolution: " + Arrays.toString(this.input_spacing));
            impP.getCalibration().pixelWidth = this.input_spacing[0];
            impP.getCalibration().pixelHeight = this.input_spacing[1];
            impP.getCalibration().pixelDepth = this.input_spacing[2];
        }
        ImagePlusLoader loaderP = new ImagePlusLoader(impP);
        SpimDataMinimal[] spimDataP = loaderP.loadAll(0);
        int numMovingChannels = loaderP.numChannels();
        AbstractSpimData[] spimDataQ = new AbstractSpimData[]{this.createSpimData()};
        BigWarpExporter exporter = BigWarpBatchTransformFOV.applyBigWarpHelper(spimDataP, spimDataQ, impP, ltm, Interpolation.valueOf((String)this.interpType));
        exporter.setNumThreads(this.nThreads);
        exporter.setVirtual(false);
        exporter.setInterval((Interval)new FinalInterval(this.dimsFull));
        exporter.setRenderResolution(this.spacingFull);
        exporter.setOffset(this.offsetFull);
        exporter.setInterp(Interpolation.valueOf((String)this.interpType));
        exporter.showResult(false);
        exporter.exportThread = new BigWarpExporter.ExportThread(exporter, true);
        exporter.exportThread.run();
        ImagePlus ipout = exporter.getResult();
        System.out.println("saving");
        IJ.save((ImagePlus)ipout, (String)this.outputFilePath);
        long endTime = System.currentTimeMillis();
        System.out.println("total time: " + (endTime - startTime) + " ms");
        System.exit(0);
    }

    public static <T> BigWarpExporter<T> applyBigWarpHelper(AbstractSpimData<?>[] spimDataP, AbstractSpimData<?>[] spimDataQ, ImagePlus impP, LandmarkTableModel ltm, Interpolation interpolation) {
        String[] names = BigWarpBatchTransformFOV.generateNames(impP);
        BigWarpData<?> data = BigWarpInit.createBigWarpData(spimDataP, spimDataQ, names);
        int numChannels = impP.getNChannels();
        int[] movingSourceIndexList = new int[numChannels];
        for (int i = 0; i < numChannels; ++i) {
            movingSourceIndexList[i] = i;
        }
        List<SourceAndConverter<?>> sourcesxfm = BigWarp.wrapSourcesAsTransformed(data.sourceInfos, ltm.getNumdims(), data);
        ThinPlateR2LogRSplineKernelTransform xfm = ltm.getTransform();
        for (int i = 0; i < numChannels; ++i) {
            WrappedIterativeInvertibleRealTransform irXfm = new WrappedIterativeInvertibleRealTransform((RealTransform)new ThinplateSplineTransform(xfm));
            ((WarpedSource)sourcesxfm.get(i).getSpimSource()).updateTransform((RealTransform)irXfm.copy());
            ((WarpedSource)sourcesxfm.get(i).getSpimSource()).setIsTransformed(true);
        }
        ProgressWriterConsole progressWriter = new ProgressWriterConsole();
        Object exporter = null;
        return null;
    }

    public static String[] generateNames(ImagePlus imp) {
        String[] namesWithTarget = new String[imp.getNChannels() + 1];
        String[] names = BigWarpInit.namesFromImagePlus(imp);
        for (int i = 0; i < names.length; ++i) {
            namesWithTarget[i] = names[i];
        }
        namesWithTarget[imp.getNChannels()] = "target_interval";
        return namesWithTarget;
    }

    public final SpimDataMinimal createSpimData() {
        int numSetups = 1;
        int numTimepoints = 1;
        int[] ids = new int[]{349812342};
        File basePath = new File(".");
        double pw = this.spacingFull[0];
        double ph = this.spacingFull[1];
        double pd = this.spacingFull[2];
        double ox = this.offsetFull[0] / this.spacingFull[0];
        double oy = this.offsetFull[1] / this.spacingFull[1];
        double oz = this.offsetFull[2] / this.spacingFull[2];
        String punit = "px";
        FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(punit, new double[]{pw, ph, pd});
        long w = this.dimsFull[0];
        long h = this.dimsFull[1];
        long d = this.dimsFull[2];
        FinalDimensions size = new FinalDimensions(new long[]{w, h, d});
        HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>(numSetups);
        for (int s = 0; s < numSetups; ++s) {
            BasicViewSetup setup = new BasicViewSetup(ids[s], String.format("channel %d", ids[s] + 1), (Dimensions)size, (VoxelDimensions)voxelSize);
            setup.setAttribute((Entity)new Channel(ids[s] + 1));
            setups.put(ids[s], setup);
        }
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(numTimepoints);
        for (int t = 0; t < numTimepoints; ++t) {
            timepoints.add(new TimePoint(t));
        }
        AffineTransform3D sourceTransform = new AffineTransform3D();
        sourceTransform.set(pw, 0.0, 0.0, ox, 0.0, ph, 0.0, oy, 0.0, 0.0, pd, oz);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (int t = 0; t < numTimepoints; ++t) {
            for (int s = 0; s < numSetups; ++s) {
                registrations.add(new ViewRegistration(t, ids[s], sourceTransform));
            }
        }
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, new DummyImageLoader<FloatType>(new FloatType(), this), null);
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, seq, new ViewRegistrations(registrations));
        if (WrapBasicImgLoader.wrapImgLoaderIfNecessary((AbstractSpimData)spimData)) {
            System.err.println("WARNING:\nOpening <SpimData> dataset that is not suited for interactive browsing.\nConsider resaving as HDF5 for better performance.");
        }
        return spimData;
    }

    public static double[] fill(double[] in, int ndim) {
        double[] out = new double[3];
        if (in.length == 1) {
            Arrays.fill(out, in[0]);
        } else if (in.length >= ndim) {
            System.arraycopy(in, 0, out, 0, 2);
        } else {
            System.err.println("Array length is less than dimensions!");
            return null;
        }
        return out;
    }

    public static class DummyImageLoader<T>
    implements TypedBasicImgLoader<T> {
        private final T type;
        private final long[] dim;

        public DummyImageLoader(T type, BigWarpBatchTransformFOV info) {
            this.type = type;
            this.dim = info.dims;
        }

        public DummyImageLoader(T type, long[] dims) {
            this.type = type;
            this.dim = dims;
        }

        public BasicSetupImgLoader<T> getSetupImgLoader(int setupId) {
            return new BasicSetupImgLoader<T>(){

                public RandomAccessibleInterval<T> getImage(int timepointId, ImgLoaderHint ... hints) {
                    return ConstantUtils.constantRandomAccessibleInterval((Object)type, (Interval)new FinalInterval(dim));
                }

                public T getImageType() {
                    return type;
                }
            };
        }
    }
}

