/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.eval.Context;

public class ReturnStatement
implements Statement {
    private Expression value;

    public ReturnStatement(Expression value) {
        this.value = value;
    }

    public Expression getValue() {
        return this.value;
    }

    public String toString() {
        return "return " + this.value;
    }

    @Override
    public Object interpret(Context context, Object[] temps) {
        return this.value.retrieveValue(context, temps);
    }

    @Override
    public Expression getRHS() {
        return this.value;
    }

    @Override
    public ReturnStatement withRHS(Expression newRHS) {
        return new ReturnStatement(newRHS);
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        return Collections.emptySet();
    }

    @Override
    public Set<Variable> variables() {
        return this.value.variables();
    }

    @Override
    public List<Expression> getChildren() {
        return Collections.singletonList(this.value);
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex != 0) {
            throw new IllegalArgumentException();
        }
        this.value = child;
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitReturn(this);
    }
}

