/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.matrix;

import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class TransposingMatrix
extends DoubleVector
implements DeferredComputation {
    public static final int LENGTH_THRESHOLD = 1000;
    private final Vector source;
    private int[] sourceDim;
    private int sourceRowCount;
    private int sourceColCount;

    public TransposingMatrix(Vector source, AttributeMap attributes2) {
        super(attributes2);
        this.source = source;
        this.sourceDim = ((IntVector)source.getAttribute(Symbols.DIM)).toIntArray();
        this.sourceRowCount = this.sourceDim[0];
        this.sourceColCount = this.sourceDim[1];
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new TransposingMatrix(this.source, attributes2);
    }

    @Override
    public double getElementAsDouble(int vectorIndex) {
        int row2 = vectorIndex % this.sourceColCount;
        vectorIndex = (vectorIndex - row2) / this.sourceColCount;
        int col2 = vectorIndex % this.sourceRowCount;
        return this.source.getElementAsDouble(col2 + row2 * this.sourceRowCount);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public int length() {
        return this.source.length();
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.source, new IntArrayVector(this.sourceRowCount)};
    }

    @Override
    public String getComputationName() {
        return "t";
    }

    @Override
    public int getComputationDepth() {
        return this.source.getComputationDepth() + 1;
    }
}

